/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.cloudmessaging.zza;
import com.google.android.gms.cloudmessaging.zze;
import com.google.android.gms.cloudmessaging.zzr;
import com.google.android.gms.cloudmessaging.zzt;
import com.google.android.gms.cloudmessaging.zzu;
import com.google.android.gms.cloudmessaging.zzv;
import com.google.android.gms.cloudmessaging.zzw;
import com.google.android.gms.cloudmessaging.zzx;
import com.google.android.gms.cloudmessaging.zzy;
import com.google.android.gms.cloudmessaging.zzz;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;

public class Rpc {
    private static int zza = 0;
    private static PendingIntent zzb;
    private static final Executor zzc;
    @GuardedBy(value="responseCallbacks")
    private final SimpleArrayMap<String, TaskCompletionSource<Bundle>> zzd = new SimpleArrayMap();
    private final Context zze;
    private final zzr zzf;
    private final ScheduledExecutorService zzg;
    private Messenger zzh;
    private Messenger zzi;
    private zza zzj;

    public Rpc(@NonNull Context context) {
        this.zze = context;
        this.zzf = new zzr(context);
        this.zzh = new Messenger((Handler)new zzy(this, Looper.getMainLooper()));
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        scheduledThreadPoolExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
        this.zzg = scheduledThreadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Message message) {
        if (message != null && message.obj instanceof Intent) {
            Intent intent = (Intent)message.obj;
            intent.setExtrasClassLoader((ClassLoader)new zza.zza());
            if (intent.hasExtra("google.messenger")) {
                Parcelable parcelable = intent.getParcelableExtra("google.messenger");
                if (parcelable instanceof zza) {
                    this.zzj = (zza)parcelable;
                }
                if (parcelable instanceof Messenger) {
                    this.zzi = (Messenger)parcelable;
                }
            }
            Intent intent2 = (Intent)message.obj;
            Rpc rpc = this;
            String string = intent2.getAction();
            if (!"com.google.android.c2dm.intent.REGISTRATION".equals(string)) {
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    String string2 = String.valueOf(string);
                    Log.d((String)"Rpc", (String)(string2.length() != 0 ? "Unexpected response action: ".concat(string2) : new String("Unexpected response action: ")));
                }
                return;
            }
            String string3 = intent2.getStringExtra("registration_id");
            if (string3 == null) {
                string3 = intent2.getStringExtra("unregistered");
            }
            if (string3 == null) {
                Intent intent3 = intent2;
                Rpc rpc2 = rpc;
                String string4 = intent3.getStringExtra("error");
                if (string4 == null) {
                    String string5 = String.valueOf(intent3.getExtras());
                    Log.w((String)"Rpc", (String)new StringBuilder(49 + String.valueOf(string5).length()).append("Unexpected response, no error or registration id ").append(string5).toString());
                    return;
                }
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    String string6 = String.valueOf(string4);
                    Log.d((String)"Rpc", (String)(string6.length() != 0 ? "Received InstanceID error ".concat(string6) : new String("Received InstanceID error ")));
                }
                if (string4.startsWith("|")) {
                    String[] stringArray = string4.split("\\|");
                    if (stringArray.length <= 2 || !"ID".equals(stringArray[1])) {
                        String string7 = String.valueOf(string4);
                        Log.w((String)"Rpc", (String)(string7.length() != 0 ? "Unexpected structured response ".concat(string7) : new String("Unexpected structured response ")));
                        return;
                    }
                    String string8 = stringArray[2];
                    string4 = stringArray[3];
                    if (string4.startsWith(":")) {
                        string4 = string4.substring(1);
                    }
                    rpc2.zza(string8, intent3.putExtra("error", string4).getExtras());
                    return;
                }
                SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = rpc2.zzd;
                synchronized (simpleArrayMap) {
                    for (int i = 0; i < rpc2.zzd.size(); ++i) {
                        rpc2.zza((String)rpc2.zzd.keyAt(i), intent3.getExtras());
                    }
                    return;
                }
            }
            Matcher matcher = Pattern.compile("\\|ID\\|([^|]+)\\|:?+(.*)").matcher(string3);
            if (!matcher.matches()) {
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    String string9 = String.valueOf(string3);
                    Log.d((String)"Rpc", (String)(string9.length() != 0 ? "Unexpected response string: ".concat(string9) : new String("Unexpected response string: ")));
                }
                return;
            }
            String string10 = matcher.group(1);
            String string11 = matcher.group(2);
            if (string10 != null) {
                Bundle bundle = intent2.getExtras();
                bundle.putString("registration_id", string11);
                rpc.zza(string10, bundle);
            }
            return;
        }
        Log.w((String)"Rpc", (String)"Dropping invalid message");
    }

    private static synchronized void zza(Context context, Intent intent) {
        if (zzb == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            zzb = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)zzb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(String string, @Nullable Bundle bundle) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzd;
        synchronized (simpleArrayMap) {
            TaskCompletionSource taskCompletionSource = (TaskCompletionSource)this.zzd.remove((Object)string);
            if (taskCompletionSource == null) {
                String string2 = String.valueOf(string);
                Log.w((String)"Rpc", (String)(string2.length() != 0 ? "Missing callback for ".concat(string2) : new String("Missing callback for ")));
                return;
            }
            taskCompletionSource.setResult((Object)bundle);
            return;
        }
    }

    @NonNull
    public Task<Bundle> send(@NonNull Bundle bundle) {
        if (this.zzf.zzb() >= 12000000) {
            return com.google.android.gms.cloudmessaging.zze.zza(this.zze).zzb(1, bundle).continueWith(zzc, zzt.zza);
        }
        Bundle bundle2 = bundle;
        Rpc rpc = this;
        if (!(rpc.zzf.zza() != 0)) {
            return Tasks.forException((Exception)new IOException("MISSING_INSTANCEID_SERVICE"));
        }
        return rpc.zzc(bundle2).continueWithTask(zzc, (Continuation)new zzv(rpc, bundle2));
    }

    private static boolean zzb(Bundle bundle) {
        return bundle != null && bundle.containsKey("google.messenger");
    }

    private static synchronized String zza() {
        return Integer.toString(zza++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    private final Task<Bundle> zzc(Bundle bundle) {
        Object object;
        TaskCompletionSource taskCompletionSource;
        String string;
        block13: {
            Rpc rpc;
            Intent intent;
            block14: {
                String string2;
                string = Rpc.zza();
                taskCompletionSource = new TaskCompletionSource();
                object = this.zzd;
                synchronized (object) {
                    this.zzd.put((Object)string, (Object)taskCompletionSource);
                }
                String string3 = string;
                Bundle bundle2 = bundle;
                Rpc rpc2 = this;
                Intent intent2 = new Intent();
                intent2.setPackage("com.google.android.gms");
                if (rpc2.zzf.zza() == 2) {
                    intent2.setAction("com.google.iid.TOKEN_REQUEST");
                } else {
                    intent2.setAction("com.google.android.c2dm.intent.REGISTER");
                }
                intent2.putExtras(bundle2);
                Rpc.zza(rpc2.zze, intent2);
                String string4 = string3;
                intent = intent2;
                rpc = rpc2;
                intent.putExtra("kid", new StringBuilder(5 + String.valueOf(string4).length()).append("|ID|").append(string4).append("|").toString());
                if (Log.isLoggable((String)"Rpc", (int)3)) {
                    string2 = String.valueOf(intent.getExtras());
                    Log.d((String)"Rpc", (String)new StringBuilder(8 + String.valueOf(string2).length()).append("Sending ").append(string2).toString());
                }
                intent.putExtra("google.messenger", (Parcelable)rpc.zzh);
                if (rpc.zzi != null || rpc.zzj != null) {
                    string2 = Message.obtain();
                    Message.obtain().obj = intent;
                    try {
                        if (rpc.zzi != null) {
                            rpc.zzi.send((Message)string2);
                        } else {
                            rpc.zzj.zza((Message)string2);
                        }
                        break block13;
                    }
                    catch (RemoteException remoteException) {
                        if (!Log.isLoggable((String)"Rpc", (int)3)) break block14;
                        Log.d((String)"Rpc", (String)"Messenger failed, fallback to startService");
                    }
                }
            }
            if (rpc.zzf.zza() == 2) {
                rpc.zze.sendBroadcast(intent);
            } else {
                rpc.zze.startService(intent);
            }
        }
        object = this.zzg.schedule(new zzu(taskCompletionSource), 30L, TimeUnit.SECONDS);
        taskCompletionSource.getTask().addOnCompleteListener(zzc, (OnCompleteListener)new zzx(this, string, (ScheduledFuture)object));
        return taskCompletionSource.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(String string, ScheduledFuture scheduledFuture, Task task) {
        SimpleArrayMap<String, TaskCompletionSource<Bundle>> simpleArrayMap = this.zzd;
        synchronized (simpleArrayMap) {
            this.zzd.remove((Object)string);
        }
        scheduledFuture.cancel(false);
    }

    static final /* synthetic */ void zza(TaskCompletionSource taskCompletionSource) {
        if (taskCompletionSource.trySetException((Exception)new IOException("TIMEOUT"))) {
            Log.w((String)"Rpc", (String)"No response");
        }
    }

    final /* synthetic */ Task zza(Bundle bundle, Task task) throws Exception {
        if (!task.isSuccessful()) {
            return task;
        }
        if (!Rpc.zzb((Bundle)task.getResult())) {
            return task;
        }
        return this.zzc(bundle).onSuccessTask(zzc, zzw.zza);
    }

    static final /* synthetic */ Task zza(Bundle bundle) throws Exception {
        if (Rpc.zzb(bundle)) {
            return Tasks.forResult(null);
        }
        return Tasks.forResult((Object)bundle);
    }

    static final /* synthetic */ Bundle zza(Task task) throws Exception {
        if (task.isSuccessful()) {
            return (Bundle)task.getResult();
        }
        if (Log.isLoggable((String)"Rpc", (int)3)) {
            String string = String.valueOf(task.getException());
            Log.d((String)"Rpc", (String)new StringBuilder(22 + String.valueOf(string).length()).append("Error making request: ").append(string).toString());
        }
        throw new IOException("SERVICE_NOT_AVAILABLE", task.getException());
    }

    static /* synthetic */ void zza(Rpc rpc, Message message) {
        rpc.zza(message);
    }

    static {
        zzc = zzz.zza;
    }
}

