/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.google.android.gms.cloudmessaging.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@SafeParcelable.Class(creator="CloudMessageCreator")
public final class CloudMessage
extends AbstractSafeParcelable {
    public static final int PRIORITY_UNKNOWN = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_NORMAL = 2;
    @NonNull
    public static final Parcelable.Creator<CloudMessage> CREATOR = new zzb();
    @NonNull
    @SafeParcelable.Field(id=1)
    private Intent zza;
    @GuardedBy(value="this")
    private Map<String, String> zzb;

    @SafeParcelable.Constructor
    public CloudMessage(@NonNull @SafeParcelable.Param(id=1) Intent intent) {
        this.zza = intent;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CloudMessage cloudMessage = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)cloudMessage.zza, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @NonNull
    public final Intent getIntent() {
        return this.zza;
    }

    @Nullable
    public final String getSenderId() {
        return this.zza.getStringExtra("google.c.sender.id");
    }

    @Nullable
    public final String getFrom() {
        return this.zza.getStringExtra("from");
    }

    @Nullable
    public final String getTo() {
        return this.zza.getStringExtra("google.to");
    }

    @NonNull
    public final synchronized Map<String, String> getData() {
        if (this.zzb == null) {
            Bundle bundle = this.zza.getExtras();
            ArrayMap arrayMap = new ArrayMap();
            if (bundle != null) {
                for (String string : bundle.keySet()) {
                    Object object = bundle.get(string);
                    if (!(object instanceof String)) continue;
                    String string2 = (String)object;
                    if (string.startsWith("google.") || string.equals("from") || string.equals("message_type") || string.equals("collapse_key")) continue;
                    arrayMap.put((Object)string, (Object)string2);
                }
            }
            this.zzb = arrayMap;
        }
        return this.zzb;
    }

    @Nullable
    public final byte[] getRawData() {
        return this.zza.getByteArrayExtra("rawData");
    }

    @Nullable
    public final String getCollapseKey() {
        return this.zza.getStringExtra("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string = this.zza.getStringExtra("google.message_id");
        if (string == null) {
            string = this.zza.getStringExtra("message_id");
        }
        return string;
    }

    @Nullable
    public final String getMessageType() {
        return this.zza.getStringExtra("message_type");
    }

    public final long getSentTime() {
        Bundle bundle = this.zza.getExtras();
        Object object = bundle != null ? bundle.get("google.sent_time") : null;
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"CloudMessage", (String)new StringBuilder(19 + String.valueOf(string).length()).append("Invalid sent time: ").append(string).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Bundle bundle = this.zza.getExtras();
        Object object = bundle != null ? bundle.get("google.ttl") : null;
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string = String.valueOf(object);
                Log.w((String)"CloudMessage", (String)new StringBuilder(13 + String.valueOf(string).length()).append("Invalid TTL: ").append(string).toString());
            }
        }
        return 0;
    }

    public final int getOriginalPriority() {
        String string = this.zza.getStringExtra("google.original_priority");
        if (string == null) {
            string = this.zza.getStringExtra("google.priority");
        }
        return CloudMessage.zza(string);
    }

    public final int getPriority() {
        String string = this.zza.getStringExtra("google.delivered_priority");
        if (string == null) {
            if ("1".equals(this.zza.getStringExtra("google.priority_reduced"))) {
                return 2;
            }
            string = this.zza.getStringExtra("google.priority");
        }
        return CloudMessage.zza(string);
    }

    private static int zza(@Nullable String string) {
        if ("high".equals(string)) {
            return 1;
        }
        if ("normal".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    public static @interface MessagePriority {
    }
}

