/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkRequest;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzas;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzcy;
import com.google.android.gms.internal.cast.zzcz;
import com.google.android.gms.internal.cast.zzda;
import com.google.android.gms.internal.cast.zzdb;
import com.google.android.gms.internal.cast.zzqp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdc
implements zzcz {
    private static final Logger zzb = new Logger("ConnectivityMonitor");
    private final zzqp zzc;
    private final ConnectivityManager.NetworkCallback zzd;
    @Nullable
    private final ConnectivityManager zze;
    private final Map zzf;
    private final List zzg;
    private boolean zzh;
    private final Context zzi;
    private final Object zzj = new Object();
    @VisibleForTesting
    public final Set zza = Collections.synchronizedSet(new HashSet());

    static /* bridge */ /* synthetic */ void zzc(zzdc zzdc2, Network network, LinkProperties linkProperties) {
        zzdc2.zzg(network, linkProperties);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zzd(zzdc zzdc2) {
        Object object = Preconditions.checkNotNull((Object)zzdc2.zzj);
        synchronized (object) {
            Object object2 = zzdc2.zzf;
            if (object2 == null) return;
            object2 = zzdc2.zzg;
            if (object2 == null) {
                return;
            }
            zzb.d("all networks are unavailable.", new Object[0]);
            zzdc2.zzf.clear();
            zzdc2.zzg.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_2
            zzdc2.zzh();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ void zze(zzdc zzdc2, Network network) {
        Object object = Preconditions.checkNotNull((Object)zzdc2.zzj);
        synchronized (object) {
            Object object2 = zzdc2.zzf;
            if (object2 == null) return;
            object2 = zzdc2.zzg;
            if (object2 == null) {
                return;
            }
            zzb.d("the network is lost", new Object[0]);
            boolean bl = zzdc2.zzg.remove(network);
            if (bl) {
                zzdc2.zzf.remove(network);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var2_3
            zzdc2.zzh();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @TargetApi(value=23)
    public zzdc(Context context, zzqp zzqp2) {
        this.zzc = zzqp2;
        this.zzi = context;
        this.zze = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzf = Collections.synchronizedMap(new HashMap());
        this.zzg = Collections.synchronizedList(new ArrayList());
        this.zzd = new zzdb(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzg(Network network, LinkProperties linkProperties) {
        Object object = Preconditions.checkNotNull((Object)this.zzj);
        synchronized (object) {
            Object object2 = this.zzf;
            if (object2 == null) return;
            object2 = this.zzg;
            if (object2 == null) {
                return;
            }
            zzb.d("a new network is available", new Object[0]);
            boolean bl = this.zzf.containsKey(network);
            if (bl) {
                this.zzg.remove(network);
            }
            this.zzf.put(network, linkProperties);
            this.zzg.add(network);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl19 : MonitorExitStatement: MONITOREXIT : var3_4
            this.zzh();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzh() {
        if (this.zzc == null) {
            return;
        }
        Set set = this.zza;
        synchronized (set) {
            boolean bl;
            Iterator iterator = this.zza.iterator();
            while (bl = iterator.hasNext()) {
                zzcy zzcy2 = (zzcy)iterator.next();
                boolean bl2 = this.zzc.isShutdown();
                if (bl2) continue;
                zzqp zzqp2 = this.zzc;
                zzqp2.execute(new zzda(this, zzcy2));
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Override
    @TargetApi(value=23)
    public final void zza() {
        zzb.d("Start monitoring connectivity changes", new Object[0]);
        if (this.zzh) {
            return;
        }
        if (this.zze != null && zzas.zza(this.zzi)) {
            LinkProperties linkProperties;
            Network network = this.zze.getActiveNetwork();
            if (network != null && (linkProperties = this.zze.getLinkProperties(network)) != null) {
                this.zzg(network, linkProperties);
            }
            this.zze.registerNetworkCallback(new NetworkRequest.Builder().addTransportType(1).build(), this.zzd);
            this.zzh = true;
            return;
        }
    }

    @Override
    public final boolean zzb() {
        if (zzdc2.zze != null && zzas.zza(zzdc2.zzi)) {
            zzdc zzdc2 = zzdc2.zze.getActiveNetworkInfo();
            return zzdc2 != null && zzdc2.isConnected();
        }
        return false;
    }

    public final boolean zzf() {
        List list = ((zzdc)((Object)list)).zzg;
        return list != null && !list.isEmpty();
    }
}

