/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzcj;
import com.google.android.gms.cast.zzck;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaQueueItemCreator")
public class MediaQueueItem
extends AbstractSafeParcelable {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzck();
    @SafeParcelable.Field(id=2, getter="getMedia")
    @Nullable
    private MediaInfo zzb;
    @SafeParcelable.Field(id=3, getter="getItemId")
    private int zzc;
    @SafeParcelable.Field(id=4, getter="getAutoplay")
    private boolean zzd;
    @SafeParcelable.Field(id=5, getter="getStartTime")
    private double zze = Double.NaN;
    @SafeParcelable.Field(id=6, getter="getPlaybackDuration")
    private double zzf;
    @SafeParcelable.Field(id=7, getter="getPreloadTime")
    private double zzg;
    @SafeParcelable.Field(id=8, getter="getActiveTrackIds")
    @Nullable
    private long[] zzh;
    @SafeParcelable.Field(id=9)
    @Nullable
    String zza;
    @Nullable
    private JSONObject zzi;
    private final Writer zzj = new Writer();

    public double getPlaybackDuration() {
        return this.zzf;
    }

    public double getPreloadTime() {
        return this.zzg;
    }

    public double getStartTime() {
        return this.zze;
    }

    public int getItemId() {
        return this.zzc;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, Arrays.hashCode(this.zzh), String.valueOf(this.zzi)});
    }

    @Nullable
    public MediaInfo getMedia() {
        return this.zzb;
    }

    @KeepForSdk
    @NonNull
    public Writer getWriter() {
        return this.zzj;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzi;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            double d;
            int n;
            String string2;
            MediaInfo mediaInfo = this.zzb;
            if (mediaInfo != null) {
                string2 = "media";
                jSONObject.put(string2, (Object)mediaInfo.zza());
            }
            if ((n = this.zzc) != 0) {
                string2 = "itemId";
                jSONObject.put(string2, n);
            }
            jSONObject.put("autoplay", this.zzd);
            n = Double.isNaN(this.zze) ? 1 : 0;
            if (n == 0) {
                jSONObject.put("startTime", this.zze);
            }
            if ((d = this.zzf) != Double.POSITIVE_INFINITY) {
                String string3 = "playbackDuration";
                jSONObject.put(string3, d);
            }
            jSONObject.put("preloadTime", this.zzg);
            long[] lArray = this.zzh;
            if (lArray != null) {
                string2 = new JSONArray();
                long[] lArray2 = this.zzh;
                int n2 = lArray2.length;
                for (int i = 0; i < n2; ++i) {
                    string2.put(lArray2[i]);
                }
                jSONObject.put("activeTrackIds", (Object)string2);
            }
            if ((this = this.zzi) == null) return jSONObject;
            String string4 = "customData";
            jSONObject.put(string4, (Object)this);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public MediaQueueItem(@NonNull JSONObject json) throws JSONException {
        this(null, 0, true, Double.NaN, Double.POSITIVE_INFINITY, 0.0, null, null);
        void var1_1;
        this.fromJson((JSONObject)var1_1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    MediaQueueItem(@SafeParcelable.Param(id=2) @Nullable MediaInfo mediaInfo, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) double d, @SafeParcelable.Param(id=6) double d2, @SafeParcelable.Param(id=7) double d3, @SafeParcelable.Param(id=8) @Nullable long[] lArray, @SafeParcelable.Param(id=9) @Nullable String string2) {
        this.zzb = mediaInfo;
        this.zzc = n;
        this.zzd = bl;
        this.zze = d;
        this.zzf = d2;
        this.zzg = d3;
        this.zzh = lArray;
        this.zza = string2;
        if (this.zza == null) {
            this.zzi = null;
            return;
        }
        try {
            this.zzi = new JSONObject(this.zza);
            return;
        }
        catch (JSONException jSONException) {
            this.zzi = null;
            this.zza = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzi;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getMedia(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getItemId());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.getAutoplay());
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)5, (double)this.getStartTime());
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)6, (double)this.getPlaybackDuration());
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)7, (double)this.getPreloadTime());
        SafeParcelWriter.writeLongArray((Parcel)var1_1, (int)8, (long[])this.getActiveTrackIds(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)9, (String)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)var1_1;
        JSONObject jSONObject2 = this.zzi;
        boolean bl2 = jSONObject2 == null;
        if (bl2 != (bl = (jSONObject = mediaQueueItem.zzi) == null)) {
            return false;
        }
        if (jSONObject2 != null && jSONObject != null && !JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) {
            return false;
        }
        return CastUtils.zze((Object)this.zzb, (Object)mediaQueueItem.zzb) && this.zzc == mediaQueueItem.zzc && this.zzd == mediaQueueItem.zzd && (Double.isNaN(this.zze) && Double.isNaN(mediaQueueItem.zze) || this.zze == mediaQueueItem.zze) && this.zzf == mediaQueueItem.zzf && this.zzg == mediaQueueItem.zzg && Arrays.equals(this.zzh, mediaQueueItem.zzh);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @KeepForSdk
    public boolean fromJson(@NonNull JSONObject json) throws JSONException {
        block13: {
            if (!json.has("media")) break block13;
            var2_2 = "media";
            this.zzb = new MediaInfo(var1_1.getJSONObject(var2_2));
            var2_3 = true;
lbl5:
            // 2 sources

            while (true) {
                block14: {
                    if (var1_1.has("itemId") && this.zzc != (var3_4 = var1_1.getInt("itemId"))) {
                        this.zzc = var3_4;
                        var2_3 = true;
                    }
                    if (var1_1.has("autoplay") && this.zzd != (var3_4 = (int)var1_1.getBoolean("autoplay"))) {
                        this.zzd = var3_4;
                        var2_3 = true;
                    }
                    if (Double.isNaN(var5_6 = var1_1.optDouble("startTime")) == Double.isNaN(this.zze)) break block14;
lbl13:
                    // 2 sources

                    while (true) {
                        this.zze = var5_6;
                        var2_3 = true;
                        while (true) {
                            block15: {
                                block16: {
                                    if (var1_1.has("playbackDuration") && Math.abs((var7_7 = var1_1.getDouble("playbackDuration")) - this.zzf) > 1.0E-7) {
                                        this.zzf = var7_7;
                                        var2_3 = true;
                                    }
                                    if (var1_1.has("preloadTime") && Math.abs((var5_6 = var1_1.getDouble("preloadTime")) - this.zzg) > 1.0E-7) {
                                        this.zzg = var5_6;
                                        var2_3 = true;
                                    }
                                    if (!var1_1.has("activeTrackIds")) break block15;
                                    var4_8 /* !! */  = var1_1.getJSONArray("activeTrackIds");
                                    var9_9 = var4_8 /* !! */ .length();
                                    var10_10 = new long[var9_9];
                                    var3_4 = 0;
                                    while (var3_4 < var9_9) {
                                        v0 = var3_4++;
                                        var10_10[v0] = var4_8 /* !! */ .getLong(v0);
                                    }
                                    var3_5 = this.zzh;
                                    if (var3_5 == null) {
                                        var3_4 = 1;
                                        var4_8 /* !! */  = (JSONArray)var10_10;
lbl36:
                                        // 5 sources

                                        while (true) {
                                            if (var3_4 != 0) {
                                                this.zzh = (long[])var4_8 /* !! */ ;
                                                var2_3 = true;
                                            }
                                            if (var1_1.has("customData")) {
                                                this.zzi = var1_1.getJSONObject("customData");
                                                return true;
                                            }
                                            return var2_3;
                                        }
                                    }
                                    if (var3_5.length == var9_9) break block16;
                                    var3_4 = 1;
                                    var4_8 /* !! */  = (JSONArray)var10_10;
                                    ** GOTO lbl36
                                }
                                for (var3_4 = 0; var3_4 < var9_9; ++var3_4) {
                                    if (this.zzh[var3_4] == var10_10[var3_4]) continue;
                                    var3_4 = 1;
                                    var4_8 /* !! */  = (JSONArray)var10_10;
                                    ** GOTO lbl36
                                }
                                var3_4 = 0;
                                var4_8 /* !! */  = (JSONArray)var10_10;
                                ** GOTO lbl36
                            }
                            var3_4 = 0;
                            var4_8 /* !! */  = null;
                            ** continue;
                            break;
                        }
                        break;
                    }
                }
                if (Double.isNaN(var5_6) || !(Math.abs(var5_6 - this.zze) > 1.0E-7)) ** continue;
                ** continue;
                break;
            }
        }
        var2_3 = false;
        ** while (true)
    }

    public boolean getAutoplay() {
        return this.zzd;
    }

    @Nullable
    public long[] getActiveTrackIds() {
        return this.zzh;
    }

    /* synthetic */ MediaQueueItem(MediaInfo mediaInfo, zzcj zzcj2) {
        this(mediaInfo, 0, true, Double.NaN, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    /* synthetic */ MediaQueueItem(MediaQueueItem mediaQueueItem, zzcj zzcj2) {
        this(mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzb == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzi = mediaQueueItem.getCustomData();
    }

    final void zzi() throws IllegalArgumentException {
        if (this.zzb == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zze) || !(this.zze < 0.0)) {
            if (Double.isNaN(this.zzf)) {
                throw new IllegalArgumentException("playbackDuration cannot be NaN.");
            }
            if (Double.isNaN(this.zzg) || this.zzg < 0.0) {
                throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
            }
        } else {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
    }

    @KeepForSdk
    public class Writer {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setActiveTrackIds(@Nullable long[] activeTrackIds) {
            void var1_1;
            MediaQueueItem.this.zzh = (long[])var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAutoplay(boolean autoplay) {
            void var1_1;
            MediaQueueItem.this.zzd = (boolean)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            MediaQueueItem.this.zzi = (JSONObject)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setItemId(int itemId) {
            void var1_1;
            MediaQueueItem.this.zzc = (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMedia(@Nullable MediaInfo media) {
            void var1_1;
            MediaQueueItem.this.zzb = (MediaInfo)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setPlaybackDuration(double playbackDuration) {
            void var1_1;
            if (Double.isNaN(playbackDuration)) {
                throw new IllegalArgumentException("playbackDuration cannot be NaN.");
            }
            MediaQueueItem.this.zzf = (double)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setPreloadTime(double preloadTime) {
            void var1_1;
            if (Double.isNaN(preloadTime) || var1_1 < 0.0) {
                throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
            }
            MediaQueueItem.this.zzg = (double)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStartTime(double startTime) {
            void var1_1;
            if (!Double.isNaN(startTime) && var1_1 < 0.0) {
                throw new IllegalArgumentException("startTime cannot be negative.");
            }
            MediaQueueItem.this.zze = (double)var1_1;
        }
    }

    public static class Builder {
        private final MediaQueueItem zza;

        @NonNull
        public Builder clearItemId() {
            this.zza.getWriter().setItemId(0);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActiveTrackIds(@NonNull long[] activeTrackIds) {
            void var1_1;
            this.zza.getWriter().setActiveTrackIds((long[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAutoplay(boolean autoplay) {
            void var1_1;
            this.zza.getWriter().setAutoplay((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@NonNull JSONObject customData) {
            void var1_1;
            this.zza.getWriter().setCustomData((JSONObject)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setItemId(int itemId) {
            void var1_1;
            this.zza.getWriter().setItemId((int)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPlaybackDuration(double playbackDuration) {
            void var1_1;
            this.zza.getWriter().setPlaybackDuration((double)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            void var1_1;
            this.zza.getWriter().setPreloadTime((double)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            void var1_1;
            this.zza.getWriter().setStartTime((double)var1_1);
            return this;
        }

        @NonNull
        public MediaQueueItem build() {
            this.zza.zzi();
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull MediaInfo media) throws IllegalArgumentException {
            void var1_1;
            this.zza = new MediaQueueItem((MediaInfo)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull MediaQueueItem item) throws IllegalArgumentException {
            void var1_1;
            this.zza = new MediaQueueItem((MediaQueueItem)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull JSONObject json) throws JSONException {
            void var1_1;
            this.zza = new MediaQueueItem((JSONObject)var1_1);
        }
    }
}

