/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueData;
import com.google.android.gms.cast.RequestData;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzcb;
import com.google.android.gms.cast.zzcc;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaLoadRequestDataCreator")
public class MediaLoadRequestData
extends AbstractSafeParcelable
implements RequestData {
    public static final double PLAYBACK_RATE_MIN = 0.5;
    public static final double PLAYBACK_RATE_MAX = 2.0;
    public static final long PLAY_POSITION_UNASSIGNED = -1L;
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<MediaLoadRequestData> CREATOR;
    private static final Logger zzb;
    @SafeParcelable.Field(id=2, getter="getMediaInfo")
    @Nullable
    private final MediaInfo zzc;
    @SafeParcelable.Field(id=3, getter="getQueueData")
    @Nullable
    private final MediaQueueData zzd;
    @SafeParcelable.Field(id=4, getter="getAutoplay")
    @Nullable
    private final Boolean zze;
    @SafeParcelable.Field(id=5, getter="getCurrentTime")
    private final long zzf;
    @SafeParcelable.Field(id=6, getter="getPlaybackRate")
    private final double zzg;
    @SafeParcelable.Field(id=7, getter="getActiveTrackIds")
    @Nullable
    private final long[] zzh;
    @SafeParcelable.Field(id=8)
    @Nullable
    String zza;
    @Nullable
    private final JSONObject zzi;
    @SafeParcelable.Field(id=9, getter="getCredentials")
    @Nullable
    private final String zzj;
    @SafeParcelable.Field(id=10, getter="getCredentialsType")
    @Nullable
    private final String zzk;
    @SafeParcelable.Field(id=11, getter="getAtvCredentials")
    @Nullable
    private final String zzl;
    @SafeParcelable.Field(id=12, getter="getAtvCredentialsType")
    @Nullable
    private final String zzm;
    @SafeParcelable.Field(id=13, getter="getRequestId")
    private long zzn;

    public double getPlaybackRate() {
        return this.zzg;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, String.valueOf(this.zzi), this.zzj, this.zzk, this.zzl, this.zzm, this.zzn});
    }

    public long getCurrentTime() {
        return this.zzf;
    }

    @Override
    @KeepForSdk
    public long getRequestId() {
        return this.zzn;
    }

    @Nullable
    public MediaInfo getMediaInfo() {
        return this.zzc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static MediaLoadRequestData fromJson(@NonNull JSONObject json) {
        Builder builder = new Builder();
        try {
            Object object;
            int n = object.has("media");
            if (n != 0) {
                builder.setMediaInfo(new MediaInfo(object.getJSONObject("media")));
            }
            if ((n = object.has("queueData")) != 0) {
                MediaQueueData.Builder builder2 = new MediaQueueData.Builder();
                builder2.zza(object.getJSONObject("queueData"));
                builder.setQueueData(builder2.build());
            }
            if ((n = object.has("autoplay")) != 0) {
                builder.setAutoplay(object.getBoolean("autoplay"));
            } else {
                builder.setAutoplay(null);
            }
            if ((n = object.has("currentTime")) != 0) {
                builder.setCurrentTime(CastUtils.secToMillisec(object.getDouble("currentTime")));
            } else {
                builder.setCurrentTime(-1L);
            }
            builder.setPlaybackRate(object.optDouble("playbackRate", 1.0));
            builder.setCredentials(CastUtils.optStringOrNull(object, "credentials"));
            builder.setCredentialsType(CastUtils.optStringOrNull(object, "credentialsType"));
            builder.setAtvCredentials(CastUtils.optStringOrNull(object, "atvCredentials"));
            builder.setAtvCredentialsType(CastUtils.optStringOrNull(object, "atvCredentialsType"));
            builder.zza(object.optLong("requestId"));
            JSONArray jSONArray = object.optJSONArray("activeTrackIds");
            if (jSONArray != null) {
                int n2;
                long[] lArray = new long[jSONArray.length()];
                n = 0;
                while (n < (n2 = jSONArray.length())) {
                    int n3 = n++;
                    lArray[n3] = jSONArray.getLong(n3);
                }
                builder.setActiveTrackIds(lArray);
            }
            builder.setCustomData(object.optJSONObject("customData"));
            return builder.build();
        }
        catch (JSONException jSONException) {
            return builder.build();
        }
    }

    @Nullable
    public MediaQueueData getQueueData() {
        return this.zzd;
    }

    @Nullable
    public Boolean getAutoplay() {
        return this.zze;
    }

    @Nullable
    public String getCredentials() {
        return this.zzj;
    }

    @Nullable
    public String getCredentialsType() {
        return this.zzk;
    }

    @Override
    @Nullable
    public JSONObject getCustomData() {
        return this.zzi;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            MediaQueueData mediaQueueData;
            String string2;
            MediaInfo mediaInfo = this.zzc;
            if (mediaInfo != null) {
                string2 = "media";
                jSONObject.put(string2, (Object)mediaInfo.zza());
            }
            if ((mediaQueueData = this.zzd) != null) {
                string2 = "queueData";
                jSONObject.put(string2, (Object)mediaQueueData.zza());
            }
            jSONObject.putOpt("autoplay", (Object)this.zze);
            long l = this.zzf;
            if (l != -1L) {
                String string3 = "currentTime";
                jSONObject.put(string3, CastUtils.millisecToSec(l));
            }
            jSONObject.put("playbackRate", this.zzg);
            jSONObject.putOpt("credentials", (Object)this.zzj);
            jSONObject.putOpt("credentialsType", (Object)this.zzk);
            jSONObject.putOpt("atvCredentials", (Object)this.zzl);
            jSONObject.putOpt("atvCredentialsType", (Object)this.zzm);
            long[] lArray = this.zzh;
            if (lArray != null) {
                long[] lArray2;
                int n;
                void var1_9;
                string2 = new JSONArray();
                boolean bl = false;
                while (var1_9 < (n = (lArray2 = this.zzh).length)) {
                    void v0 = var1_9++;
                    string2.put((int)v0, lArray2[v0]);
                }
                jSONObject.put("activeTrackIds", (Object)string2);
            }
            jSONObject.putOpt("customData", (Object)this.zzi);
            jSONObject.put("requestId", this.zzn);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Object[] objectArray = new Object[]{jSONException};
            zzb.e("Error transforming MediaLoadRequestData into JSONObject", objectArray);
            return new JSONObject();
        }
    }

    static {
        zzb = new Logger("MediaLoadRequestData");
        CREATOR = new zzcc();
    }

    @SafeParcelable.Constructor
    MediaLoadRequestData(@SafeParcelable.Param(id=2) @Nullable MediaInfo mediaInfo, @SafeParcelable.Param(id=3) @Nullable MediaQueueData mediaQueueData, @SafeParcelable.Param(id=4) @Nullable Boolean bl, @SafeParcelable.Param(id=5) long l, @SafeParcelable.Param(id=6) double d, @SafeParcelable.Param(id=7) @Nullable long[] lArray, @SafeParcelable.Param(id=8) @Nullable String string2, @SafeParcelable.Param(id=9) @Nullable String string3, @SafeParcelable.Param(id=10) @Nullable String string4, @SafeParcelable.Param(id=11) @Nullable String string5, @SafeParcelable.Param(id=12) @Nullable String string6, @SafeParcelable.Param(id=13) long l2) {
        this(mediaInfo, mediaQueueData, bl, l, d, lArray, CastUtils.jsonStringToJsonObject(string2), string3, string4, string5, string6, l2);
    }

    private MediaLoadRequestData(@Nullable MediaInfo mediaInfo, @Nullable MediaQueueData mediaQueueData, @Nullable Boolean bl, long l, double d, @Nullable long[] lArray, @Nullable JSONObject jSONObject, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, long l2) {
        this.zzc = mediaInfo;
        this.zzd = mediaQueueData;
        this.zze = bl;
        this.zzf = l;
        this.zzg = d;
        this.zzh = lArray;
        this.zzi = jSONObject;
        this.zzj = string2;
        this.zzk = string3;
        this.zzl = string4;
        this.zzm = string5;
        this.zzn = l2;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setRequestId(long requestId) {
        void var1_1;
        this.zzn = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzi;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getMediaInfo(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getQueueData(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)var1_1, (int)4, (Boolean)this.getAutoplay(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)5, (long)this.getCurrentTime());
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)6, (double)this.getPlaybackRate());
        SafeParcelWriter.writeLongArray((Parcel)var1_1, (int)7, (long[])this.getActiveTrackIds(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.getCredentials(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.getCredentialsType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)11, (String)this.zzl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.zzm, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeLong((Parcel)v1, (int)13, (long)this.getRequestId());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        MediaLoadRequestData mediaLoadRequestData;
        if (this == mediaLoadRequestData) {
            return true;
        }
        if (!(mediaLoadRequestData instanceof MediaLoadRequestData)) {
            return false;
        }
        mediaLoadRequestData = mediaLoadRequestData;
        if (!JsonUtils.areJsonValuesEquivalent((Object)this.zzi, (Object)mediaLoadRequestData.zzi)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.zzc), (Object)((Object)mediaLoadRequestData.zzc)) && Objects.equal((Object)((Object)this.zzd), (Object)((Object)mediaLoadRequestData.zzd)) && Objects.equal((Object)this.zze, (Object)mediaLoadRequestData.zze) && this.zzf == mediaLoadRequestData.zzf && this.zzg == mediaLoadRequestData.zzg && Arrays.equals(this.zzh, mediaLoadRequestData.zzh) && Objects.equal((Object)this.zzj, (Object)mediaLoadRequestData.zzj) && Objects.equal((Object)this.zzk, (Object)mediaLoadRequestData.zzk) && Objects.equal((Object)this.zzl, (Object)mediaLoadRequestData.zzl) && Objects.equal((Object)this.zzm, (Object)mediaLoadRequestData.zzm) && this.zzn == mediaLoadRequestData.zzn;
    }

    @Nullable
    public long[] getActiveTrackIds() {
        return this.zzh;
    }

    @Nullable
    public final String zza() {
        return this.zzl;
    }

    @Nullable
    public final String zzb() {
        return this.zzm;
    }

    /* synthetic */ MediaLoadRequestData(MediaInfo mediaInfo, MediaQueueData mediaQueueData, Boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3, String string4, String string5, long l2, zzcb zzcb2) {
        this(mediaInfo, mediaQueueData, bl, l, d, lArray, jSONObject, string2, string3, string4, string5, l2);
    }

    public static class Builder {
        @Nullable
        private MediaInfo zza;
        @Nullable
        private MediaQueueData zzb;
        @Nullable
        private Boolean zzc = true;
        private long zzd = -1L;
        private double zze = 1.0;
        @Nullable
        private long[] zzf;
        @Nullable
        private JSONObject zzg;
        @Nullable
        private String zzh;
        @Nullable
        private String zzi;
        @Nullable
        private String zzj;
        @Nullable
        private String zzk;
        private long zzl;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setActiveTrackIds(@Nullable long[] activeTrackIds) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAtvCredentials(@Nullable String atvCredentials) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAtvCredentialsType(@Nullable String atvCredentialsType) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAutoplay(@Nullable Boolean autoplay) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentials(@Nullable String credentials) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCredentialsType(@Nullable String credentialsType) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrentTime(long currentTime) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMediaInfo(@Nullable MediaInfo mediaInfo) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPlaybackRate(double playbackRate) {
            void var1_1;
            if (Double.compare(playbackRate, 2.0) > 0 || Double.compare((double)var1_1, 0.5) < 0) {
                throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
            }
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setQueueData(@Nullable MediaQueueData queueData) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public MediaLoadRequestData build() {
            return new MediaLoadRequestData(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, null);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull MediaLoadRequestData requestData) {
            void var1_1;
            this.zza = var1_1.getMediaInfo();
            this.zzb = var1_1.getQueueData();
            this.zzc = var1_1.getAutoplay();
            this.zzd = var1_1.getCurrentTime();
            this.zze = var1_1.getPlaybackRate();
            this.zzf = var1_1.getActiveTrackIds();
            this.zzg = var1_1.getCustomData();
            this.zzh = var1_1.getCredentials();
            this.zzi = var1_1.getCredentialsType();
            this.zzj = var1_1.zza();
            this.zzk = var1_1.zzb();
            this.zzl = var1_1.getRequestId();
        }

        @NonNull
        public final Builder zza(long l) {
            this.zzl = l;
            return this;
        }
    }
}

