/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzbz;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaLiveSeekableRangeCreator")
public class MediaLiveSeekableRange
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<MediaLiveSeekableRange> CREATOR;
    private static final Logger zza;
    @SafeParcelable.Field(id=2, getter="getStartTime")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getEndTime")
    private final long zzc;
    @SafeParcelable.Field(id=4, getter="isMovingWindow")
    private final boolean zzd;
    @SafeParcelable.Field(id=5, getter="isLiveDone")
    private final boolean zze;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzb, this.zzc, this.zzd, this.zze});
    }

    public long getEndTime() {
        return this.zzc;
    }

    public long getStartTime() {
        return this.zzb;
    }

    static {
        zza = new Logger("MediaLiveSeekableRange");
        CREATOR = new zzbz();
    }

    @SafeParcelable.Constructor
    MediaLiveSeekableRange(@SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2) {
        this.zzb = Math.max(l, 0L);
        this.zzc = Math.max(l2, 0L);
        this.zzd = bl;
        this.zze = bl2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getStartTime());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getEndTime());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.isMovingWindow());
        void v1 = var1_1;
        SafeParcelWriter.writeBoolean((Parcel)v1, (int)5, (boolean)this.isLiveDone());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object other) {
        MediaLiveSeekableRange mediaLiveSeekableRange;
        if (this == mediaLiveSeekableRange) {
            return true;
        }
        if (!(mediaLiveSeekableRange instanceof MediaLiveSeekableRange)) {
            return false;
        }
        mediaLiveSeekableRange = mediaLiveSeekableRange;
        return this.zzb == mediaLiveSeekableRange.zzb && this.zzc == mediaLiveSeekableRange.zzc && this.zzd == mediaLiveSeekableRange.zzd && this.zze == mediaLiveSeekableRange.zze;
    }

    public boolean isLiveDone() {
        return this.zze;
    }

    public boolean isMovingWindow() {
        return this.zzd;
    }

    @Nullable
    static MediaLiveSeekableRange zza(@Nullable JSONObject object) {
        if (object == null) {
            return null;
        }
        if (!object.has("start") || !object.has("end")) {
            return null;
        }
        try {
            long l = CastUtils.secToMillisec(object.getDouble("start"));
            long l2 = CastUtils.secToMillisec(object.getDouble("end"));
            boolean bl = object.optBoolean("isMovingWindow");
            boolean bl2 = object.optBoolean("isLiveDone");
            MediaLiveSeekableRange mediaLiveSeekableRange = new MediaLiveSeekableRange(l, l2, bl, bl2);
            return mediaLiveSeekableRange;
        }
        catch (JSONException jSONException) {
            object = object.toString();
            zza.e("Ignoring Malformed MediaLiveSeekableRange: ".concat((String)object), new Object[0]);
            return null;
        }
    }

    final JSONObject zzb() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("start", CastUtils.millisecToSec(this.zzb));
            jSONObject.put("end", CastUtils.millisecToSec(this.zzc));
            jSONObject.put("isMovingWindow", this.zzd);
            jSONObject.put("isLiveDone", this.zze);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zza.e("Error transforming MediaLiveSeekableRange into JSONObject", new Object[0]);
            return new JSONObject();
        }
    }

    public static class Builder {
        private long zza;
        private long zzb;
        private boolean zzc;
        private boolean zzd;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEndTime(long endTime) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIsLiveDone(boolean isLiveDone) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIsMovingWindow(boolean isMovingWindow) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStartTime(long startTime) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @NonNull
        public MediaLiveSeekableRange build() {
            return new MediaLiveSeekableRange(this.zza, this.zzb, this.zzc, this.zzd);
        }
    }
}

