/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.HlsSegmentFormat;
import com.google.android.gms.cast.HlsVideoSegmentFormat;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.VastAdsRequest;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzby;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.internal.cast.zzfe;
import com.google.android.gms.internal.cast.zzfh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaInfoCreator")
public class MediaInfo
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final long UNKNOWN_START_ABSOLUTE_TIME = -1L;
    @NonNull
    public static final Parcelable.Creator<MediaInfo> CREATOR;
    public static final long zza;
    @SafeParcelable.Field(id=2, getter="getContentId")
    @Nullable
    private String zzc;
    @SafeParcelable.Field(id=3, getter="getStreamType")
    private int zzd;
    @SafeParcelable.Field(id=4, getter="getContentType")
    @Nullable
    private String zze;
    @SafeParcelable.Field(id=5, getter="getMetadata")
    @Nullable
    private MediaMetadata zzf;
    @SafeParcelable.Field(id=6, getter="getStreamDuration")
    private long zzg;
    @SafeParcelable.Field(id=7, getter="getMediaTracks")
    @Nullable
    private List zzh;
    @SafeParcelable.Field(id=8, getter="getTextTrackStyle")
    @Nullable
    private TextTrackStyle zzi;
    @SafeParcelable.Field(id=9)
    @Nullable
    String zzb;
    @SafeParcelable.Field(id=10, getter="getAdBreaks")
    @Nullable
    private List zzj;
    @SafeParcelable.Field(id=11, getter="getAdBreakClips")
    @Nullable
    private List zzk;
    @SafeParcelable.Field(id=12, getter="getEntity")
    @Nullable
    private String zzl;
    @SafeParcelable.Field(id=13, getter="getVmapAdsRequest")
    @Nullable
    private VastAdsRequest zzm;
    @SafeParcelable.Field(id=14, getter="getStartAbsoluteTime")
    private long zzn;
    @SafeParcelable.Field(id=15, getter="getAtvEntity")
    @Nullable
    private String zzo;
    @SafeParcelable.Field(id=16, getter="getContentUrl")
    @Nullable
    private String zzp;
    @SafeParcelable.Field(id=17, getter="getHlsSegmentFormat")
    @HlsSegmentFormat
    @Nullable
    private String zzq;
    @SafeParcelable.Field(id=18, getter="getHlsVideoSegmentFormat")
    @HlsVideoSegmentFormat
    @Nullable
    private String zzr;
    @Nullable
    private JSONObject zzs;
    private final Writer zzt = new Writer();

    public int getStreamType() {
        return this.zzd;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzc, this.zzd, this.zze, this.zzf, this.zzg, String.valueOf(this.zzs), this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, this.zzn, this.zzo, this.zzq, this.zzr});
    }

    public long getStartAbsoluteTime() {
        return this.zzn;
    }

    public long getStreamDuration() {
        return this.zzg;
    }

    @KeepForSdk
    @NonNull
    public Writer getWriter() {
        return this.zzt;
    }

    @Nullable
    public MediaMetadata getMetadata() {
        return this.zzf;
    }

    @Nullable
    public TextTrackStyle getTextTrackStyle() {
        return this.zzi;
    }

    @Nullable
    public VastAdsRequest getVmapAdsRequest() {
        return this.zzm;
    }

    @NonNull
    public String getContentId() {
        Object this_ = this_.zzc;
        if (this_ == null) {
            return "";
        }
        return this_;
    }

    @Nullable
    public String getContentType() {
        return this.zze;
    }

    @Nullable
    public String getContentUrl() {
        return this.zzp;
    }

    @Nullable
    public String getEntity() {
        return this.zzl;
    }

    @HlsSegmentFormat
    @Nullable
    public String getHlsSegmentFormat() {
        return this.zzq;
    }

    @HlsVideoSegmentFormat
    @Nullable
    public String getHlsVideoSegmentFormat() {
        return this.zzr;
    }

    @Nullable
    public List<AdBreakClipInfo> getAdBreakClips() {
        Object this_ = this_.zzk;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public List<AdBreakInfo> getAdBreaks() {
        Object this_ = this_.zzj;
        if (this_ == null) {
            return null;
        }
        return Collections.unmodifiableList(this_);
    }

    @Nullable
    public List<MediaTrack> getMediaTracks() {
        return this.zzh;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzs;
    }

    static {
        zza = CastUtils.secToMillisec(-1L);
        CREATOR = new zzby();
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.optString("contentId"), -1, null, null, -1L, null, null, null, null, null, null, null, -1L, null, null, null, null);
        double d;
        double d2;
        int n;
        String string2 = jSONObject.optString("streamType", "NONE");
        this.zzd = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zze = CastUtils.optStringOrNull(jSONObject, "contentType");
        if (jSONObject.has("metadata")) {
            string2 = jSONObject.getJSONObject("metadata");
            n = string2.getInt("metadataType");
            this.zzf = new MediaMetadata(n);
            this.zzf.zzc((JSONObject)string2);
        }
        this.zzg = -1L;
        if (this.zzd != 2 && jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d2 = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d2) && d2 >= 0.0) {
            this.zzg = CastUtils.secToMillisec(d2);
        }
        if (!jSONObject.has("tracks")) {
            this.zzh = null;
        } else {
            JSONObject jSONObject2;
            ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
            JSONArray jSONArray = jSONObject.getJSONArray("tracks");
            for (int n2 = 0; n2 < jSONArray.length(); jSONObject2 = jSONObject2.optJSONObject("customData"), ++n2) {
                zzfh zzfh2;
                String string3;
                jSONObject2 = jSONArray.getJSONObject(n2);
                long l = jSONObject2.getLong("trackId");
                String string4 = jSONObject2.optString("type");
                n = "TEXT".equals(string4) ? 1 : ("AUDIO".equals(string4) ? 2 : ("VIDEO".equals(string4) ? 3 : 0));
                String string5 = CastUtils.optStringOrNull(jSONObject2, "trackContentId");
                String string6 = CastUtils.optStringOrNull(jSONObject2, "trackContentType");
                String string7 = CastUtils.optStringOrNull(jSONObject2, "name");
                String string8 = CastUtils.optStringOrNull(jSONObject2, "language");
                int n3 = jSONObject2.has("subtype") ? ("SUBTITLES".equals(string3 = jSONObject2.getString("subtype")) ? 1 : ("CAPTIONS".equals(string3) ? 2 : ("DESCRIPTIONS".equals(string3) ? 3 : ("CHAPTERS".equals(string3) ? 4 : ("METADATA".equals(string3) ? 5 : -1))))) : 0;
                if (jSONObject2.has("roles")) {
                    zzfe zzfe2 = new zzfe();
                    JSONArray jSONArray2 = jSONObject2.getJSONArray("roles");
                    for (int i = 0; i < jSONArray2.length(); ++i) {
                        zzfe2.zzb(jSONArray2.optString(i));
                    }
                    zzfh2 = zzfe2.zzc();
                } else {
                    zzfh2 = null;
                }
                arrayList.add(new MediaTrack(l, n, string5, string6, string7, string8, n3, zzfh2, jSONObject2));
            }
            this.zzh = new ArrayList(arrayList);
        }
        if (jSONObject.has("textTrackStyle")) {
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.fromJson(jSONObject.getJSONObject("textTrackStyle"));
            this.zzi = textTrackStyle;
        } else {
            this.zzi = null;
        }
        this.zzr(jSONObject);
        this.zzs = jSONObject.optJSONObject("customData");
        this.zzl = CastUtils.optStringOrNull(jSONObject, "entity");
        this.zzo = CastUtils.optStringOrNull(jSONObject, "atvEntity");
        this.zzm = VastAdsRequest.fromJson(jSONObject.optJSONObject("vmapAdsRequest"));
        if (jSONObject.has("startAbsoluteTime") && !jSONObject.isNull("startAbsoluteTime") && !Double.isNaN(d = jSONObject.optDouble("startAbsoluteTime")) && !Double.isInfinite(d) && d >= 0.0) {
            this.zzn = CastUtils.secToMillisec(d);
        }
        if (jSONObject.has("contentUrl")) {
            this.zzp = jSONObject.optString("contentUrl");
        }
        this.zzq = CastUtils.optStringOrNull(jSONObject, "hlsSegmentFormat");
        this.zzr = CastUtils.optStringOrNull(jSONObject, "hlsVideoSegmentFormat");
    }

    /*
     * Unable to fully structure code
     */
    @SafeParcelable.Constructor
    MediaInfo(@SafeParcelable.Param(id=2) @Nullable String var1_1, @SafeParcelable.Param(id=3) int var2_2, @SafeParcelable.Param(id=4) @Nullable String var3_3, @SafeParcelable.Param(id=5) @Nullable MediaMetadata var4_4, @SafeParcelable.Param(id=6) long var5_5, @SafeParcelable.Param(id=7) @Nullable List var7_6, @SafeParcelable.Param(id=8) @Nullable TextTrackStyle var8_7, @SafeParcelable.Param(id=9) @Nullable String var9_8, @SafeParcelable.Param(id=10) @Nullable List var10_9, @SafeParcelable.Param(id=11) @Nullable List var11_10, @SafeParcelable.Param(id=12) @Nullable String var12_11, @SafeParcelable.Param(id=13) @Nullable VastAdsRequest var13_12, @SafeParcelable.Param(id=14) long var14_13, @SafeParcelable.Param(id=15) @Nullable String var16_14, @SafeParcelable.Param(id=16) @Nullable String var17_15, @SafeParcelable.Param(id=17) @Nullable @HlsSegmentFormat String var18_16, @SafeParcelable.Param(id=18) @Nullable @HlsVideoSegmentFormat String var19_17) {
        super();
        this.zzc = var1_1;
        this.zzd = var2_2;
        this.zze = var3_3;
        this.zzf = var4_4;
        this.zzg = var5_5;
        this.zzh = var7_6;
        this.zzi = var8_7;
        this.zzb = var9_8;
        if (this.zzb != null) {
            this.zzs = new JSONObject(this.zzb);
lbl14:
            // 3 sources

            while (true) {
                this.zzj = var10_9;
                this.zzk = var11_10;
                this.zzl = var12_11;
                this.zzm = var13_12;
                this.zzn = var14_13;
                this.zzo = var16_14;
                this.zzp = var17_15;
                this.zzq = var18_16;
                this.zzr = var19_17;
                if (this.zzc == null && this.zzp == null && this.zzl == null) {
                    throw new IllegalArgumentException("Either contentID or contentUrl or entity should be set");
                }
                return;
            }
        }
        this.zzs = null;
        ** GOTO lbl14
        catch (JSONException v0) {
            this.zzs = null;
            this.zzb = null;
            ** continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTextTrackStyle(@NonNull TextTrackStyle textTrackStyle) {
        void var1_1;
        this.zzi = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzs;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zzb = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getContentId(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getStreamType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getContentType(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)5, (Parcelable)this.getMetadata(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.getStreamDuration());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)7, this.getMediaTracks(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.getTextTrackStyle(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)10, this.getAdBreaks(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)11, this.getAdBreakClips(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.getEntity(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)13, (Parcelable)this.getVmapAdsRequest(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)14, (long)this.getStartAbsoluteTime());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)15, (String)this.zzo, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)16, (String)this.getContentUrl(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)17, (String)this.getHlsSegmentFormat(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)18, (String)this.getHlsVideoSegmentFormat(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)var1_1;
        JSONObject jSONObject2 = this.zzs;
        boolean bl2 = jSONObject2 == null;
        if (bl2 != (bl = (jSONObject = mediaInfo.zzs) == null)) {
            return false;
        }
        if (jSONObject2 != null && jSONObject != null && !JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) {
            return false;
        }
        return CastUtils.zze(this.zzc, mediaInfo.zzc) && this.zzd == mediaInfo.zzd && CastUtils.zze(this.zze, mediaInfo.zze) && CastUtils.zze((Object)this.zzf, (Object)mediaInfo.zzf) && this.zzg == mediaInfo.zzg && CastUtils.zze(this.zzh, mediaInfo.zzh) && CastUtils.zze((Object)this.zzi, (Object)mediaInfo.zzi) && CastUtils.zze(this.zzj, mediaInfo.zzj) && CastUtils.zze(this.zzk, mediaInfo.zzk) && CastUtils.zze(this.zzl, mediaInfo.zzl) && CastUtils.zze((Object)this.zzm, (Object)mediaInfo.zzm) && this.zzn == mediaInfo.zzn && CastUtils.zze(this.zzo, mediaInfo.zzo) && CastUtils.zze(this.zzp, mediaInfo.zzp) && CastUtils.zze(this.zzq, mediaInfo.zzq) && CastUtils.zze(this.zzr, mediaInfo.zzr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            long l;
            boolean bl;
            long l2;
            Object object;
            Object object2;
            jSONObject.put("contentId", (Object)this /* !! */ .zzc);
            jSONObject.putOpt("contentUrl", (Object)this /* !! */ .zzp);
            switch (this /* !! */ .zzd) {
                default: {
                    object2 = "NONE";
                    break;
                }
                case 2: {
                    object2 = "LIVE";
                    break;
                }
                case 1: {
                    object2 = "BUFFERED";
                }
            }
            jSONObject.put("streamType", object2);
            object2 = this /* !! */ .zze;
            if (object2 != null) {
                object = "contentType";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzf) != null) {
                object = "metadata";
                jSONObject.put((String)object, (Object)((MediaMetadata)((Object)object2)).zza());
            }
            if ((l2 = this /* !! */ .zzg) <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                object2 = "duration";
                jSONObject.put((String)object2, CastUtils.millisecToSec(l2));
            }
            if ((object2 = this /* !! */ .zzh) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzh.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((MediaTrack)((Object)object.next())).zza());
                }
                jSONObject.put("tracks", object2);
            }
            if ((object2 = this /* !! */ .zzi) != null) {
                object = "textTrackStyle";
                jSONObject.put((String)object, (Object)((TextTrackStyle)((Object)object2)).zza());
            }
            if ((object2 = this /* !! */ .zzs) != null) {
                object = "customData";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzl) != null) {
                object = "entity";
                jSONObject.put((String)object, object2);
            }
            if ((object2 = this /* !! */ .zzj) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzj.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((AdBreakInfo)((Object)object.next())).zza());
                }
                jSONObject.put("breaks", object2);
            }
            if ((object2 = this /* !! */ .zzk) != null) {
                object2 = new JSONArray();
                object = this /* !! */ .zzk.iterator();
                while (bl = object.hasNext()) {
                    object2.put((Object)((AdBreakClipInfo)((Object)object.next())).zza());
                }
                jSONObject.put("breakClips", object2);
            }
            if ((object2 = this /* !! */ .zzm) != null) {
                object = "vmapAdsRequest";
                jSONObject.put(object, (Object)((VastAdsRequest)((Object)object2)).zza());
            }
            if ((l = this /* !! */ .zzn) != -1L) {
                object2 = "startAbsoluteTime";
                jSONObject.put((String)object2, CastUtils.millisecToSec(l));
            }
            jSONObject.putOpt("atvEntity", (Object)this /* !! */ .zzo);
            object2 = this /* !! */ .zzq;
            if (object2 != null) {
                object = "hlsSegmentFormat";
                jSONObject.put((String)object, object2);
            }
            if ((this /* !! */  = this /* !! */ .zzr) == null) return jSONObject;
            object2 = "hlsVideoSegmentFormat";
            jSONObject.put((String)object2, (Object)this /* !! */ );
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzr(JSONObject jSONObject) throws JSONException {
        String string2;
        Object[] objectArray;
        ArrayList<void> arrayList;
        JSONArray jSONArray;
        block24: {
            void var2_6;
            if (!jSONObject.has("breaks")) break block24;
            jSONArray = jSONObject.getJSONArray("breaks");
            arrayList = new ArrayList<void>(jSONArray.length());
            boolean bl = false;
            while (var2_6 < jSONArray.length()) {
                void var3_17;
                block26: {
                    block27: {
                        block25: {
                            objectArray = jSONArray.getJSONObject((int)var2_6);
                            if (objectArray != null) break block25;
                            Object var3_18 = null;
                            break block26;
                        }
                        if (!objectArray.has("id")) break block27;
                        if (!objectArray.has("position")) {
                            Object var3_27 = null;
                            break block26;
                        } else {
                            void var3_32;
                            AdBreakInfo adBreakInfo;
                            string2 = objectArray.getString("id");
                            long l = CastUtils.secToMillisec(objectArray.getLong("position"));
                            boolean bl2 = objectArray.optBoolean("isWatched");
                            long l2 = CastUtils.secToMillisec(objectArray.optLong("duration"));
                            JSONArray jSONArray2 = objectArray.optJSONArray("breakClipIds");
                            String[] stringArray = new String[]{};
                            if (jSONArray2 != null) {
                                int n;
                                void var3_30;
                                String[] stringArray2 = new String[jSONArray2.length()];
                                boolean bl3 = false;
                                while (var3_30 < (n = jSONArray2.length())) {
                                    void v0 = var3_30++;
                                    stringArray2[v0] = jSONArray2.getString((int)v0);
                                }
                                String[] stringArray3 = stringArray2;
                            }
                            boolean bl4 = objectArray.optBoolean("isEmbedded");
                            boolean bl5 = objectArray.optBoolean("expanded");
                            AdBreakInfo adBreakInfo2 = adBreakInfo = new AdBreakInfo(l, string2, l2, bl2, (String[])var3_32, bl4, bl5);
                        }
                    }
                    Object var3_34 = null;
                    break block26;
                    catch (JSONException jSONException) {
                        objectArray = new Object[]{jSONException.getMessage()};
                        String string3 = String.format(Locale.ROOT, "Error while creating an AdBreakInfo from JSON: %s", objectArray);
                        Log.d((String)"AdBreakInfo", (String)string3);
                        Object var3_38 = null;
                    }
                }
                if (var3_17 != null) {
                    arrayList.add(var3_17);
                    ++var2_6;
                    continue;
                }
                arrayList.clear();
                break;
            }
            this.zzj = new ArrayList(arrayList);
        }
        if (!jSONObject.has("breakClips")) {
            return;
        }
        jSONArray = jSONObject.getJSONArray("breakClips");
        arrayList = new ArrayList<void>(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            void var2_8;
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject2 == null) {
                Object var2_7 = null;
            } else if (!jSONObject2.has("id")) {
                Object var2_9 = null;
            } else {
                try {
                    void var3_24;
                    void var2_12;
                    AdBreakClipInfo adBreakClipInfo;
                    long l;
                    objectArray = jSONObject2.getString("id");
                    long l3 = CastUtils.secToMillisec(jSONObject2.optLong("duration"));
                    string2 = CastUtils.optStringOrNull(jSONObject2, "clickThroughUrl");
                    String string4 = CastUtils.optStringOrNull(jSONObject2, "contentUrl");
                    String string5 = CastUtils.optStringOrNull(jSONObject2, "mimeType");
                    if (string5 == null) {
                        String string6 = CastUtils.optStringOrNull(jSONObject2, "contentType");
                    }
                    String string7 = CastUtils.optStringOrNull(jSONObject2, "title");
                    JSONObject jSONObject3 = jSONObject2.optJSONObject("customData");
                    String string8 = CastUtils.optStringOrNull(jSONObject2, "contentId");
                    String string9 = CastUtils.optStringOrNull(jSONObject2, "posterUrl");
                    boolean bl = jSONObject2.has("whenSkippable");
                    long l4 = bl ? (l = CastUtils.secToMillisec(((Integer)jSONObject2.get("whenSkippable")).intValue())) : -1L;
                    String string10 = CastUtils.optStringOrNull(jSONObject2, "hlsSegmentFormat");
                    VastAdsRequest vastAdsRequest = VastAdsRequest.fromJson(jSONObject2.optJSONObject("vastAdsRequest"));
                    if (jSONObject3 != null) {
                        int n = jSONObject3.length();
                        if (n == 0) {
                            Object var3_23 = null;
                        } else {
                            String string11 = jSONObject3.toString();
                        }
                    } else {
                        Object var3_26 = null;
                    }
                    AdBreakClipInfo adBreakClipInfo2 = adBreakClipInfo = new AdBreakClipInfo((String)objectArray, string7, l3, string4, (String)var2_12, string2, (String)var3_24, string8, string9, l4, string10, vastAdsRequest);
                }
                catch (JSONException jSONException) {
                    Object[] objectArray2 = new Object[]{jSONException.getMessage()};
                    String string12 = String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", objectArray2);
                    Log.d((String)"AdBreakClipInfo", (String)string12);
                    Object var2_16 = null;
                }
            }
            if (var2_8 != null) {
                arrayList.add(var2_8);
                continue;
            }
            arrayList.clear();
            break;
        }
        this.zzk = new ArrayList(arrayList);
    }

    @KeepForSdk
    public class Writer {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAdBreakClips(@Nullable List<AdBreakClipInfo> adBreakClips) {
            void var1_1;
            MediaInfo.this.zzk = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAdBreaks(@Nullable List<AdBreakInfo> adBreaks) {
            void var1_1;
            MediaInfo.this.zzj = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentId(@NonNull String contentId) {
            void var1_1;
            MediaInfo.this.zzc = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentType(@Nullable String contentType) {
            void var1_1;
            MediaInfo.this.zze = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setContentUrl(@Nullable String contentUrl) {
            void var1_1;
            MediaInfo.this.zzp = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            MediaInfo.this.zzs = (JSONObject)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setEntity(@Nullable String entity) {
            void var1_1;
            MediaInfo.this.zzl = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setHlsSegmentFormat(@Nullable @HlsSegmentFormat String hlsSegmentFormat) {
            void var1_1;
            MediaInfo.this.zzq = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setHlsVideoSegmentFormat(@Nullable @HlsVideoSegmentFormat String hlsVideoSegmentFormat) {
            void var1_1;
            MediaInfo.this.zzr = (String)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMediaTracks(@Nullable List<MediaTrack> mediaTracks) {
            void var1_1;
            MediaInfo.this.zzh = (List)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMetadata(@Nullable MediaMetadata metadata) {
            void var1_1;
            MediaInfo.this.zzf = (MediaMetadata)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStartAbsoluteTime(long startAbsoluteTime) {
            void var1_1;
            if (startAbsoluteTime < 0L && var1_1 != -1L) {
                throw new IllegalArgumentException("Invalid start absolute time");
            }
            MediaInfo.this.zzn = (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamDuration(long streamDuration) {
            void var1_1;
            if (streamDuration < 0L && var1_1 != -1L) {
                throw new IllegalArgumentException("Invalid stream duration");
            }
            MediaInfo.this.zzg = (long)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamType(int streamType) {
            void var1_1;
            if (streamType < -1 || var1_1 > 2) {
                throw new IllegalArgumentException("invalid stream type");
            }
            MediaInfo.this.zzd = (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setTextTrackStyle(@Nullable TextTrackStyle textTrackStyle) {
            void var1_1;
            MediaInfo.this.zzi = (TextTrackStyle)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setVmapAdsRequest(@Nullable VastAdsRequest vmapAdsRequest) {
            void var1_1;
            MediaInfo.this.zzm = (VastAdsRequest)var1_1;
        }
    }

    public static class Builder {
        @Nullable
        private String zza;
        private int zzb = -1;
        @Nullable
        private String zzc;
        @Nullable
        private MediaMetadata zzd;
        private long zze = -1L;
        @Nullable
        private List zzf;
        @Nullable
        private TextTrackStyle zzg;
        @Nullable
        private String zzh;
        @Nullable
        private List zzi;
        @Nullable
        private List zzj;
        @Nullable
        private String zzk;
        @Nullable
        private VastAdsRequest zzl;
        @Nullable
        private String zzm;
        @Nullable
        private String zzn;
        @Nullable
        @HlsSegmentFormat
        private String zzo;
        @Nullable
        @HlsVideoSegmentFormat
        private String zzp;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdBreakClips(@Nullable List<AdBreakClipInfo> adBreakClips) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdBreaks(@Nullable List<AdBreakInfo> adBreaks) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAtvEntity(@NonNull String atvEntity) {
            void var1_1;
            this.zzm = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentType(@Nullable String contentType) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentUrl(@NonNull String contentUrl) {
            void var1_1;
            this.zzn = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            String string2;
            string2 = customData == null ? null : string2.toString();
            this.zzh = string2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setEntity(@NonNull String entity) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHlsSegmentFormat(@Nullable @HlsSegmentFormat String hlsSegmentFormat) {
            void var1_1;
            this.zzo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHlsVideoSegmentFormat(@Nullable @HlsVideoSegmentFormat String hlsVideoSegmentFormat) {
            void var1_1;
            this.zzp = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMediaTracks(@Nullable List<MediaTrack> mediaTracks) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMetadata(@Nullable MediaMetadata metadata) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStreamDuration(long streamDuration) {
            void var1_1;
            if (streamDuration < 0L && var1_1 != -1L) {
                throw new IllegalArgumentException("Invalid stream duration");
            }
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setStreamType(int streamType) {
            void var1_1;
            if (streamType < -1 || var1_1 > 2) {
                throw new IllegalArgumentException("invalid stream type");
            }
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTextTrackStyle(@Nullable TextTrackStyle textTrackStyle) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setVmapAdsRequest(@Nullable VastAdsRequest vmapAdsRequest) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        @NonNull
        public MediaInfo build() {
            return new MediaInfo(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, -1L, this.zzm, this.zzn, this.zzo, this.zzp);
        }

        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String contentId) {
            void var1_1;
            this.zza = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String contentId, @Nullable String entity) {
            void var2_2;
            void var1_1;
            this.zza = var1_1;
            this.zzk = var2_2;
        }
    }
}

