/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.text.TextUtils;
import android.view.Display;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.R;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzag;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.cast.zzai;
import com.google.android.gms.cast.zzaj;
import com.google.android.gms.cast.zzak;
import com.google.android.gms.cast.zzal;
import com.google.android.gms.cast.zzam;
import com.google.android.gms.cast.zzan;
import com.google.android.gms.cast.zzao;
import com.google.android.gms.cast.zzap;
import com.google.android.gms.cast.zzar;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.cast.zzdw;
import com.google.android.gms.internal.cast.zzdx;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.tasks.OnCompleteListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final Logger zza = new Logger("CastRDLocalService");
    private static final int zzb = R.id.cast_notification_id;
    private static final Object zzc = new Object();
    private static final AtomicBoolean zzd = new AtomicBoolean(false);
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static CastRemoteDisplayLocalService zze;
    @Nullable
    private String zzf;
    private WeakReference zzg;
    private zzar zzh;
    private NotificationSettings zzi;
    @Nullable
    private Notification zzj;
    private boolean zzk;
    private PendingIntent zzl;
    private CastDevice zzm;
    @Nullable
    private Display zzn;
    @Nullable
    private Context zzo;
    @Nullable
    private ServiceConnection zzp;
    private Handler zzq;
    private MediaRouter zzr;
    private boolean zzs = false;
    private CastRemoteDisplayClient zzt;
    private final MediaRouter.Callback zzu = new zzag(this);
    private final IBinder zzv = new zzao(this);

    public int onStartCommand(@NonNull Intent intent, int n, int n2) {
        this.zzv("onStartCommand");
        this.zzs = true;
        return 2;
    }

    @NonNull
    public IBinder onBind(@NonNull Intent intent) {
        this.zzv("onBind");
        return this.zzv;
    }

    @Nullable
    protected Display getCastRemoteDisplay() {
        return this.zzn;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzc;
        synchronized (object) {
            return zze;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public void onCreate() {
        this_.zzv("onCreate");
        super.onCreate();
        this_.zzq = new zzdy(this_.getMainLooper());
        this_.zzq.postDelayed((Runnable)new zzah((CastRemoteDisplayLocalService)((Object)this_)), 100L);
        if (this_.zzt == null) {
            this_.zzt = CastRemoteDisplay.getClient((Context)this_);
        }
        if (!PlatformVersion.isAtLeastO()) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)this_.getSystemService(NotificationManager.class);
        Object this_ = this_.getString(R.string.cast_notification_default_channel_name);
        NotificationChannel notificationChannel = new NotificationChannel("cast_remote_display_local_service", (CharSequence)this_, 2);
        notificationChannel.setShowBadge(false);
        notificationManager.createNotificationChannel(notificationChannel);
    }

    public abstract void onCreatePresentation(@NonNull Display var1);

    public abstract void onDismissPresentation();

    protected static void setDebugEnabled() {
        zza.zzb(true);
    }

    /*
     * WARNING - void declaration
     */
    public static void startService(@NonNull Context activityContext, @NonNull Class<? extends CastRemoteDisplayLocalService> serviceClass, @NonNull String applicationId, @NonNull CastDevice device, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CastRemoteDisplayLocalService.startServiceWithOptions(activityContext, (Class<? extends CastRemoteDisplayLocalService>)var1_1, (String)var2_2, (CastDevice)var3_3, new Options(), (NotificationSettings)var4_4, (Callbacks)var5_5);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startServiceWithOptions(@NonNull Context activityContext, @NonNull Class<? extends CastRemoteDisplayLocalService> serviceClass, @NonNull String applicationId, @NonNull CastDevice device, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        block10: {
            void var6_8;
            void var5_7;
            void var4_6;
            void var3_5;
            void var2_4;
            void var1_3;
            Object[] objectArray;
            zza.d("Starting Service", new Object[0]);
            Object object = zzc;
            synchronized (object) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = zze;
                if (castRemoteDisplayLocalService != null) {
                    zza.w("An existing service had not been stopped before starting one", new Object[0]);
                    CastRemoteDisplayLocalService.zzw(true);
                }
            }
            try {
                boolean bl;
                object = new ComponentName((Context)objectArray, (Class)var1_3);
                object = objectArray.getPackageManager().getServiceInfo((ComponentName)object, 128);
                if (object != null && (bl = ((ServiceInfo)object).exported)) break block10;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?", nameNotFoundException);
            }
            Preconditions.checkNotNull((Object)objectArray, (Object)"activityContext is required.");
            Preconditions.checkNotNull((Object)var1_3, (Object)"serviceClass is required.");
            Preconditions.checkNotNull((Object)var2_4, (Object)"applicationId is required.");
            Preconditions.checkNotNull((Object)var3_5, (Object)"device is required.");
            Preconditions.checkNotNull((Object)var4_6, (Object)"options is required.");
            Preconditions.checkNotNull((Object)var5_7, (Object)"notificationSettings is required.");
            Preconditions.checkNotNull((Object)var6_8, (Object)"callbacks is required.");
            if (((NotificationSettings)var5_7).zza == null) {
                if (((NotificationSettings)var5_7).zzb == null) throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
            }
            if (zzd.getAndSet(true)) {
                objectArray = new Object[]{};
                zza.e("Service is already being started, startService has been called twice", objectArray);
                return;
            }
            Intent intent = new Intent((Context)objectArray, (Class)var1_3);
            objectArray.startService(intent);
            ConnectionTracker.getInstance().bindService((Context)objectArray, intent, (ServiceConnection)new zzai((String)var2_4, (CastDevice)var3_5, (Options)var4_6, (NotificationSettings)var5_7, (Context)objectArray, (Callbacks)var6_8), 64);
            return;
        }
        throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
        {
            catch (Throwable throwable) {}
            {
                throw throwable;
            }
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzw(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void updateNotificationSettings(@NonNull NotificationSettings notificationSettings) {
        void var1_1;
        if (PlatformVersion.isAtLeastS()) {
            return;
        }
        Preconditions.checkNotNull((Object)var1_1, (Object)"notificationSettings is required.");
        Preconditions.checkNotNull((Object)this.zzq, (Object)"Service is not ready yet.");
        this.zzq.post((Runnable)new zzak(this, (NotificationSettings)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Notification zzu(boolean bl) {
        void var1_5;
        int n;
        this.zzv("createDefaultNotification");
        String string2 = this.zzi.zzc;
        String string3 = this.zzi.zzd;
        if (bl) {
            int n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            int n3 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo());
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            void var1_3;
            String string4 = this.getString((int)var1_3, new Object[]{this.zzm.getFriendlyName()});
        } else {
            String string5 = string3;
        }
        string3 = "cast_remote_display_local_service";
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, string3).setContentTitle((CharSequence)string2).setContentText((CharSequence)var1_5).setContentIntent(this.zzi.zzb).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        if (this.zzl == null) {
            Preconditions.checkNotNull((Object)this.zzo, (Object)"activityContext is required.");
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(this.zzo.getPackageName());
            this.zzl = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)(zzdx.zza | 0x8000000));
        }
        return builder.addAction(17301560, (CharSequence)string6, this.zzl).build();
    }

    static /* bridge */ /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzo;
    }

    static /* bridge */ /* synthetic */ ServiceConnection zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzp;
    }

    static /* bridge */ /* synthetic */ CastDevice zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzm;
    }

    static /* bridge */ /* synthetic */ CastRemoteDisplayLocalService zzd() {
        return zze;
    }

    static /* bridge */ /* synthetic */ Logger zze() {
        return zza;
    }

    static /* bridge */ /* synthetic */ Object zzf() {
        return zzc;
    }

    static /* bridge */ /* synthetic */ WeakReference zzg(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzg;
    }

    static /* bridge */ /* synthetic */ AtomicBoolean zzh() {
        return zzd;
    }

    static /* bridge */ /* synthetic */ void zzi(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzo = null;
    }

    static /* bridge */ /* synthetic */ void zzj(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzn = null;
    }

    static /* bridge */ /* synthetic */ void zzk(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzp = null;
    }

    static /* bridge */ /* synthetic */ void zzl(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display object) {
        if (object == null) {
            zza.e("Cast Remote Display session created without display", new Object[0]);
            return;
        }
        castRemoteDisplayLocalService.zzn = object;
        if (castRemoteDisplayLocalService.zzk) {
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzu(true);
            CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
            castRemoteDisplayLocalService2.startForeground(zzb, castRemoteDisplayLocalService2.zzj);
        }
        if ((object = (Callbacks)castRemoteDisplayLocalService.zzg.get()) != null) {
            object.onRemoteDisplaySessionStarted(castRemoteDisplayLocalService);
        }
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzn, (Object)"display is required.");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService3 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService3.onCreatePresentation(castRemoteDisplayLocalService3.zzn);
    }

    static /* bridge */ /* synthetic */ void zzm(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzv(string2);
    }

    static /* bridge */ /* synthetic */ void zzn(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String objectArray) {
        objectArray = new Object[]{castRemoteDisplayLocalService, "The local service has not been been started, stopping it"};
        zza.e("[Instance: %s] %s", objectArray);
    }

    static /* bridge */ /* synthetic */ void zzo(CastRemoteDisplayLocalService object) {
        object = (Callbacks)((CastRemoteDisplayLocalService)((Object)object)).zzg.get();
        if (object != null) {
            object.onRemoteDisplaySessionError(new Status(2200));
        }
        CastRemoteDisplayLocalService.stopService();
    }

    static /* bridge */ /* synthetic */ void zzp(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzx(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzq(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        Preconditions.checkMainThread((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (castRemoteDisplayLocalService.zzi == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (castRemoteDisplayLocalService.zzk) {
            if (notificationSettings.zza != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzb != null) {
                castRemoteDisplayLocalService.zzi.zzb = notificationSettings.zzb;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzc)) {
                castRemoteDisplayLocalService.zzi.zzc = notificationSettings.zzc;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzd)) {
                castRemoteDisplayLocalService.zzi.zzd = notificationSettings.zzd;
            }
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzu(true);
        } else {
            Preconditions.checkNotNull((Object)notificationSettings.zza, (Object)"notification is required.");
            castRemoteDisplayLocalService.zzj = notificationSettings.zza;
            castRemoteDisplayLocalService.zzi.zza = castRemoteDisplayLocalService.zzj;
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.startForeground(zzb, castRemoteDisplayLocalService2.zzj);
    }

    static /* bridge */ /* synthetic */ void zzr(boolean bl) {
        CastRemoteDisplayLocalService.zzw(false);
    }

    private final void zzv(String string2) {
        Object[] objectArray = new Object[]{this, string2};
        zza.d("[Instance: %s] %s", objectArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void zzw(boolean bl) {
        block6: {
            zza.d("Stopping Service", new Object[0]);
            zzd.set(false);
            Object object = zzc;
            // MONITORENTER : object
            CastRemoteDisplayLocalService castRemoteDisplayLocalService = zze;
            if (castRemoteDisplayLocalService == null) break block6;
            zze = null;
            // MONITOREXIT : object
            if (castRemoteDisplayLocalService.zzq == null) return;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService.zzq.post((Runnable)new zzaj(castRemoteDisplayLocalService, bl));
                return;
            }
            castRemoteDisplayLocalService.zzx(bl);
            return;
        }
        zza.e("Service is already being stopped", new Object[0]);
        // MONITOREXIT : object
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzx(boolean bl) {
        this.zzv("Stopping Service");
        Preconditions.checkMainThread((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzr != null) {
            this.zzv("Setting default route");
            MediaRouter mediaRouter = this.zzr;
            mediaRouter.selectRoute(mediaRouter.getDefaultRoute());
        }
        if (this.zzh != null) {
            this.zzv("Unregistering notification receiver");
            CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
            castRemoteDisplayLocalService.unregisterReceiver(castRemoteDisplayLocalService.zzh);
        }
        this.zzv("stopRemoteDisplaySession");
        this.zzv("stopRemoteDisplay");
        this.zzt.stopRemoteDisplay().addOnCompleteListener((OnCompleteListener)new zzan(this));
        Callbacks callbacks = (Callbacks)this.zzg.get();
        if (callbacks != null) {
            callbacks.onRemoteDisplaySessionEnded(this);
        }
        this.onDismissPresentation();
        this.zzv("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
        if (this.zzr != null) {
            Preconditions.checkMainThread((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzv("removeMediaRouterCallback");
            this.zzr.removeCallback(this.zzu);
        }
        callbacks = this.zzo;
        ServiceConnection serviceConnection = this.zzp;
        if (callbacks != null && serviceConnection != null) {
            try {
                ConnectionTracker.getInstance().unbindService((Context)callbacks, serviceConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzv("No need to unbind service, already unbound");
            }
        }
        this.zzp = null;
        this.zzo = null;
        this.zzf = null;
        this.zzj = null;
        this.zzn = null;
    }

    static /* bridge */ /* synthetic */ boolean zzs(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzt(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String object, CastDevice castDevice, Options options, NotificationSettings object2, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        block10: {
            castRemoteDisplayLocalService.zzv("startRemoteDisplaySession");
            Preconditions.checkMainThread((String)"Starting the Cast Remote Display must be done on the main thread");
            Object object3 = zzc;
            synchronized (object3) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = zze;
                if (castRemoteDisplayLocalService2 != null) {
                    zza.w("An existing service had not been stopped before starting one", new Object[0]);
                    return false;
                }
                zze = castRemoteDisplayLocalService;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var8_10
                castRemoteDisplayLocalService.zzg = new WeakReference<Callbacks>(callbacks);
                castRemoteDisplayLocalService.zzf = object;
                castRemoteDisplayLocalService.zzm = castDevice;
                castRemoteDisplayLocalService.zzo = context;
                castRemoteDisplayLocalService.zzp = serviceConnection;
                if (castRemoteDisplayLocalService.zzr != null) break block10;
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
            castRemoteDisplayLocalService.zzr = MediaRouter.getInstance((Context)castRemoteDisplayLocalService.getApplicationContext());
        }
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzf, (Object)"applicationId is required.");
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(castRemoteDisplayLocalService.zzf)).build();
        castRemoteDisplayLocalService.zzv("addMediaRouterCallback");
        castRemoteDisplayLocalService.zzr.addCallback((MediaRouteSelector)object, castRemoteDisplayLocalService.zzu, 4);
        castRemoteDisplayLocalService.zzj = ((NotificationSettings)object2).zza;
        castRemoteDisplayLocalService.zzh = new zzar(null);
        object = new IntentFilter();
        object.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        object.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        if (PlatformVersion.isAtLeastT()) {
            CastRemoteDisplayLocalService castRemoteDisplayLocalService3 = castRemoteDisplayLocalService;
            castRemoteDisplayLocalService3.registerReceiver(castRemoteDisplayLocalService3.zzh, (IntentFilter)object, 4);
        } else {
            CastRemoteDisplayLocalService castRemoteDisplayLocalService4 = castRemoteDisplayLocalService;
            zzdw.zza((Context)castRemoteDisplayLocalService4, castRemoteDisplayLocalService4.zzh, (IntentFilter)object);
        }
        castRemoteDisplayLocalService.zzi = new NotificationSettings((NotificationSettings)object2, null);
        if (castRemoteDisplayLocalService.zzi.zza == null) {
            castRemoteDisplayLocalService.zzk = true;
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzu(false);
        } else {
            castRemoteDisplayLocalService.zzk = false;
            castRemoteDisplayLocalService.zzj = castRemoteDisplayLocalService.zzi.zza;
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService5 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService5.startForeground(zzb, castRemoteDisplayLocalService5.zzj);
        castRemoteDisplayLocalService.zzv("startRemoteDisplay");
        Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService6 = castRemoteDisplayLocalService;
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService6.zzo, (Object)"activityContext is required.");
        intent.setPackage(castRemoteDisplayLocalService.zzo.getPackageName());
        object = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService6, (int)0, (Intent)intent, (int)zzdx.zza);
        object2 = new zzal(castRemoteDisplayLocalService);
        Preconditions.checkNotNull((Object)castRemoteDisplayLocalService.zzf, (Object)"applicationId is required.");
        castRemoteDisplayLocalService.zzt.zze(castDevice, castRemoteDisplayLocalService.zzf, options.getConfigPreset(), (PendingIntent)object, (zzal)object2).addOnCompleteListener((OnCompleteListener)new zzam(castRemoteDisplayLocalService));
        object = (Callbacks)castRemoteDisplayLocalService.zzg.get();
        if (object == null) {
            return true;
        }
        object.onServiceCreated(castRemoteDisplayLocalService);
        return true;
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int zza = 2;

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zza;
        }

        /*
         * WARNING - void declaration
         */
        public void setConfigPreset(@CastRemoteDisplay.Configuration int configPreset) {
            void var1_1;
            this.zza = var1_1;
        }
    }

    public static final class NotificationSettings {
        private Notification zza;
        private PendingIntent zzb;
        private String zzc;
        private String zzd;

        private NotificationSettings() {
        }

        /* synthetic */ NotificationSettings(zzap zzap2) {
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzap zzap2) {
            this.zza = notificationSettings.zza;
            this.zzb = notificationSettings.zzb;
            this.zzc = notificationSettings.zzc;
            this.zzd = notificationSettings.zzd;
        }

        public static final class Builder {
            private final NotificationSettings zza = new NotificationSettings(null);

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotification(@NonNull Notification notification) {
                void var1_1;
                this.zza.zza = (Notification)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationPendingIntent(@NonNull PendingIntent notificationPendingIntent) {
                void var1_1;
                this.zza.zzb = (PendingIntent)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationText(@NonNull String notificationText) {
                void var1_1;
                this.zza.zzd = (String)var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNotificationTitle(@NonNull String notificationTitle) {
                void var1_1;
                this.zza.zzc = (String)var1_1;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @NonNull
            public NotificationSettings build() {
                if (this.zza.zza == null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zza.zzc)) return this.zza;
                    if (!TextUtils.isEmpty((CharSequence)this.zza.zzd)) return this.zza;
                    if (this.zza.zzb != null) return this.zza;
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                if (!TextUtils.isEmpty((CharSequence)this.zza.zzc)) {
                    throw new IllegalArgumentException("notificationTitle requires using the default notification");
                }
                if (!TextUtils.isEmpty((CharSequence)this.zza.zzd)) {
                    throw new IllegalArgumentException("notificationText requires using the default notification");
                }
                if (this.zza.zzb == null) return this.zza;
                throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
            }
        }
    }

    public static interface Callbacks {
        public void onRemoteDisplayMuteStateChanged(boolean var1);

        public void onRemoteDisplaySessionEnded(@NonNull CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(@NonNull Status var1);

        public void onRemoteDisplaySessionStarted(@NonNull CastRemoteDisplayLocalService var1);

        public void onServiceCreated(@NonNull CastRemoteDisplayLocalService var1);
    }
}

