/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzd;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="ApplicationMetadataCreator")
public class ApplicationMetadata
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zzd();
    @SafeParcelable.Field(id=2, getter="getApplicationId")
    String zza;
    @SafeParcelable.Field(id=3, getter="getName")
    String zzb;
    @SafeParcelable.Field(id=5, getter="getSupportedNamespaces")
    final List zzc;
    @SafeParcelable.Field(id=6, getter="getSenderAppIdentifier")
    String zzd;
    @SafeParcelable.Field(id=7, getter="getSenderAppLaunchUrl")
    Uri zze;
    @SafeParcelable.Field(id=8, getter="getIconUrl")
    @Nullable
    String zzf;
    @SafeParcelable.Field(id=9, getter="getApplicationType")
    @Nullable
    private String zzg;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf});
    }

    @NonNull
    public String getApplicationId() {
        return this.zza;
    }

    @Nullable
    public String getIconUrl() {
        return this.zzf;
    }

    @NonNull
    public String getName() {
        return this.zzb;
    }

    @NonNull
    public String getSenderAppIdentifier() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        String string = this.zza;
        String string2 = this.zzb;
        List list = this.zzc;
        int n = list == null ? 0 : list.size();
        String string3 = this.zzd;
        String string4 = String.valueOf(this.zze);
        String string5 = this.zzf;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("applicationId: ");
        stringBuilder.append(string);
        stringBuilder.append(", name: ");
        stringBuilder.append(string2);
        stringBuilder.append(", namespaces.count: ");
        stringBuilder.append(n);
        stringBuilder.append(", senderAppIdentifier: ");
        stringBuilder.append(string3);
        stringBuilder.append(", senderAppLaunchUrl: ");
        stringBuilder.append(string4);
        stringBuilder.append(", iconUrl: ");
        stringBuilder.append(string5);
        stringBuilder.append(", type: ");
        stringBuilder.append(this.zzg);
        return stringBuilder.toString();
    }

    @Deprecated
    @Nullable
    public List<WebImage> getImages() {
        return null;
    }

    @NonNull
    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzc);
    }

    private ApplicationMetadata() {
        this.zzc = new ArrayList();
    }

    @SafeParcelable.Constructor
    ApplicationMetadata(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @Nullable @SafeParcelable.Param(id=4) List list, @SafeParcelable.Param(id=5) List list2, @SafeParcelable.Param(id=6) String string3, @SafeParcelable.Param(id=7) Uri uri, @Nullable @SafeParcelable.Param(id=8) String string4, @Nullable @SafeParcelable.Param(id=9) String string5) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = list2;
        this.zzd = string3;
        this.zze = uri;
        this.zzf = string4;
        this.zzg = string5;
    }

    /*
     * WARNING - void declaration
     */
    public void setIconUrl(@Nullable String iconUrl) {
        void var1_1;
        this.zzf = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getApplicationId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)4, this.getImages(), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)5, this.getSupportedNamespaces(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getSenderAppIdentifier(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.zze, (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.getIconUrl(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)9, (String)this.zzg, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public boolean areNamespacesSupported(@NonNull List<String> namespaces) {
        void var1_1;
        List this_ = ((ApplicationMetadata)((Object)this_)).zzc;
        return this_ != null && this_.containsAll((Collection<?>)var1_1);
    }

    public boolean equals(@Nullable Object obj) {
        ApplicationMetadata applicationMetadata;
        if (obj == this) {
            return true;
        }
        if (!(applicationMetadata instanceof ApplicationMetadata)) {
            return false;
        }
        applicationMetadata = applicationMetadata;
        return CastUtils.zze(this.zza, applicationMetadata.zza) && CastUtils.zze(this.zzb, applicationMetadata.zzb) && CastUtils.zze(this.zzc, applicationMetadata.zzc) && CastUtils.zze(this.zzd, applicationMetadata.zzd) && CastUtils.zze(this.zze, applicationMetadata.zze) && CastUtils.zze(this.zzf, applicationMetadata.zzf) && CastUtils.zze(this.zzg, applicationMetadata.zzg);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isNamespaceSupported(@NonNull String namespace) {
        void var1_1;
        List this_ = ((ApplicationMetadata)((Object)this_)).zzc;
        return this_ != null && this_.contains(var1_1);
    }
}

