/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@KeepForSdk
public final class CastUtils {
    private static final Pattern zza;
    private static final Random zzb;

    @KeepForSdk
    public static double millisecToSec(long ms) {
        return (double)ms / 1000.0;
    }

    @KeepForSdk
    public static long secToMillisec(double sec) {
        return (long)(sec * 1000.0);
    }

    @KeepForSdk
    public static long secToMillisec(long sec) {
        return sec * 1000L;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @Nullable
    public static String optStringOrNull(@NonNull JSONObject json, @NonNull String key) {
        void var1_1;
        JSONObject jSONObject;
        if (json != null && jSONObject.has((String)var1_1)) {
            return jSONObject.optString((String)var1_1);
        }
        return null;
    }

    @KeepForSdk
    @Nullable
    public static JSONObject jsonStringToJsonObject(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static {
        Random random;
        zza = Pattern.compile("urn:x-cast:[-A-Za-z0-9_]+(\\.[-A-Za-z0-9_]+)*");
        zzb = random = new Random(SystemClock.elapsedRealtime());
    }

    private CastUtils() {
    }

    @KeepForSdk
    public static void throwIfInvalidNamespace(@NonNull String namespace) throws IllegalArgumentException {
        Object object;
        if (TextUtils.isEmpty((CharSequence)namespace)) {
            object = new IllegalArgumentException("Namespace cannot be null or empty");
            throw object;
        }
        if (((String)object).length() > 128) {
            object = new IllegalArgumentException("Invalid namespace length");
            throw object;
        }
        if (!((String)object).startsWith("urn:x-cast:")) {
            object = new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\"");
            throw object;
        }
        if (((String)object).length() == 11) {
            object = new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\" and have non-empty suffix");
            throw object;
        }
    }

    @KeepForSdk
    @NonNull
    public static long[] toLongArray(@NonNull Collection<Long> longList) {
        Collection<Long> collection;
        long[] lArray = new long[longList.size()];
        Iterator<Long> iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = n + 1;
            lArray[n] = iterator.next();
            n = n2;
        }
        return lArray;
    }

    @KeepForSdk
    @Nullable
    public static long[] toLongArraySafely(@Nullable JSONArray jsonArray) {
        try {
            Object object = CastUtils.zzj(jsonArray);
            return object;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static int zza(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static long zzb() {
        return zzb.nextLong();
    }

    @NonNull
    public static String zzc(@NonNull String string2) {
        return "urn:x-cast:".concat(string2);
    }

    @NonNull
    public static String zzd(@NonNull Locale object) {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(((Locale)object).getLanguage());
        String string2 = ((Locale)object).getCountry();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append('-');
            stringBuilder.append(string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object = ((Locale)object).getVariant()))) {
            stringBuilder.append('-');
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static String zze(@NonNull String string2) {
        if (zza.matcher(string2).matches()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.' || c == ':')) {
                Object[] objectArray = new Object[]{(int)c};
                stringBuilder.append(String.format("%%%04x", objectArray));
            } else {
                stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @NonNull
    public static List zzf(@NonNull int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(nArray[i]);
        }
        return arrayList;
    }

    @Nullable
    public static JSONObject zzg(@Nullable JSONObject jSONObject, @NonNull String string2) {
        if (jSONObject.has(string2)) {
            return jSONObject.optJSONObject(string2);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzh(@Nullable Object object, @Nullable Object object2) {
        if (object == null) {
            if (object2 == null) return true;
        }
        if (object == null) return false;
        if (object2 == null) return false;
        if (!object.equals(object2)) return false;
        return true;
    }

    @NonNull
    public static int[] zzi(@NonNull Collection collection) {
        int[] nArray = new int[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = n + 1;
            nArray[n] = (Integer)iterator.next();
            n = n2;
        }
        return nArray;
    }

    @Nullable
    public static long[] zzj(@Nullable JSONArray jSONArray) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        long[] lArray = new long[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            lArray[i] = jSONArray.getLong(i);
        }
        return lArray;
    }
}

