/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzcn;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaTrackCreator")
public final class MediaTrack
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final String ROLE_ALTERNATE = "alternate";
    @NonNull
    public static final String ROLE_CAPTION = "caption";
    @NonNull
    public static final String ROLE_COMMENTARY = "commentary";
    @NonNull
    public static final String ROLE_DESCRIPTION = "description";
    @NonNull
    public static final String ROLE_DUB = "dub";
    @NonNull
    public static final String ROLE_EMERGENCY = "emergency";
    @NonNull
    public static final String ROLE_FORCED_SUBTITLE = "forced_subtitle";
    @NonNull
    public static final String ROLE_MAIN = "main";
    @NonNull
    public static final String ROLE_SIGN = "sign";
    @NonNull
    public static final String ROLE_SUBTITLE = "subtitle";
    @NonNull
    public static final String ROLE_SUPPLEMENTARY = "supplementary";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<MediaTrack> CREATOR;
    @SafeParcelable.Field(id=2, getter="getId")
    private long zzb;
    @SafeParcelable.Field(id=3, getter="getType")
    private int zzc;
    @SafeParcelable.Field(id=4, getter="getContentId")
    @Nullable
    private String zzd;
    @SafeParcelable.Field(id=5, getter="getContentType")
    @Nullable
    private String zze;
    @SafeParcelable.Field(id=6, getter="getName")
    @Nullable
    private String zzf;
    @SafeParcelable.Field(id=7, getter="getLanguage")
    @Nullable
    private final String zzg;
    @SafeParcelable.Field(id=8, getter="getSubtype")
    private int zzh;
    @SafeParcelable.Field(id=9, getter="getRoles")
    @Nullable
    private final List zzi;
    @SafeParcelable.Field(id=10)
    @Nullable
    String zza;
    @Nullable
    private final JSONObject zzj;

    public int getSubtype() {
        return this.zzh;
    }

    public int getType() {
        return this.zzc;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, String.valueOf(this.zzj)};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getId() {
        return this.zzb;
    }

    @Nullable
    public String getContentId() {
        return this.zzd;
    }

    @Nullable
    public String getContentType() {
        return this.zze;
    }

    @Nullable
    public String getLanguage() {
        return this.zzg;
    }

    @Nullable
    public String getName() {
        return this.zzf;
    }

    @Nullable
    public List<String> getRoles() {
        return this.zzi;
    }

    @TargetApi(value=21)
    @Nullable
    public Locale getLanguageLocale() {
        if (TextUtils.isEmpty((CharSequence)this_.zzg)) {
            return null;
        }
        if (PlatformVersion.isAtLeastLollipop()) {
            return Locale.forLanguageTag(this_.zzg);
        }
        String[] this_ = this_.zzg.split("-", -1);
        if (this_.length == 1) {
            Locale locale = new Locale(this_[0]);
            return locale;
        }
        Locale locale = new Locale(this_[0], this_[1]);
        return locale;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzj;
    }

    static {
        zzcn zzcn2;
        CREATOR = zzcn2 = new zzcn();
    }

    MediaTrack(long l, int n, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, int n2, @Nullable List list, @Nullable JSONObject jSONObject) {
        this.zzb = l;
        this.zzc = n;
        this.zzd = string2;
        this.zze = string3;
        this.zzf = string4;
        this.zzg = string5;
        this.zzh = n2;
        this.zzi = list;
        this.zzj = jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentId(@Nullable String contentId) {
        void var1_1;
        this.zzd = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setContentType(@Nullable String contentType) {
        void var1_1;
        this.zze = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        void var2_5;
        JSONObject jSONObject = this.zzj;
        if (jSONObject == null) {
            Object var2_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var2_5;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)3, (int)this.getType());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getContentId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getContentType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getLanguage(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)8, (int)this.getSubtype());
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)9, this.getRoles(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)var1_1;
        JSONObject jSONObject2 = this.zzj;
        boolean bl2 = jSONObject2 == null;
        if (bl2 != (bl = (jSONObject = mediaTrack.zzj) == null)) {
            return false;
        }
        if (jSONObject2 != null && jSONObject != null && !JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) {
            return false;
        }
        return this.zzb == mediaTrack.zzb && this.zzc == mediaTrack.zzc && CastUtils.zzh(this.zzd, mediaTrack.zzd) && CastUtils.zzh(this.zze, mediaTrack.zze) && CastUtils.zzh(this.zzf, mediaTrack.zzf) && CastUtils.zzh(this.zzg, mediaTrack.zzg) && this.zzh == mediaTrack.zzh && CastUtils.zzh(this.zzi, mediaTrack.zzi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl;
            String string2;
            jSONObject.put("trackId", this.zzb);
            switch (this.zzc) {
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
            }
            String string3 = this.zzd;
            if (string3 != null) {
                string2 = "trackContentId";
                jSONObject.put(string2, (Object)string3);
            }
            if ((string3 = this.zze) != null) {
                string2 = "trackContentType";
                jSONObject.put(string2, (Object)string3);
            }
            if ((string3 = this.zzf) != null) {
                string2 = "name";
                jSONObject.put(string2, (Object)string3);
            }
            if (!(bl = TextUtils.isEmpty((CharSequence)this.zzg))) {
                jSONObject.put("language", (Object)this.zzg);
            }
            switch (this.zzh) {
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
            }
            Object object = this.zzi;
            if (object != null) {
                object = new JSONArray((Collection)this.zzi);
                jSONObject.put("roles", object);
            }
            if ((this = this.zzj) == null) return jSONObject;
            object = "customData";
            jSONObject.put((String)object, (Object)this);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    @VisibleForTesting
    public static class Builder {
        private final long zza;
        private final int zzb;
        @Nullable
        private String zzc;
        @Nullable
        private String zzd;
        @Nullable
        private String zze;
        @Nullable
        private String zzf;
        private int zzg = 0;
        @Nullable
        private List zzh;
        @Nullable
        private JSONObject zzi;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentId(@Nullable String contentId) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentType(@Nullable String contentType) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLanguage(@Nullable String language) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setLanguage(@NonNull Locale locale) {
            void var1_1;
            this.zzf = CastUtils.zzd((Locale)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setName(@Nullable String trackName) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        @NonNull
        public Builder setRoles(@Nullable List<String> roles) {
            zzer zzer2;
            if (roles != null) {
                zzer2 = zzer.zzl(zzer2);
            }
            this.zzh = zzer2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            Object object;
            void var1_1;
            if (subtype < -1 || var1_1 > 5) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("invalid subtype ");
                stringBuilder.append((int)var1_1);
                object = new IllegalArgumentException(stringBuilder.toString());
                throw object;
            }
            if (var1_1 != false && ((Builder)object).zzb != 1) {
                object = new IllegalArgumentException("subtypes are only valid for text tracks");
                throw object;
            }
            ((Builder)object).zzg = var1_1;
            return object;
        }

        @NonNull
        public MediaTrack build() {
            MediaTrack mediaTrack = new MediaTrack(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi);
            return mediaTrack;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            void var3_2;
            void var1_1;
            this.zza = var1_1;
            this.zzb = var3_2;
        }
    }
}

