/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLiveSeekableRange;
import com.google.android.gms.cast.MediaQueueData;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.media.MediaCommon;
import com.google.android.gms.cast.zzcm;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.JsonUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@VisibleForTesting
@SafeParcelable.Class(creator="MediaStatusCreator")
public class MediaStatus
extends AbstractSafeParcelable {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    @Deprecated
    public static final long COMMAND_SKIP_FORWARD = 16L;
    @Deprecated
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final long COMMAND_QUEUE_NEXT = 64L;
    public static final long COMMAND_QUEUE_PREVIOUS = 128L;
    public static final long COMMAND_QUEUE_SHUFFLE = 256L;
    public static final long COMMAND_QUEUE_REPEAT_ALL = 1024L;
    public static final long COMMAND_QUEUE_REPEAT_ONE = 2048L;
    public static final long COMMAND_QUEUE_REPEAT = 3072L;
    public static final long COMMAND_SKIP_AD = 512L;
    public static final long COMMAND_EDIT_TRACKS = 4096L;
    public static final long COMMAND_PLAYBACK_RATE = 8192L;
    public static final long COMMAND_LIKE = 16384L;
    public static final long COMMAND_DISLIKE = 32768L;
    public static final long COMMAND_FOLLOW = 65536L;
    public static final long COMMAND_UNFOLLOW = 131072L;
    @KeepForSdk
    @ShowFirstParty
    public static final long COMMAND_STREAM_TRANSFER = 262144L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int PLAYER_STATE_LOADING = 5;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<MediaStatus> CREATOR;
    private static final Logger zzx;
    @SafeParcelable.Field(id=2, getter="getMediaInfo")
    @VisibleForTesting
    @Nullable
    MediaInfo zza;
    @SafeParcelable.Field(id=3, getter="getMediaSessionId")
    @VisibleForTesting
    long zzb;
    @SafeParcelable.Field(id=4, getter="getCurrentItemId")
    @VisibleForTesting
    int zzc;
    @SafeParcelable.Field(id=5, getter="getPlaybackRate")
    @VisibleForTesting
    double zzd;
    @SafeParcelable.Field(id=6, getter="getPlayerState")
    @VisibleForTesting
    int zze;
    @SafeParcelable.Field(id=7, getter="getIdleReason")
    @VisibleForTesting
    int zzf;
    @SafeParcelable.Field(id=8, getter="getStreamPosition")
    @VisibleForTesting
    long zzg;
    @SafeParcelable.Field(id=9)
    long zzh;
    @SafeParcelable.Field(id=10, getter="getStreamVolume")
    @VisibleForTesting
    double zzi;
    @SafeParcelable.Field(id=11, getter="isMute")
    @VisibleForTesting
    boolean zzj;
    @SafeParcelable.Field(id=12, getter="getActiveTrackIds")
    @VisibleForTesting
    @Nullable
    long[] zzk;
    @SafeParcelable.Field(id=13, getter="getLoadingItemId")
    @VisibleForTesting
    int zzl;
    @SafeParcelable.Field(id=14, getter="getPreloadedItemId")
    @VisibleForTesting
    int zzm;
    @SafeParcelable.Field(id=15)
    @Nullable
    String zzn;
    @VisibleForTesting
    @Nullable
    JSONObject zzo;
    @SafeParcelable.Field(id=16)
    int zzp;
    @SafeParcelable.Field(id=17)
    final List zzq;
    @SafeParcelable.Field(id=18, getter="isPlayingAd")
    @VisibleForTesting
    boolean zzr;
    @SafeParcelable.Field(id=19, getter="getAdBreakStatus")
    @VisibleForTesting
    @Nullable
    AdBreakStatus zzs;
    @SafeParcelable.Field(id=20, getter="getVideoInfo")
    @VisibleForTesting
    @Nullable
    VideoInfo zzt;
    @SafeParcelable.Field(id=21, getter="getLiveSeekableRange")
    @VisibleForTesting
    @Nullable
    MediaLiveSeekableRange zzu;
    @SafeParcelable.Field(id=22, getter="getQueueData")
    @VisibleForTesting
    @Nullable
    MediaQueueData zzv;
    @VisibleForTesting
    boolean zzw;
    private final SparseArray zzy;
    private final Writer zzz;

    public double getPlaybackRate() {
        return this.zzd;
    }

    public double getStreamVolume() {
        return this.zzi;
    }

    public int getCurrentItemId() {
        return this.zzc;
    }

    public int getIdleReason() {
        return this.zzf;
    }

    public int getLoadingItemId() {
        return this.zzl;
    }

    public int getPlayerState() {
        return this.zze;
    }

    public int getPreloadedItemId() {
        return this.zzm;
    }

    public int getQueueItemCount() {
        return this.zzq.size();
    }

    public int getQueueRepeatMode() {
        return this.zzp;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, Arrays.hashCode(this.zzk), this.zzl, this.zzm, String.valueOf(this.zzo), this.zzp, this.zzq, this.zzr, this.zzs, this.zzt, this.zzu, this.zzv};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getStreamPosition() {
        return this.zzg;
    }

    @KeepForSdk
    public long getSupportedMediaCommands() {
        return this.zzh;
    }

    @Nullable
    public AdBreakClipInfo getCurrentAdBreakClip() {
        Object object = this_.zzs;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getBreakClipId()))) {
            return null;
        }
        Object this_ = this_.zza;
        if (this_ == null) {
            return null;
        }
        if ((this_ = this_.getAdBreakClips()) == null || this_.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : this_) {
            if (!((String)object).equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }

    @Nullable
    public AdBreakInfo getCurrentAdBreak() {
        Object object = this_.zzs;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = object.getBreakId()))) {
            return null;
        }
        Object this_ = this_.zza;
        if (this_ == null) {
            return null;
        }
        if ((this_ = this_.getAdBreaks()) == null || this_.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : this_) {
            if (!((String)object).equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    @Nullable
    public AdBreakStatus getAdBreakStatus() {
        return this.zzs;
    }

    @Nullable
    public MediaInfo getMediaInfo() {
        return this.zza;
    }

    @Nullable
    public MediaLiveSeekableRange getLiveSeekableRange() {
        return this.zzu;
    }

    @Nullable
    public MediaQueueData getQueueData() {
        return this.zzv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getItemById(int itemId) {
        void var1_1;
        Integer n = (Integer)this.zzy.get((int)var1_1);
        if (n == null) {
            return null;
        }
        return (MediaQueueItem)((Object)this.zzq.get(n));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getItemByIndex(int index) {
        void var1_1;
        if (index < 0 || var1_1 >= this.zzq.size()) {
            return null;
        }
        return (MediaQueueItem)((Object)this.zzq.get((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getQueueItem(int index) {
        void var1_1;
        return this.getItemByIndex((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public MediaQueueItem getQueueItemById(int itemId) {
        void var1_1;
        return this.getItemById((int)var1_1);
    }

    @KeepForSdk
    @NonNull
    public Writer getWriter() {
        return this.zzz;
    }

    @Nullable
    public VideoInfo getVideoInfo() {
        return this.zzt;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Integer getIndexById(int itemId) {
        void var1_1;
        return (Integer)this.zzy.get((int)var1_1);
    }

    @NonNull
    public List<MediaQueueItem> getQueueItems() {
        return this.zzq;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl;
            Object object;
            int n;
            String string2;
            jSONObject.put("mediaSessionId", ((MediaStatus)((Object)iterator)).zzb);
            String string3 = "playerState";
            switch (((MediaStatus)((Object)iterator)).zze) {
                default: {
                    string2 = "IDLE";
                    break;
                }
                case 5: {
                    string2 = "LOADING";
                    break;
                }
                case 4: {
                    string2 = "BUFFERING";
                    break;
                }
                case 3: {
                    string2 = "PAUSED";
                    break;
                }
                case 2: {
                    string2 = "PLAYING";
                    break;
                }
                case 1: {
                    string2 = "IDLE";
                }
            }
            jSONObject.put(string3, (Object)string2);
            int n2 = ((MediaStatus)((Object)iterator)).zze;
            if (n2 == 1) {
                String string4;
                switch (((MediaStatus)((Object)iterator)).zzf) {
                    default: {
                        string4 = null;
                        break;
                    }
                    case 1: {
                        string4 = "FINISHED";
                        break;
                    }
                    case 4: {
                        string4 = "ERROR";
                        break;
                    }
                    case 3: {
                        string4 = "INTERRUPTED";
                        break;
                    }
                    case 2: {
                        string4 = "CANCELLED";
                    }
                }
                jSONObject.putOpt("idleReason", (Object)string4);
            }
            jSONObject.put("playbackRate", ((MediaStatus)((Object)iterator)).zzd);
            jSONObject.put("currentTime", CastUtils.millisecToSec(((MediaStatus)((Object)iterator)).zzg));
            jSONObject.put("supportedMediaCommands", ((MediaStatus)((Object)iterator)).zzh);
            Object object2 = "volume";
            string3 = new JSONObject();
            string3.put("level", ((MediaStatus)((Object)iterator)).zzi);
            string3.put("muted", ((MediaStatus)((Object)iterator)).zzj);
            jSONObject.put((String)object2, (Object)string3);
            string3 = "activeTrackIds";
            object2 = ((MediaStatus)((Object)iterator)).zzk;
            if (object2 == null) {
                object2 = null;
            } else {
                JSONArray jSONArray = new JSONArray();
                long[] lArray = ((MediaStatus)((Object)iterator)).zzk;
                int n3 = lArray.length;
                for (int i = 0; i < n3; ++i) {
                    jSONArray.put(lArray[i]);
                }
                object2 = jSONArray;
            }
            jSONObject.putOpt(string3, object2);
            jSONObject.putOpt("customData", (Object)((MediaStatus)((Object)iterator)).zzo);
            jSONObject.putOpt("shuffle", (Object)((MediaStatus)((Object)iterator)).zzw);
            object2 = ((MediaStatus)((Object)iterator)).zza;
            if (object2 != null) {
                string3 = "media";
                jSONObject.putOpt(string3, (Object)((MediaInfo)((Object)object2)).zza());
            }
            if ((n = ((MediaStatus)((Object)iterator)).zzc) != 0) {
                string3 = "currentItemId";
                jSONObject.put(string3, n);
            }
            if ((n = ((MediaStatus)((Object)iterator)).zzm) != 0) {
                string3 = "preloadedItemId";
                jSONObject.put(string3, n);
            }
            if ((n = ((MediaStatus)((Object)iterator)).zzl) != 0) {
                string3 = "loadingItemId";
                jSONObject.put(string3, n);
            }
            if ((object = ((MediaStatus)((Object)iterator)).zzs) != null) {
                string3 = "breakStatus";
                jSONObject.putOpt(string3, (Object)((AdBreakStatus)((Object)object)).zzb());
            }
            if ((object = ((MediaStatus)((Object)iterator)).zzt) != null) {
                string3 = "videoInfo";
                jSONObject.putOpt(string3, (Object)((VideoInfo)((Object)object)).zzb());
            }
            if ((object = ((MediaStatus)((Object)iterator)).zzv) != null) {
                string3 = "queueData";
                jSONObject.putOpt(string3, (Object)((MediaQueueData)((Object)object)).zza());
            }
            if ((object = ((MediaStatus)((Object)iterator)).zzu) != null) {
                string3 = "liveSeekableRange";
                jSONObject.putOpt(string3, (Object)((MediaLiveSeekableRange)((Object)object)).zzb());
            }
            jSONObject.putOpt("repeatMode", (Object)MediaCommon.zza(((MediaStatus)((Object)iterator)).zzp));
            object = ((MediaStatus)((Object)iterator)).zzq;
            if (object == null) return jSONObject;
            boolean bl2 = object.isEmpty();
            if (bl2) return jSONObject;
            JSONArray jSONArray = new JSONArray();
            Iterator iterator = ((MediaStatus)((Object)iterator)).zzq.iterator();
            while (bl = iterator.hasNext()) {
                jSONArray.put((Object)((MediaQueueItem)((Object)iterator.next())).toJson());
            }
            jSONObject.put("items", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zzx.e(jSONException, "Error transforming MediaStatus into JSONObject", new Object[0]);
            return new JSONObject();
        }
    }

    static {
        Object object = new Logger("MediaStatus");
        zzx = object;
        object = new zzcm();
        CREATOR = object;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public MediaStatus(@NonNull JSONObject json) throws JSONException {
        this(null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null, null, null);
        void var1_1;
        this.zza((JSONObject)var1_1, 0);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SafeParcelable.Constructor
    @SuppressLint(value={"NonSdkVisibleApi"})
    public MediaStatus(@SafeParcelable.Param(id=2) @Nullable MediaInfo var1_1, @SafeParcelable.Param(id=3) long var2_3, @SafeParcelable.Param(id=4) int var4_4, @SafeParcelable.Param(id=5) double var5_5, @SafeParcelable.Param(id=6) int var7_6, @SafeParcelable.Param(id=7) int var8_7, @SafeParcelable.Param(id=8) long var9_8, @SafeParcelable.Param(id=9) long var11_9, @SafeParcelable.Param(id=10) double var13_10, @SafeParcelable.Param(id=11) boolean var15_11, @SafeParcelable.Param(id=12) @Nullable long[] var16_12, @SafeParcelable.Param(id=13) int var17_13, @SafeParcelable.Param(id=14) int var18_14, @SafeParcelable.Param(id=15) @Nullable String var19_15, @SafeParcelable.Param(id=16) int var20_16, @SafeParcelable.Param(id=17) @Nullable List var21_17, @SafeParcelable.Param(id=18) boolean var22_18, @SafeParcelable.Param(id=19) @Nullable AdBreakStatus var23_19, @SafeParcelable.Param(id=20) @Nullable VideoInfo var24_20, @SafeParcelable.Param(id=21) @Nullable MediaLiveSeekableRange var25_21, @SafeParcelable.Param(id=22) @Nullable MediaQueueData var26_22) {
        block6: {
            super();
            this.zzq = var27_23 /* !! */  = new ArrayList();
            this.zzy = var27_23 /* !! */  = new SparseArray();
            super();
            this.zzz = var27_23 /* !! */ ;
            this.zza = var1_1;
            this.zzb = var2_3;
            this.zzc = var4_4;
            this.zzd = var5_5;
            this.zze = var7_6;
            this.zzf = var8_7;
            this.zzg = var9_8;
            this.zzh = var11_9;
            this.zzi = var13_10;
            this.zzj = var15_11;
            this.zzk = var16_12;
            this.zzl = var17_13;
            this.zzm = var18_14;
            this.zzn = var19_15;
            if (this.zzn == null) break block6;
            try {
                super(this.zzn);
                this.zzo = var1_1;
            }
            catch (JSONException v0) {
                this.zzo = null;
                this.zzn = null;
                ** continue;
            }
lbl24:
            // 3 sources

            while (true) {
                block7: {
                    this.zzp = var20_16;
                    if (var21_17 != null && !var21_17.isEmpty()) {
                        this.zze(var21_17);
                    }
                    this.zzr = var22_18;
                    this.zzs = var23_19;
                    this.zzt = var24_20;
                    this.zzu = var25_21;
                    this.zzv = var26_22;
                    if (var26_22 == null) break block7;
                    if (var26_22.zzk()) {
                        var1_2 = true;
lbl36:
                        // 3 sources

                        while (true) {
                            this.zzw = var1_2;
                            return;
                        }
                    }
                    var1_2 = false;
                    ** GOTO lbl36
                }
                var1_2 = false;
                ** continue;
                break;
            }
        }
        this.zzo = null;
        ** GOTO lbl24
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        void var3_5;
        JSONObject jSONObject = this.zzo;
        if (jSONObject == null) {
            Object var3_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zzn = var3_5;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getMediaInfo(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.zzb);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.getCurrentItemId());
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)5, (double)this.getPlaybackRate());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.getPlayerState());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.getIdleReason());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)8, (long)this.getStreamPosition());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)9, (long)this.zzh);
        SafeParcelWriter.writeDouble((Parcel)var1_1, (int)10, (double)this.getStreamVolume());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)11, (boolean)this.isMute());
        SafeParcelWriter.writeLongArray((Parcel)var1_1, (int)12, (long[])this.getActiveTrackIds(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.getLoadingItemId());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)14, (int)this.getPreloadedItemId());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)15, (String)this.zzn, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)16, (int)this.zzp);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)17, (List)this.zzq, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)18, (boolean)this.isPlayingAd());
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)19, (Parcelable)this.getAdBreakStatus(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)20, (Parcelable)this.getVideoInfo(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)21, (Parcelable)this.getLiveSeekableRange(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)22, (Parcelable)this.getQueueData(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean equals(@Nullable Object other) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        boolean bl;
        void var1_1;
        if (this == var1_1) {
            return true;
        }
        if (!(var1_1 instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)var1_1;
        boolean bl2 = this.zzo == null;
        if (bl2 != (bl = mediaStatus.zzo == null)) {
            return false;
        }
        return this.zzb == mediaStatus.zzb && this.zzc == mediaStatus.zzc && this.zzd == mediaStatus.zzd && this.zze == mediaStatus.zze && this.zzf == mediaStatus.zzf && this.zzg == mediaStatus.zzg && this.zzi == mediaStatus.zzi && this.zzj == mediaStatus.zzj && this.zzl == mediaStatus.zzl && this.zzm == mediaStatus.zzm && this.zzp == mediaStatus.zzp && Arrays.equals(this.zzk, mediaStatus.zzk) && CastUtils.zzh(this.zzh, mediaStatus.zzh) && CastUtils.zzh(this.zzq, mediaStatus.zzq) && CastUtils.zzh((Object)this.zza, (Object)mediaStatus.zza) && ((jSONObject2 = this.zzo) == null || (jSONObject = mediaStatus.zzo) == null || JsonUtils.areJsonValuesEquivalent((Object)jSONObject2, (Object)jSONObject)) && this.zzr == mediaStatus.isPlayingAd() && CastUtils.zzh((Object)this.zzs, (Object)mediaStatus.zzs) && CastUtils.zzh((Object)this.zzt, (Object)mediaStatus.zzt) && CastUtils.zzh((Object)this.zzu, (Object)mediaStatus.zzu) && Objects.equal((Object)((Object)this.zzv), (Object)((Object)mediaStatus.zzv)) && this.zzw == mediaStatus.zzw;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isMediaCommandSupported(long mediaCommand) {
        void var1_1;
        return (this.zzh & var1_1) != 0L;
    }

    public boolean isMute() {
        return this.zzj;
    }

    public boolean isPlayingAd() {
        return this.zzr;
    }

    @Nullable
    public long[] getActiveTrackIds() {
        return this.zzk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int zza(@NonNull JSONObject object, int n) throws JSONException {
        block58: {
            int n2;
            block56: {
                ArrayList<AbstractSafeParcelable> arrayList;
                int n3;
                SparseArray sparseArray;
                int n4;
                Object object2;
                block57: {
                    block55: {
                        MediaInfo mediaInfo;
                        int n5;
                        int n6;
                        Object object3;
                        block54: {
                            block49: {
                                block53: {
                                    Object object4;
                                    block52: {
                                        int n7;
                                        block51: {
                                            double d;
                                            long l;
                                            Object object5;
                                            JSONObject jSONObject = object.optJSONObject("extendedStatus");
                                            if (jSONObject != null) {
                                                try {
                                                    object5 = new ArrayList();
                                                    object2 = object.keys();
                                                    while ((n4 = object2.hasNext()) != 0) {
                                                        object5.add((String)object2.next());
                                                    }
                                                    object2 = new JSONObject(object, object5.toArray(new String[0]));
                                                    object5 = jSONObject.keys();
                                                    while ((n4 = object5.hasNext()) != 0) {
                                                        String string2 = (String)object5.next();
                                                        object2.put(string2, jSONObject.get(string2));
                                                    }
                                                    object2.remove("extendedStatus");
                                                    object = object2;
                                                }
                                                catch (JSONException jSONException) {}
                                            }
                                            if ((l = object.getLong("mediaSessionId")) != this.zzb) {
                                                this.zzb = l;
                                                n7 = 1;
                                            } else {
                                                n7 = 0;
                                            }
                                            if (object.has("playerState")) {
                                                String string3;
                                                int n8;
                                                object5 = object.getString("playerState");
                                                int n9 = ((String)object5).equals("IDLE") ? 1 : (((String)object5).equals("PLAYING") ? 2 : (((String)object5).equals("PAUSED") ? 3 : (((String)object5).equals("BUFFERING") ? 4 : (((String)object5).equals("LOADING") ? 5 : 0))));
                                                if (n9 != this.zze) {
                                                    this.zze = n9;
                                                    n7 |= 2;
                                                }
                                                if (n9 == 1 && object.has("idleReason") && (n8 = (string3 = object.getString("idleReason")).equals("CANCELLED") ? 2 : (string3.equals("INTERRUPTED") ? 3 : (string3.equals("FINISHED") ? 1 : (string3.equals("ERROR") ? 4 : 0)))) != this.zzf) {
                                                    this.zzf = n8;
                                                    n7 |= 2;
                                                }
                                            }
                                            if (object.has("playbackRate") && this.zzd != (d = object.getDouble("playbackRate"))) {
                                                this.zzd = d;
                                                n7 |= 2;
                                            }
                                            if (object.has("currentTime")) {
                                                l = CastUtils.secToMillisec(object.getDouble("currentTime"));
                                                if (l != this.zzg) {
                                                    this.zzg = l;
                                                    n7 |= 2;
                                                }
                                                n7 |= 0x80;
                                            }
                                            if (object.has("supportedMediaCommands") && (l = object.getLong("supportedMediaCommands")) != this.zzh) {
                                                this.zzh = l;
                                                n7 |= 2;
                                            }
                                            if (!object.has("volume")) break block51;
                                            if (n == 0) {
                                                JSONObject jSONObject2 = object.getJSONObject("volume");
                                                double d2 = jSONObject2.getDouble("level");
                                                if (d2 != this.zzi) {
                                                    this.zzi = d2;
                                                    n = n7 | 2;
                                                } else {
                                                    n = n7;
                                                }
                                                if ((n7 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzj) {
                                                    this.zzj = n7;
                                                    n |= 2;
                                                }
                                                break block52;
                                            } else {
                                                n = n7;
                                            }
                                            break block52;
                                        }
                                        n = n7;
                                    }
                                    if ((object3 = CastUtils.zzj(object4 = object.has("activeTrackIds") ? object.getJSONArray("activeTrackIds") : null)) == null) break block53;
                                    object4 = this.zzk;
                                    if (object4 == null || ((JSONArray)object4).length != ((long[])object3).length) break block49;
                                    for (int i = 0; i < ((long[])object3).length; ++i) {
                                        if (this.zzk[i] == object3[i]) {
                                            continue;
                                        }
                                        break block49;
                                    }
                                    break block54;
                                }
                                if (this.zzk == null) break block54;
                            }
                            this.zzk = object3;
                            n |= 2;
                        }
                        if (object.has("customData")) {
                            this.zzo = object.getJSONObject("customData");
                            this.zzn = null;
                            n |= 2;
                        }
                        if (object.has("media")) {
                            JSONObject jSONObject = object.getJSONObject("media");
                            object3 = (Object)new MediaInfo;
                            object3(jSONObject);
                            object2 = this.zza;
                            if (object2 == null || !((MediaInfo)((Object)object2)).equals(object3)) {
                                this.zza = (MediaInfo)((Object)object3);
                                n |= 2;
                            }
                            if (jSONObject.has("metadata")) {
                                n |= 4;
                            }
                        }
                        if (object.has("currentItemId") && this.zzc != (n6 = object.getInt("currentItemId"))) {
                            this.zzc = n6;
                            n |= 2;
                        }
                        if (this.zzm != (n5 = object.optInt("preloadedItemId", 0))) {
                            this.zzm = n5;
                            n |= 0x10;
                        }
                        if (this.zzl != (n5 = object.optInt("loadingItemId", 0))) {
                            this.zzl = n5;
                            n |= 2;
                        }
                        if (MediaStatus.zzf(this.zze, this.zzf, this.zzl, n2 = (mediaInfo = this.zza) == null ? -1 : mediaInfo.getStreamType())) break block55;
                        if (object.has("repeatMode")) {
                            Integer n10 = MediaCommon.mediaRepeatModeFromString(object.getString("repeatMode"));
                            int n11 = n10 == null ? this.zzp : n10;
                            Integer n12 = n11;
                            if (this.zzp != n12) {
                                this.zzp = n12;
                                n2 = 1;
                            } else {
                                n2 = 0;
                            }
                        } else {
                            n2 = 0;
                        }
                        if (!object.has("items")) break block56;
                        object2 = object.getJSONArray("items");
                        n4 = object2.length();
                        sparseArray = new SparseArray();
                        for (n3 = 0; n3 < n4; ++n3) {
                            sparseArray.put(n3, (Object)object2.getJSONObject(n3).getInt("itemId"));
                        }
                        arrayList = new ArrayList<AbstractSafeParcelable>();
                        break block57;
                    }
                    this.zzc = 0;
                    this.zzl = 0;
                    this.zzm = 0;
                    if (!this.zzq.isEmpty()) {
                        this.zzp = 0;
                        this.zzq.clear();
                        this.zzy.clear();
                        n |= 8;
                    }
                    break block58;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    AbstractSafeParcelable abstractSafeParcelable;
                    Object object6 = (Integer)sparseArray.get(n3);
                    JSONObject jSONObject = object2.getJSONObject(n3);
                    MediaQueueItem mediaQueueItem = this.getItemById((Integer)object6);
                    if (mediaQueueItem != null) {
                        n2 |= mediaQueueItem.fromJson(jSONObject);
                        arrayList.add(mediaQueueItem);
                        if (n3 == this.getIndexById((Integer)object6)) continue;
                        n2 = 1;
                        continue;
                    }
                    if ((Integer)object6 == this.zzc && (abstractSafeParcelable = this.zza) != null) {
                        object6 = new MediaQueueItem.Builder((MediaInfo)abstractSafeParcelable);
                        abstractSafeParcelable = ((MediaQueueItem.Builder)object6).build();
                        abstractSafeParcelable.fromJson(jSONObject);
                        arrayList.add(abstractSafeParcelable);
                        n2 = 1;
                        continue;
                    }
                    MediaQueueItem mediaQueueItem2 = new MediaQueueItem(jSONObject);
                    arrayList.add(mediaQueueItem2);
                    n2 = 1;
                }
                n3 = this.zzq.size() != n4 ? 0 : 1;
                n2 = n3 ^ 1 | n2;
                this.zze(arrayList);
            }
            if (n2 != 0) {
                n |= 8;
            }
        }
        AbstractSafeParcelable abstractSafeParcelable = AdBreakStatus.zza(object.optJSONObject("breakStatus"));
        AdBreakStatus adBreakStatus = this.zzs;
        if (adBreakStatus == null && abstractSafeParcelable != null || adBreakStatus != null && !adBreakStatus.equals(abstractSafeParcelable)) {
            boolean bl = abstractSafeParcelable != null ? (abstractSafeParcelable.getBreakId() == null ? abstractSafeParcelable.getBreakClipId() != null : true) : false;
            this.zzr = bl;
            this.zzs = abstractSafeParcelable;
            n |= 0x20;
        }
        Object object7 = VideoInfo.zza(object.optJSONObject("videoInfo"));
        abstractSafeParcelable = this.zzt;
        if (abstractSafeParcelable == null && object7 != null || abstractSafeParcelable != null && !abstractSafeParcelable.equals(object7)) {
            this.zzt = object7;
            n |= 0x40;
        }
        if (object.has("breakInfo") && (object7 = this.zza) != null) {
            ((MediaInfo)((Object)object7)).zzr(object.getJSONObject("breakInfo"));
            n |= 2;
        }
        if (object.has("queueData")) {
            object7 = new MediaQueueData.Builder();
            ((MediaQueueData.Builder)object7).zza(object.getJSONObject("queueData"));
            this.zzv = ((MediaQueueData.Builder)object7).build();
            boolean bl = this.zzv.zzk();
            if (this.zzw != bl) {
                this.zzw = bl;
                n |= 8;
            }
        }
        if (object.has("liveSeekableRange")) {
            this.zzu = MediaLiveSeekableRange.zza(object.optJSONObject("liveSeekableRange"));
            return n | 2;
        }
        int n13 = this.zzu != null ? n | 2 : n;
        this.zzu = null;
        return n13;
    }

    public final long zzb() {
        return this.zzb;
    }

    private final void zze(@Nullable List list) {
        this.zzq.clear();
        this.zzy.clear();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)list.get(i));
                this.zzq.add(mediaQueueItem);
                this.zzy.put(mediaQueueItem.getItemId(), (Object)i);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzd() {
        int n;
        MediaInfo mediaInfo = this.zza;
        if (mediaInfo == null) {
            n = -1;
            return MediaStatus.zzf(this.zze, this.zzf, this.zzl, n);
        }
        n = mediaInfo.getStreamType();
        return MediaStatus.zzf(this.zze, this.zzf, this.zzl, n);
    }

    private static final boolean zzf(int n, int n2, int n3, int n4) {
        if (n != 1) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: {
                return n3 == 0;
            }
            case 2: {
                return n4 != 2;
            }
        }
        return true;
    }

    @KeepForSdk
    public class Writer {
        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setActiveTrackIds(@Nullable long[] activeTrackIds) {
            void var1_1;
            MediaStatus.this.zzk = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setAdBreakStatus(@Nullable AdBreakStatus adBreakStatus) {
            void var1_1;
            MediaStatus.this.zzs = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setCurrentItemId(int currentItemId) {
            void var1_1;
            MediaStatus.this.zzc = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            Object this_ = this_.MediaStatus.this;
            ((MediaStatus)((Object)this_)).zzo = var1_1;
            ((MediaStatus)((Object)this_)).zzn = null;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setIdleReason(int idleReason) {
            void var1_1;
            MediaStatus.this.zzf = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setIsPlayingAd(boolean isPlayingAd) {
            void var1_1;
            MediaStatus.this.zzr = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setLiveSeekableRange(@Nullable MediaLiveSeekableRange liveSeekableRange) {
            void var1_1;
            MediaStatus.this.zzu = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setLoadingItemId(int loadingItemId) {
            void var1_1;
            MediaStatus.this.zzl = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMediaInfo(@Nullable MediaInfo mediaInfo) {
            void var1_1;
            MediaStatus.this.zza = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setMute(boolean muteState) {
            void var1_1;
            MediaStatus.this.zzj = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setPlaybackRate(double playbackRate) {
            void var1_1;
            MediaStatus.this.zzd = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setPlayerState(int playerState) {
            void var1_1;
            MediaStatus.this.zze = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setPreloadedItemId(int preloadedItemId) {
            void var1_1;
            MediaStatus.this.zzm = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setQueueData(@Nullable MediaQueueData queueData) {
            void var1_1;
            MediaStatus.this.zzv = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setQueueItems(@Nullable List<MediaQueueItem> queueItems) {
            void var1_1;
            MediaStatus.this.zze((List)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setQueueRepeatMode(int queueRepeatMode) {
            void var1_1;
            MediaStatus.this.zzp = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setShuffle(boolean shuffle) {
            void var1_1;
            MediaStatus.this.zzw = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamPosition(long streamPosition) {
            void var1_1;
            MediaStatus.this.zzg = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setStreamVolume(double volume) {
            void var1_1;
            MediaStatus.this.zzi = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setSupportedMediaCommands(long supportedMediaCommands) {
            void var1_1;
            MediaStatus.this.zzh = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public void setVideoInfo(@Nullable VideoInfo videoInfo) {
            void var1_1;
            MediaStatus.this.zzt = var1_1;
        }
    }

    @KeepForSdk
    public static class Builder {
        @Nullable
        private MediaInfo zza;
        private long zzb;
        private int zzc = 0;
        private double zzd;
        private int zze = 0;
        private int zzf = 0;
        private long zzg;
        private long zzh;
        private double zzi;
        private boolean zzj;
        private long[] zzk;
        private int zzl = 0;
        private int zzm = 0;
        private JSONObject zzn;
        private int zzo = 0;
        private final List zzp;
        private boolean zzq;
        private AdBreakStatus zzr;
        private VideoInfo zzs;
        private MediaLiveSeekableRange zzt;
        private MediaQueueData zzu;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setActiveTrackIds(@NonNull long[] activeTrackIds) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setAdBreakStatus(@NonNull AdBreakStatus adBreakStatus) {
            void var1_1;
            this.zzr = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setCurrentItemId(int currentItemId) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setCustomData(@NonNull JSONObject customData) {
            void var1_1;
            this.zzn = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setIdleReason(int idleReason) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setIsMute(boolean muteState) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setIsPlayingAd(boolean isPlayingAd) {
            void var1_1;
            this.zzq = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setLiveSeekableRange(@NonNull MediaLiveSeekableRange liveSeekableRange) {
            void var1_1;
            this.zzt = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setLoadingItemId(int loadingItemId) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setMediaInfo(@Nullable MediaInfo mediaInfo) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setMediaSessionId(long mediaSessionId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setPlaybackRate(double playbackRate) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setPlayerState(int playerState) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setPreloadedItemId(int preloadedItemId) {
            void var1_1;
            this.zzm = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setQueueData(@NonNull MediaQueueData queueData) {
            void var1_1;
            this.zzu = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setQueueItems(@NonNull List<MediaQueueItem> queueItems) {
            void var1_1;
            this.zzp.clear();
            this.zzp.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setQueueRepeatMode(int queueRepeatMode) {
            void var1_1;
            this.zzo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setStreamPosition(long streamPosition) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setStreamVolume(double volume) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setSupportedMediaCommands(long supportedMediaCommands) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setVideoInfo(@NonNull VideoInfo videoInfo) {
            void var1_1;
            this.zzs = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public MediaStatus build() {
            MediaStatus mediaStatus = new MediaStatus(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl, this.zzm, null, this.zzo, this.zzp, this.zzq, this.zzr, this.zzs, this.zzt, this.zzu);
            mediaStatus.zzo = this.zzn;
            return mediaStatus;
        }

        public Builder() {
            ArrayList arrayList;
            this.zzp = arrayList = new ArrayList();
        }
    }
}

