/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zzbx;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="MediaErrorCreator")
public class MediaError
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final String ERROR_TYPE_INVALID_PLAYER_STATE = "INVALID_PLAYER_STATE";
    @NonNull
    public static final String ERROR_TYPE_LOAD_FAILED = "LOAD_FAILED";
    @NonNull
    public static final String ERROR_TYPE_LOAD_CANCELLED = "LOAD_CANCELLED";
    @NonNull
    public static final String ERROR_TYPE_INVALID_REQUEST = "INVALID_REQUEST";
    @NonNull
    public static final String ERROR_TYPE_ERROR = "ERROR";
    @NonNull
    public static final String ERROR_REASON_INVALID_COMMAND = "INVALID_COMMAND";
    @NonNull
    public static final String ERROR_REASON_INVALID_PARAMS = "INVALID_PARAMS";
    @NonNull
    public static final String ERROR_REASON_INVALID_MEDIA_SESSION_ID = "INVALID_MEDIA_SESSION_ID";
    @NonNull
    public static final String ERROR_REASON_SKIP_LIMIT_REACHED = "SKIP_LIMIT_REACHED";
    @NonNull
    public static final String ERROR_REASON_NOT_SUPPORTED = "NOT_SUPPORTED";
    @NonNull
    public static final String ERROR_REASON_LANGUAGE_NOT_SUPPORTED = "LANGUAGE_NOT_SUPPORTED";
    @NonNull
    public static final String ERROR_REASON_END_OF_QUEUE = "END_OF_QUEUE";
    @NonNull
    public static final String ERROR_REASON_DUPLICATE_REQUEST_ID = "DUPLICATE_REQUEST_ID";
    @NonNull
    public static final String ERROR_REASON_VIDEO_DEVICE_REQUIRED = "VIDEO_DEVICE_REQUIRED";
    @NonNull
    public static final String ERROR_REASON_PREMIUM_ACCOUNT_REQUIRED = "PREMIUM_ACCOUNT_REQUIRED";
    @NonNull
    public static final String ERROR_REASON_APP_ERROR = "APP_ERROR";
    @NonNull
    public static final String ERROR_REASON_AUTHENTICATION_EXPIRED = "AUTHENTICATION_EXPIRED";
    @NonNull
    public static final String ERROR_REASON_CONCURRENT_STREAM_LIMIT = "CONCURRENT_STREAM_LIMIT";
    @NonNull
    public static final String ERROR_REASON_PARENTAL_CONTROL_RESTRICTED = "PARENTAL_CONTROL_RESTRICTED";
    @NonNull
    public static final String ERROR_REASON_CONTENT_FILTERED = "CONTENT_FILTERED";
    @NonNull
    public static final String ERROR_REASON_NOT_AVAILABLE_IN_REGION = "NOT_AVAILABLE_IN_REGION";
    @NonNull
    public static final String ERROR_REASON_CONTENT_ALREADY_PLAYING = "CONTENT_ALREADY_PLAYING";
    @NonNull
    public static final String ERROR_REASON_INVALID_REQUEST = "INVALID_REQUEST";
    @NonNull
    public static final String ERROR_REASON_GENERIC_LOAD_ERROR = "GENERIC_LOAD_ERROR";
    @KeepForSdk
    @NonNull
    public static final Parcelable.Creator<MediaError> CREATOR;
    @SafeParcelable.Field(id=2, getter="getType")
    @Nullable
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getRequestId")
    private long zzc;
    @SafeParcelable.Field(id=4, getter="getDetailedErrorCode")
    @DetailedErrorCode
    @Nullable
    private final Integer zzd;
    @SafeParcelable.Field(id=5, getter="getReason")
    @Nullable
    private final String zze;
    @SafeParcelable.Field(id=6)
    @Nullable
    String zza;
    @Nullable
    private final JSONObject zzf;

    @KeepForSdk
    public long getRequestId() {
        return this.zzc;
    }

    @Nullable
    public Integer getDetailedErrorCode() {
        return this.zzd;
    }

    @Nullable
    public String getReason() {
        return this.zze;
    }

    @Nullable
    public String getType() {
        return this.zzb;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzf;
    }

    @KeepForSdk
    @NonNull
    public JSONObject toJson() {
        String string2;
        JSONObject jSONObject;
        block3: {
            Object object;
            try {
                jSONObject = new JSONObject();
                jSONObject.put("requestId", object.zzc);
                jSONObject.putOpt("detailedErrorCode", (Object)object.zzd);
                jSONObject.putOpt("reason", (Object)object.zze);
                jSONObject.put("customData", (Object)object.zzf);
                string2 = "type";
                object = object.zzb;
                if (object != null) break block3;
                object = ERROR_TYPE_ERROR;
            }
            catch (JSONException jSONException) {
                object = new JSONObject();
                return object;
            }
        }
        jSONObject.putOpt(string2, object);
        return jSONObject;
    }

    static {
        zzbx zzbx2;
        CREATOR = zzbx2 = new zzbx();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public MediaError(@Nullable String type, long requestId, @Nullable Integer detailedErrorCode, @Nullable String reason, @Nullable JSONObject customData) {
        void var6_5;
        void var5_4;
        void var4_3;
        void var2_2;
        void var1_1;
        this.zzb = var1_1;
        this.zzc = var2_2;
        this.zzd = var4_3;
        this.zze = var5_4;
        this.zzf = var6_5;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setRequestId(long requestId) {
        void var1_1;
        this.zzc = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setType(@Nullable String type) {
        void var1_1;
        this.zzb = var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        void var2_5;
        JSONObject jSONObject = this.zzf;
        if (jSONObject == null) {
            Object var2_4 = null;
        } else {
            String string2 = jSONObject.toString();
        }
        this.zza = var2_5;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)var1_1);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getType(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getRequestId());
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)4, (Integer)this.getDetailedErrorCode(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getReason(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.zza, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public static MediaError zza(@NonNull JSONObject object) {
        String string2 = object.optString("type", ERROR_TYPE_ERROR);
        long l = object.optLong("requestId");
        Integer n = object.has("detailedErrorCode") ? Integer.valueOf(object.optInt("detailedErrorCode")) : null;
        String string3 = CastUtils.optStringOrNull(object, "reason");
        object = object.has("customData") ? object.optJSONObject("customData") : null;
        return new MediaError(string2, l, n, string3, (JSONObject)object);
    }

    public static class Builder {
        @Nullable
        private Integer zza;
        private long zzb;
        @Nullable
        private String zzc;
        @Nullable
        private JSONObject zzd;
        @Nullable
        private String zze = "ERROR";

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomData(@Nullable JSONObject customData) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDetailedErrorCode(@Nullable Integer detailedErrorCode) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setReason(@Nullable String reason) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setRequestId(long requestId) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setType(@Nullable String type) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        @NonNull
        public MediaError build() {
            String string2 = this.zze;
            if (string2 == null) {
                string2 = MediaError.ERROR_TYPE_ERROR;
            }
            MediaError mediaError = new MediaError(string2, this.zzb, this.zza, this.zzc, this.zzd);
            return mediaError;
        }
    }

    public static @interface DetailedErrorCode {
        public static final int MEDIA_UNKNOWN = 100;
        public static final int MEDIA_ABORTED = 101;
        public static final int MEDIA_DECODE = 102;
        public static final int MEDIA_NETWORK = 103;
        public static final int MEDIA_SRC_NOT_SUPPORTED = 104;
        public static final int SOURCE_BUFFER_FAILURE = 110;
        public static final int MEDIAKEYS_UNKNOWN = 200;
        public static final int MEDIAKEYS_NETWORK = 201;
        public static final int MEDIAKEYS_UNSUPPORTED = 202;
        public static final int MEDIAKEYS_WEBCRYPTO = 203;
        public static final int NETWORK_UNKNOWN = 300;
        public static final int SEGMENT_NETWORK = 301;
        public static final int HLS_NETWORK_MASTER_PLAYLIST = 311;
        public static final int HLS_NETWORK_PLAYLIST = 312;
        public static final int HLS_NETWORK_NO_KEY_RESPONSE = 313;
        public static final int HLS_NETWORK_KEY_LOAD = 314;
        public static final int HLS_NETWORK_INVALID_SEGMENT = 315;
        public static final int HLS_SEGMENT_PARSING = 316;
        public static final int DASH_NETWORK = 321;
        public static final int DASH_NO_INIT = 322;
        public static final int SMOOTH_NETWORK = 331;
        public static final int SMOOTH_NO_MEDIA_DATA = 332;
        public static final int MANIFEST_UNKNOWN = 400;
        public static final int HLS_MANIFEST_MASTER = 411;
        public static final int HLS_MANIFEST_PLAYLIST = 412;
        public static final int DASH_MANIFEST_UNKNOWN = 420;
        public static final int DASH_MANIFEST_NO_PERIODS = 421;
        public static final int DASH_MANIFEST_NO_MIMETYPE = 422;
        public static final int DASH_INVALID_SEGMENT_INFO = 423;
        public static final int SMOOTH_MANIFEST = 431;
        public static final int SEGMENT_UNKNOWN = 500;
        public static final int TEXT_UNKNOWN = 600;
        public static final int APP = 900;
        public static final int BREAK_CLIP_LOADING_ERROR = 901;
        public static final int BREAK_SEEK_INTERCEPTOR_ERROR = 902;
        public static final int IMAGE_ERROR = 903;
        public static final int LOAD_INTERRUPTED = 904;
        public static final int LOAD_FAILED = 905;
        public static final int MEDIA_ERROR_MESSAGE = 906;
        public static final int GENERIC = 999;
    }
}

