/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.internal.ShowFirstParty;
import java.util.Locale;

public final class CastStatusCodes
extends CommonStatusCodes {
    public static final int SUCCESS = 0;
    public static final int NETWORK_ERROR = 7;
    public static final int TIMEOUT = 15;
    public static final int INTERRUPTED = 14;
    public static final int INTERNAL_ERROR = 8;
    public static final int UNKNOWN_ERROR = 13;
    public static final int AUTHENTICATION_FAILED = 2000;
    public static final int INVALID_REQUEST = 2001;
    public static final int CANCELED = 2002;
    public static final int NOT_ALLOWED = 2003;
    public static final int APPLICATION_NOT_FOUND = 2004;
    public static final int APPLICATION_NOT_RUNNING = 2005;
    public static final int MESSAGE_TOO_LARGE = 2006;
    public static final int MESSAGE_SEND_BUFFER_TOO_FULL = 2007;
    public static final int DEVICE_CONNECTION_SUSPENDED = 2016;
    public static final int FAILED = 2100;
    public static final int REPLACED = 2103;
    public static final int MEDIA_ERROR = 2104;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_CAST_PLATFORM_INCOMPATIBLE = 2110;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_URL_INSEURE = 2111;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_HOST_NOT_ALLOWED = 2112;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_CAST_PLATFORM_NOT_CONNECTED = 2113;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_NO_CAST_CONFIGURATION = 2114;
    @KeepForSdk
    @ShowFirstParty
    public static final int ERROR_DEVICE_ID_FLAGS_NOT_SET = 2115;
    public static final int ERROR_SERVICE_CREATION_FAILED = 2200;
    public static final int ERROR_SERVICE_DISCONNECTED = 2201;
    public static final int ERROR_STOPPING_SERVICE_FAILED = 2202;

    @NonNull
    public static String getStatusCodeString(int statusCode) {
        int n;
        if (statusCode >= -999 && n <= 999) {
            switch (n) {
                default: {
                    return CommonStatusCodes.getStatusCodeString((int)n);
                }
                case 15: {
                    return "TIMEOUT";
                }
                case 14: {
                    return "INTERRUPTED";
                }
                case 7: {
                    return "NETWORK_ERROR";
                }
                case 0: 
            }
            return "SUCCESS";
        }
        if (n >= 2000 && n <= 2099) {
            switch (n) {
                default: {
                    Locale locale = Locale.ROOT;
                    Object[] objectArray = new Object[]{"Common cast status code", n};
                    return String.format(locale, "%s %d", objectArray);
                }
                case 2015: {
                    return "TCP_PROBER_FAIL_TO_VERIFY_DEVICE";
                }
                case 2007: {
                    return "MESSAGE_SEND_BUFFER_TOO_FULL";
                }
                case 2006: {
                    return "MESSAGE_TOO_LARGE";
                }
                case 2005: {
                    return "APPLICATION_NOT_RUNNING";
                }
                case 2004: {
                    return "APPLICATION_NOT_FOUND";
                }
                case 2003: {
                    return "NOT_ALLOWED";
                }
                case 2002: {
                    return "CANCELED";
                }
                case 2001: {
                    return "INVALID_REQUEST";
                }
                case 2000: 
            }
            return "AUTHENTICATION_FAILED";
        }
        if (n < 2100 || n > 2109) {
            if (n < 2150 || n > 2169) {
                if (n < 2200 || n > 2219) {
                    if (n < 2250 || n > 2289) {
                        if (n < 2300 || n > 2309) {
                            if (n < 2310 || n > 2319) {
                                if (n < 2350 || n > 2359) {
                                    if (n < 2400 || n > 2419) {
                                        if (n < 2450 || n > 2469) {
                                            if (n < 2470 || n > 2479) {
                                                if (n >= 2490 && n <= 2499) {
                                                    Locale locale = Locale.ROOT;
                                                    Object[] objectArray = new Object[]{"Cast media loading status code", n};
                                                    return String.format(locale, "%s %d", objectArray);
                                                }
                                                Locale locale = Locale.ROOT;
                                                Object[] objectArray = new Object[]{n};
                                                return String.format(locale, "Unknown cast status code %d", objectArray);
                                            }
                                            Locale locale = Locale.ROOT;
                                            Object[] objectArray = new Object[]{"Cast application status code", n};
                                            return String.format(locale, "%s %d", objectArray);
                                        }
                                        Locale locale = Locale.ROOT;
                                        Object[] objectArray = new Object[]{"Cast nearby casting status code", n};
                                        return String.format(locale, "%s %d", objectArray);
                                    }
                                    Locale locale = Locale.ROOT;
                                    Object[] objectArray = new Object[]{"Cast relay casting status code", n};
                                    return String.format(locale, "%s %d", objectArray);
                                }
                                Locale locale = Locale.ROOT;
                                Object[] objectArray = new Object[]{"Cast multizone device status code", n};
                                return String.format(locale, "%s %d", objectArray);
                            }
                            Locale locale = Locale.ROOT;
                            Object[] objectArray = new Object[]{"Endpoint switch status code", n};
                            return String.format(locale, "%s %d", objectArray);
                        }
                        Locale locale = Locale.ROOT;
                        Object[] objectArray = new Object[]{"Cast service status code", n};
                        return String.format(locale, "%s %d", objectArray);
                    }
                    Locale locale = Locale.ROOT;
                    Object[] objectArray = new Object[]{"Cast socket status code", n};
                    return String.format(locale, "%s %d", objectArray);
                }
                Locale locale = Locale.ROOT;
                Object[] objectArray = new Object[]{"Cast remote display status code", n};
                return String.format(locale, "%s %d", objectArray);
            }
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{"Cast session status code", n};
            return String.format(locale, "%s %d", objectArray);
        }
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{"Media control channel status code", n};
        return String.format(locale, "%s %d", objectArray);
    }

    private CastStatusCodes() {
    }
}

