/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.zzy;
import com.google.android.gms.cast.internal.zzz;
import com.google.android.gms.cast.zzs;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CastDeviceCreator")
public class CastDevice
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    @NonNull
    public static final Parcelable.Creator<CastDevice> CREATOR;
    @SafeParcelable.Field(id=2, getter="getDeviceIdRaw")
    private final String zzb;
    @SafeParcelable.Field(id=3)
    String zza;
    private InetAddress zzc;
    @SafeParcelable.Field(id=4, getter="getFriendlyName")
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getModelName")
    private final String zze;
    @SafeParcelable.Field(id=6, getter="getDeviceVersion")
    private final String zzf;
    @SafeParcelable.Field(id=7, getter="getServicePort")
    private final int zzg;
    @SafeParcelable.Field(id=8, getter="getIcons")
    private final List zzh;
    @SafeParcelable.Field(id=9, getter="getCapabilities")
    private final int zzi;
    @SafeParcelable.Field(id=10, getter="getStatus", defaultValue="-1")
    private final int zzj;
    @SafeParcelable.Field(id=11, getter="getServiceInstanceName")
    private final String zzk;
    @SafeParcelable.Field(id=12, getter="getReceiverMetricsId")
    @Nullable
    private final String zzl;
    @SafeParcelable.Field(id=13, getter="getRcnEnabledStatus")
    private final int zzm;
    @SafeParcelable.Field(id=14, getter="getHotspotBssid")
    @Nullable
    private final String zzn;
    @SafeParcelable.Field(id=15, getter="getIpLowestTwoBytes")
    private final byte[] zzo;
    @SafeParcelable.Field(id=16, getter="getCloudDeviceId")
    @Nullable
    private final String zzp;
    @SafeParcelable.Field(id=17, getter="isCloudOnlyDevice")
    private final boolean zzq;
    @SafeParcelable.Field(id=18, getter="getCastEurekaInfo")
    @Nullable
    private final zzz zzr;

    public int getServicePort() {
        return this.zzg;
    }

    public int hashCode() {
        String this_ = ((CastDevice)((Object)this_)).zzb;
        if (this_ == null) {
            return 0;
        }
        return this_.hashCode();
    }

    @Nullable
    public static CastDevice getFromBundle(@Nullable Bundle extras) {
        Bundle bundle;
        if (extras == null) {
            return null;
        }
        ClassLoader classLoader = CastDevice.class.getClassLoader();
        if (classLoader == null) {
            return null;
        }
        bundle.setClassLoader(classLoader);
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        void var2_2;
        void var1_1;
        if (this.zzh.isEmpty()) {
            return null;
        }
        if (var1_1 <= 0) return (WebImage)this.zzh.get(0);
        if (var2_2 <= 0) {
            return (WebImage)this.zzh.get(0);
        }
        Iterator iterator = this.zzh.iterator();
        WebImage webImage = null;
        WebImage webImage2 = null;
        while (iterator.hasNext()) {
            WebImage webImage3;
            block12: {
                block15: {
                    block16: {
                        int n;
                        int n2;
                        block13: {
                            block14: {
                                webImage3 = (WebImage)iterator.next();
                                n2 = webImage3.getWidth();
                                n = webImage3.getHeight();
                                if (n2 < var1_1 || n < var2_2) break block13;
                                if (webImage == null) break block14;
                                if (webImage.getWidth() > n2) {
                                    if (webImage.getHeight() > n) {
                                        webImage = webImage3;
                                        webImage3 = webImage2;
                                        break block12;
                                    } else {
                                        webImage3 = webImage2;
                                    }
                                    break block12;
                                } else {
                                    webImage3 = webImage2;
                                }
                                break block12;
                            }
                            webImage = webImage3;
                            webImage3 = webImage2;
                            break block12;
                        }
                        if (n2 >= var1_1) break block15;
                        if (n >= var2_2) break block16;
                        if (webImage2 != null) {
                            if (webImage2.getWidth() < n2) {
                                if (webImage2.getHeight() >= n) {
                                    webImage3 = webImage2;
                                }
                                break block12;
                            } else {
                                webImage3 = webImage2;
                            }
                        }
                        break block12;
                    }
                    webImage3 = webImage2;
                    break block12;
                }
                webImage3 = webImage2;
            }
            webImage2 = webImage3;
        }
        if (webImage != null) {
            return webImage;
        }
        if (webImage2 == null) return (WebImage)this.zzh.get(0);
        return webImage2;
    }

    @NonNull
    public String getDeviceId() {
        if (this.zzb.startsWith("__cast_nearby__")) {
            return this.zzb.substring(16);
        }
        return this.zzb;
    }

    @NonNull
    public String getDeviceVersion() {
        return this.zzf;
    }

    @NonNull
    public String getFriendlyName() {
        return this.zzd;
    }

    @NonNull
    public String getModelName() {
        return this.zze;
    }

    @NonNull
    public String toString() {
        Object[] objectArray = new Object[]{this.zzd, this.zzb};
        return String.format("\"%s\" (%s)", objectArray);
    }

    @Deprecated
    @Nullable
    public Inet4Address getIpAddress() {
        if (this.hasIPv4Address()) {
            return (Inet4Address)this.zzc;
        }
        return null;
    }

    @NonNull
    public InetAddress getInetAddress() {
        return this.zzc;
    }

    @NonNull
    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzh);
    }

    static {
        zzs zzs2;
        CREATOR = zzs2 = new zzs();
    }

    /*
     * WARNING - void declaration
     */
    public void putInBundle(@NonNull Bundle bundle) {
        void var1_1;
        if (bundle == null) {
            return;
        }
        var1_1.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getFriendlyName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getModelName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getDeviceVersion(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)7, (int)this.getServicePort());
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)8, this.getIcons(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)9, (int)this.zzi);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)10, (int)this.zzj);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)11, (String)this.zzk, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.zzl, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)13, (int)this.zzm);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)14, (String)this.zzn, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)15, (byte[])this.zzo, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)16, (String)this.zzp, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)17, (boolean)this.zzq);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)18, (Parcelable)this.zzb(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object obj) {
        CastDevice castDevice;
        if (obj == this) {
            return true;
        }
        if (!(castDevice instanceof CastDevice)) {
            return false;
        }
        castDevice = castDevice;
        Object object = this.zzb;
        if (object == null) {
            return castDevice.zzb == null;
        }
        return CastUtils.zzh(object, castDevice.zzb) && CastUtils.zzh(this.zzc, castDevice.zzc) && CastUtils.zzh(this.zze, castDevice.zze) && CastUtils.zzh(this.zzd, castDevice.zzd) && CastUtils.zzh(this.zzf, castDevice.zzf) && this.zzg == castDevice.zzg && CastUtils.zzh(this.zzh, castDevice.zzh) && this.zzi == castDevice.zzi && this.zzj == castDevice.zzj && CastUtils.zzh(this.zzk, castDevice.zzk) && CastUtils.zzh(this.zzm, castDevice.zzm) && CastUtils.zzh(this.zzn, castDevice.zzn) && CastUtils.zzh(this.zzl, castDevice.zzl) && CastUtils.zzh(this.zzf, castDevice.getDeviceVersion()) && this.zzg == castDevice.getServicePort() && ((object = (Object)this.zzo) == null && castDevice.zzo == null || Arrays.equals((byte[])object, castDevice.zzo)) && CastUtils.zzh(this.zzp, castDevice.zzp) && this.zzq == castDevice.zzq && CastUtils.zzh((Object)this.zzb(), (Object)castDevice.zzb());
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasCapabilities(@NonNull int[] capabilities) {
        void var1_1;
        if (capabilities == null) {
            return false;
        }
        int n = ((void)var1_1).length;
        for (int i = 0; i < n; ++i) {
            if (this.hasCapability((int)var1_1[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasCapability(int capability) {
        void var1_1;
        return (this.zzi & var1_1) == var1_1;
    }

    public boolean hasIPv4Address() {
        return this.getInetAddress() instanceof Inet4Address;
    }

    public boolean hasIPv6Address() {
        return this.getInetAddress() instanceof Inet6Address;
    }

    @VisibleForTesting
    public boolean hasIcons() {
        return !this.zzh.isEmpty();
    }

    public boolean isOnLocalNetwork() {
        if (this.zzb.startsWith("__cast_nearby__")) {
            return false;
        }
        return !this.zzq;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public boolean isSameDevice(@NonNull CastDevice castDevice) {
        void var1_1;
        if (castDevice == null) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getDeviceId()) || this.getDeviceId().startsWith("__cast_ble__") || TextUtils.isEmpty((CharSequence)var1_1.getDeviceId()) || var1_1.getDeviceId().startsWith("__cast_ble__")) {
            if (!TextUtils.isEmpty((CharSequence)this.zzn) && !TextUtils.isEmpty((CharSequence)var1_1.zzn)) {
                return CastUtils.zzh(this.zzn, var1_1.zzn);
            }
            return false;
        }
        return CastUtils.zzh(this.getDeviceId(), var1_1.getDeviceId());
    }

    @ShowFirstParty
    public final int zza() {
        return this.zzi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final zzz zzb() {
        if (this.zzr != null) return this.zzr;
        boolean bl = this.hasCapability(32);
        boolean bl2 = this.hasCapability(64);
        if (bl) return zzy.zza(1);
        if (!bl2) return this.zzr;
        return zzy.zza(1);
    }

    @ShowFirstParty
    @Nullable
    public final String zzc() {
        return this.zzl;
    }

    private static String zzd(@Nullable String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    CastDevice(@SafeParcelable.Param(id=2) String list, @SafeParcelable.Param(id=3) @Nullable String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) String string4, @SafeParcelable.Param(id=7) int n, @SafeParcelable.Param(id=8) List list2, @SafeParcelable.Param(id=9) int n2, @SafeParcelable.Param(id=10) int n3, @SafeParcelable.Param(id=11) String string5, @SafeParcelable.Param(id=12) @Nullable String string6, @SafeParcelable.Param(id=13) int n4, @SafeParcelable.Param(id=14) @Nullable String string7, @SafeParcelable.Param(id=15) byte[] byArray, @SafeParcelable.Param(id=16) @Nullable String string8, @SafeParcelable.Param(id=17) boolean bl, @SafeParcelable.Param(id=18) @Nullable zzz zzz2) {
        this.zzb = CastDevice.zzd(list);
        this.zza = CastDevice.zzd(string);
        if (!TextUtils.isEmpty((CharSequence)this.zza)) {
            try {
                this.zzc = InetAddress.getByName(this.zza);
            }
            catch (UnknownHostException unknownHostException) {
                string = this.zza;
                list = unknownHostException.getMessage();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Unable to convert host address (");
                stringBuilder.append(string);
                stringBuilder.append(") to ipaddress: ");
                stringBuilder.append((String)((Object)list));
                Log.i((String)"CastDevice", (String)stringBuilder.toString());
            }
        }
        this.zzd = CastDevice.zzd(string2);
        this.zze = CastDevice.zzd(string3);
        this.zzf = CastDevice.zzd(string4);
        this.zzg = n;
        list = list2 != null ? list2 : new List();
        this.zzh = list;
        this.zzi = n2;
        this.zzj = n3;
        this.zzk = CastDevice.zzd(string5);
        this.zzl = string6;
        this.zzm = n4;
        this.zzn = string7;
        this.zzo = byArray;
        this.zzp = string8;
        this.zzq = bl;
        this.zzr = zzz2;
    }
}

