/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdBreakStatusCreator")
public class AdBreakStatus
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AdBreakStatus> CREATOR;
    @Deprecated
    public static final int AD_BREAK_CLIP_NOT_SKIPPABLE = -1;
    private static final Logger zza;
    @SafeParcelable.Field(id=2, getter="getCurrentBreakTimeInMs")
    private final long zzb;
    @SafeParcelable.Field(id=3, getter="getCurrentBreakClipTimeInMs")
    private final long zzc;
    @SafeParcelable.Field(id=4, getter="getBreakId")
    @Nullable
    private final String zzd;
    @SafeParcelable.Field(id=5, getter="getBreakClipId")
    @Nullable
    private final String zze;
    @SafeParcelable.Field(id=6, getter="getWhenSkippableInMs")
    private final long zzf;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc, this.zzd, this.zze, this.zzf};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzc;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zzb;
    }

    public long getWhenSkippableInMs() {
        return this.zzf;
    }

    @Nullable
    public String getBreakClipId() {
        return this.zze;
    }

    @Nullable
    public String getBreakId() {
        return this.zzd;
    }

    static {
        Object object = new Logger("AdBreakStatus");
        zza = object;
        object = new zzc();
        CREATOR = object;
    }

    @SafeParcelable.Constructor
    AdBreakStatus(@SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) long l2, @SafeParcelable.Param(id=4) @Nullable String string, @SafeParcelable.Param(id=5) @Nullable String string2, @SafeParcelable.Param(id=6) long l3) {
        this.zzb = l;
        this.zzc = l2;
        this.zzd = string;
        this.zze = string2;
        this.zzf = l3;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.getCurrentBreakTimeInMs());
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.getCurrentBreakClipTimeInMs());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)this.getBreakId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getBreakClipId(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)6, (long)this.getWhenSkippableInMs());
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        AdBreakStatus adBreakStatus;
        if (this == adBreakStatus) {
            return true;
        }
        if (!(adBreakStatus instanceof AdBreakStatus)) {
            return false;
        }
        adBreakStatus = adBreakStatus;
        return this.zzb == adBreakStatus.zzb && this.zzc == adBreakStatus.zzc && CastUtils.zzh(this.zzd, adBreakStatus.zzd) && CastUtils.zzh(this.zze, adBreakStatus.zze) && this.zzf == adBreakStatus.zzf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static AdBreakStatus zza(@Nullable JSONObject object) {
        if (object == null) {
            return null;
        }
        if (!object.has("currentBreakTime")) return null;
        if (!object.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l;
            long l2 = CastUtils.secToMillisec(object.getLong("currentBreakTime"));
            long l3 = CastUtils.secToMillisec(object.getLong("currentBreakClipTime"));
            String string = CastUtils.optStringOrNull(object, "breakId");
            String string2 = CastUtils.optStringOrNull(object, "breakClipId");
            long l4 = object.optLong("whenSkippable", -1L);
            long l5 = l4 != -1L ? (l = CastUtils.secToMillisec(l4)) : l4;
            return new AdBreakStatus(l2, l3, string, string2, l5);
        }
        catch (JSONException jSONException) {
            zza.e(jSONException, "Error while creating an AdBreakClipInfo from JSON", new Object[0]);
            return null;
        }
    }

    final JSONObject zzb() {
        JSONObject jSONObject;
        block3: {
            long l;
            jSONObject = new JSONObject();
            try {
                jSONObject.put("currentBreakTime", CastUtils.millisecToSec(object.zzb));
                jSONObject.put("currentBreakClipTime", CastUtils.millisecToSec(object.zzc));
                jSONObject.putOpt("breakId", (Object)object.zzd);
                jSONObject.putOpt("breakClipId", (Object)object.zze);
                l = object.zzf;
                if (l == -1L) break block3;
            }
            catch (JSONException jSONException) {
                zza.e(jSONException, "Error transforming AdBreakStatus into JSONObject", new Object[0]);
                JSONObject jSONObject2 = new JSONObject();
                return jSONObject2;
            }
            Object object = "whenSkippable";
            jSONObject.put((String)object, CastUtils.millisecToSec(l));
        }
        return jSONObject;
    }

    public static class Builder {
        private long zza;
        private long zzb;
        private String zzc;
        private String zzd;
        private long zze = -1L;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBreakClipId(@NonNull String breakClipId) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBreakId(@NonNull String breakId) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrentBreakClipTimeInMs(long currentBreakClipTimeInMs) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCurrentBreakTimeInMs(long currentBreakTimeInMs) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setWhenSkippableInMs(long whenSkippableInMs) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        @NonNull
        public AdBreakStatus build() {
            AdBreakStatus adBreakStatus = new AdBreakStatus(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
            return adBreakStatus;
        }
    }
}

