/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.HlsSegmentFormat;
import com.google.android.gms.cast.VastAdsRequest;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdBreakClipInfoCreator")
public class AdBreakClipInfo
extends AbstractSafeParcelable {
    public static final long AD_BREAK_CLIP_NOT_SKIPPABLE = -1L;
    @NonNull
    public static final Parcelable.Creator<AdBreakClipInfo> CREATOR;
    @SafeParcelable.Field(id=2, getter="getId")
    private final String zza;
    @SafeParcelable.Field(id=3, getter="getTitle")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=4, getter="getDurationInMs")
    private final long zzc;
    @SafeParcelable.Field(id=5, getter="getContentUrl")
    @Nullable
    private final String zzd;
    @SafeParcelable.Field(id=6, getter="getMimeType")
    @Nullable
    private final String zze;
    @SafeParcelable.Field(id=7, getter="getClickThroughUrl")
    @Nullable
    private final String zzf;
    @SafeParcelable.Field(id=8, getter="getCustomDataAsString")
    @Nullable
    private String zzg;
    @SafeParcelable.Field(id=9, getter="getContentId")
    @Nullable
    private final String zzh;
    @SafeParcelable.Field(id=10, getter="getImageUrl")
    @Nullable
    private final String zzi;
    @SafeParcelable.Field(id=11, getter="getWhenSkippableInMs")
    private final long zzj;
    @SafeParcelable.Field(id=12, getter="getHlsSegmentFormat")
    @Nullable
    @HlsSegmentFormat
    private final String zzk;
    @SafeParcelable.Field(id=13, getter="getVastAdsRequest")
    @Nullable
    private final VastAdsRequest zzl;
    private JSONObject zzm;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl};
        return Objects.hashCode((Object[])objectArray);
    }

    public long getDurationInMs() {
        return this.zzc;
    }

    public long getWhenSkippableInMs() {
        return this.zzj;
    }

    @Nullable
    public VastAdsRequest getVastAdsRequest() {
        return this.zzl;
    }

    @Nullable
    public String getClickThroughUrl() {
        return this.zzf;
    }

    @Nullable
    public String getContentId() {
        return this.zzh;
    }

    @Nullable
    public String getContentUrl() {
        return this.zzd;
    }

    @Nullable
    public String getHlsSegmentFormat() {
        return this.zzk;
    }

    @NonNull
    public String getId() {
        return this.zza;
    }

    @Nullable
    public String getImageUrl() {
        return this.zzi;
    }

    @Nullable
    public String getMimeType() {
        return this.zze;
    }

    @Nullable
    public String getTitle() {
        return this.zzb;
    }

    @Nullable
    public JSONObject getCustomData() {
        return this.zzm;
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    AdBreakClipInfo(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) @Nullable String object, @SafeParcelable.Param(id=4) long l, @SafeParcelable.Param(id=5) @Nullable String objectArray, @SafeParcelable.Param(id=6) @Nullable String string2, @SafeParcelable.Param(id=7) @Nullable String string3, @SafeParcelable.Param(id=8) @Nullable String string4, @SafeParcelable.Param(id=9) @Nullable String string5, @SafeParcelable.Param(id=10) @Nullable String string6, @SafeParcelable.Param(id=11) long l2, @SafeParcelable.Param(id=12) @HlsSegmentFormat @Nullable String string7, @SafeParcelable.Param(id=13) @Nullable VastAdsRequest vastAdsRequest) {
        this.zza = string;
        this.zzb = object;
        this.zzc = l;
        this.zzd = objectArray;
        this.zze = string2;
        this.zzf = string3;
        this.zzg = string4;
        this.zzh = string5;
        this.zzi = string6;
        this.zzj = l2;
        this.zzk = string7;
        this.zzl = vastAdsRequest;
        if (TextUtils.isEmpty((CharSequence)this.zzg)) {
            this.zzm = string;
            return;
        }
        try {
            super(this.zzg);
            this.zzm = string;
            return;
        }
        catch (JSONException jSONException) {
            JSONObject jSONObject;
            object = Locale.ROOT;
            objectArray = new Object[]{jSONException.getMessage()};
            Log.w((String)"AdBreakClipInfo", (String)String.format((Locale)object, "Error creating AdBreakClipInfo: %s", objectArray));
            this.zzg = null;
            this.zzm = jSONObject = new JSONObject();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getTitle(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)4, (long)this.getDurationInMs());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getContentUrl(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.getMimeType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)7, (String)this.getClickThroughUrl(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)8, (String)this.zzg, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)9, (String)this.getContentId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)10, (String)this.getImageUrl(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)11, (long)this.getWhenSkippableInMs());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)12, (String)this.getHlsSegmentFormat(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)13, (Parcelable)this.getVastAdsRequest(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object other) {
        AdBreakClipInfo adBreakClipInfo;
        if (this == adBreakClipInfo) {
            return true;
        }
        if (!(adBreakClipInfo instanceof AdBreakClipInfo)) {
            return false;
        }
        adBreakClipInfo = adBreakClipInfo;
        return CastUtils.zzh(this.zza, adBreakClipInfo.zza) && CastUtils.zzh(this.zzb, adBreakClipInfo.zzb) && this.zzc == adBreakClipInfo.zzc && CastUtils.zzh(this.zzd, adBreakClipInfo.zzd) && CastUtils.zzh(this.zze, adBreakClipInfo.zze) && CastUtils.zzh(this.zzf, adBreakClipInfo.zzf) && CastUtils.zzh(this.zzg, adBreakClipInfo.zzg) && CastUtils.zzh(this.zzh, adBreakClipInfo.zzh) && CastUtils.zzh(this.zzi, adBreakClipInfo.zzi) && this.zzj == adBreakClipInfo.zzj && CastUtils.zzh(this.zzk, adBreakClipInfo.zzk) && CastUtils.zzh((Object)this.zzl, (Object)adBreakClipInfo.zzl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            String string2;
            jSONObject.put("id", (Object)this.zza);
            jSONObject.put("duration", CastUtils.millisecToSec(this.zzc));
            long l = this.zzj;
            if (l != -1L) {
                string2 = "whenSkippable";
                jSONObject.put(string2, CastUtils.millisecToSec(l));
            }
            if ((string2 = this.zzh) != null) {
                string = "contentId";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zze) != null) {
                string = "contentType";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzb) != null) {
                string = "title";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzd) != null) {
                string = "contentUrl";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzf) != null) {
                string = "clickThroughUrl";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzm) != null) {
                string = "customData";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzi) != null) {
                string = "posterUrl";
                jSONObject.put(string, (Object)string2);
            }
            if ((string2 = this.zzk) != null) {
                string = "hlsSegmentFormat";
                jSONObject.put(string, (Object)string2);
            }
            if ((this = this.zzl) == null) return jSONObject;
            string2 = "vastAdsRequest";
            jSONObject.put(string2, (Object)this.zza());
            return jSONObject;
        }
        catch (JSONException jSONException) {
            return jSONObject;
        }
    }

    public static class Builder {
        private final String zza;
        private String zzb;
        private long zzc;
        private String zzd;
        private String zze;
        private String zzf;
        private String zzg;
        private String zzh;
        private String zzi;
        private long zzj = -1L;
        @HlsSegmentFormat
        private String zzk;
        private VastAdsRequest zzl;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setClickThroughUrl(@NonNull String clickThroughUrl) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentId(@NonNull String contentId) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setContentUrl(@NonNull String contentUrl) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCustomDataJsonString(@NonNull String customDataJsonString) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDurationInMs(long durationInMs) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHlsSegmentFormat(@NonNull String hlsSegmentFormat) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setImageUrl(@NonNull String imageUrl) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setMimeType(@NonNull String mimeType) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTitle(@NonNull String title) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setVastAdsRequest(@NonNull VastAdsRequest vastAdsRequest) {
            void var1_1;
            this.zzl = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setWhenSkippableInMs(long whenSkippableInMs) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        @NonNull
        public AdBreakClipInfo build() {
            AdBreakClipInfo adBreakClipInfo = new AdBreakClipInfo(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, this.zzl);
            return adBreakClipInfo;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String id) {
            void var1_1;
            this.zza = var1_1;
        }
    }
}

