/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.runtime.Destination;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.zzax;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzae;
import com.google.android.gms.internal.cast.zzbm;
import com.google.android.gms.internal.cast.zzd;
import com.google.android.gms.internal.cast.zze;
import com.google.android.gms.internal.cast.zzi;
import com.google.android.gms.internal.cast.zzj;
import com.google.android.gms.internal.cast.zzk;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzmp;
import com.google.android.gms.internal.cast.zzmq;
import com.google.android.gms.internal.cast.zzp;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnSuccessListener;
import java.util.Locale;
import java.util.UUID;
import org.checkerframework.dataflow.qual.Pure;

@MainThread
@ShowFirstParty
public final class zzf {
    private final Context zzb;
    private final zzn zzc;
    private final SessionManager zzd;
    @Nullable
    private final zzbm zze;
    private final zzae zzf;
    private final String zzg;
    @VisibleForTesting
    @Nullable
    Transport zza;
    private int zzh;

    public static zzf zza(Context context, zzn zzn2, SessionManager sessionManager, @Nullable zzbm zzbm2, zzae zzae2) {
        return new zzf(context, zzn2, sessionManager, zzbm2, zzae2);
    }

    private zzf(Context context, zzn zzn2, SessionManager sessionManager, @Nullable zzbm zzbm2, zzae zzae2) {
        this.zzb = context;
        this.zzc = zzn2;
        this.zzd = sessionManager;
        this.zze = zzbm2;
        this.zzf = zzae2;
        this.zzh = 1;
        this.zzg = UUID.randomUUID().toString();
    }

    final /* synthetic */ void zzb(String string2, SharedPreferences sharedPreferences, Bundle bundle) {
        Preconditions.checkNotNull((Object)this.zzd);
        zzbm zzbm2 = this.zze;
        zzk zzk2 = new zzk(sharedPreferences, this, bundle, string2);
        this.zzf.zze(zzk2.zzc());
        this.zzd.addSessionManagerListener(new zzi(zzk2), CastSession.class);
        if (zzbm2 != null) {
            zzbm2.zzm(new zzj(zzk2));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzc(Bundle bundle) {
        Bundle bundle2 = bundle;
        boolean bl = bundle2.getBoolean("com.google.android.gms.cast.FLAG_CLIENT_SESSION_ANALYTICS_ENABLED");
        boolean bl2 = bundle2.getBoolean("com.google.android.gms.cast.FLAG_CLIENT_FEATURE_USAGE_ANALYTICS_ENABLED");
        if (!bl && !bl2) {
            return;
        }
        String string2 = this.zzb.getPackageName();
        Object[] objectArray = new Object[]{string2, "client_cast_analytics_data"};
        String string3 = String.format(Locale.ROOT, "%s.%s", objectArray);
        int n = bundle.getLong("com.google.android.gms.cast.FLAG_FIRELOG_UPLOAD_MODE") == 0L ? 1 : 2;
        this.zzh = n;
        TransportRuntime.initialize((Context)this.zzb);
        String string4 = "proto";
        this.zza = TransportRuntime.getInstance().newFactory((Destination)CCTDestination.INSTANCE).getTransport("CAST_SENDER_SDK", zzmq.class, Encoding.of((String)string4), (Transformer)com.google.android.gms.internal.cast.zze.zza);
        string4 = this.zzb.getApplicationContext().getSharedPreferences(string3, 0);
        if (bl) {
            zzn zzn2 = this.zzc;
            String[] stringArray = new String[]{"com.google.android.gms.cast.DICTIONARY_CAST_STATUS_CODES_TO_APP_SESSION_ERROR", "com.google.android.gms.cast.DICTIONARY_CAST_STATUS_CODES_TO_APP_SESSION_CHANGE_REASON"};
            zzn2.doRead(TaskApiCall.builder().run((RemoteCall)new com.google.android.gms.cast.internal.zzf(zzn2, stringArray)).setFeatures(new Feature[]{zzax.zzg}).setAutoResolveMissingFeatures(false).setMethodKey(8426).build()).addOnSuccessListener((OnSuccessListener)new zzd(this, string2, (SharedPreferences)string4));
        }
        if (bl2) {
            Preconditions.checkNotNull((Object)string4);
            zzr.zza((SharedPreferences)string4, this, string2).zze();
            zzr.zzd(zzln.zzf);
        }
        zzp.zzg(this, string2);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Pure
    public final void zzd(zzmq zzmq2, int n) {
        zzmp zzmp2 = zzmq.zzd((zzmq)zzmq2);
        zzmp2.zzk(zzf2.zzg);
        zzmp2.zzf(zzf2.zzg);
        zzmq2 = (zzmq)zzmp2.zzp();
        int n2 = zzf2.zzh;
        int n3 = n2 + -1;
        if (n2 == 0) {
            throw null;
        }
        switch (n3) {
            default: {
                zzmq2 = null;
                break;
            }
            case 1: {
                zzmq2 = Event.ofData((int)(n + -1), (Object)zzmq2);
                break;
            }
            case 0: {
                zzmq2 = Event.ofTelemetry((int)(n + -1), (Object)zzmq2);
            }
        }
        Preconditions.checkNotNull((Object)zzmq2);
        zzf zzf2 = zzf2.zza;
        if (zzf2 != null) {
            zzf2.send((Event)zzmq2);
            return;
        }
    }
}

