/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.widget.CastSeekBar;
import com.google.android.gms.internal.cast.zzcq;

public final class zzcw
extends zzcq {
    private final RelativeLayout zza;
    private final TextView zzb;
    private final CastSeekBar zzc;
    private final zza zzd;

    public zzcw(RelativeLayout relativeLayout, CastSeekBar castSeekBar, zza zza2) {
        this.zza = relativeLayout;
        this.zzb = (TextView)relativeLayout.findViewById(R.id.tooltip);
        this.zzc = castSeekBar;
        this.zzd = zza2;
        TypedArray typedArray = this.zzb.getContext().obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarTooltipBackgroundColor, 0);
        typedArray.recycle();
        n = this.zzb.getContext().getResources().getColor(n);
        this.zzb.getBackground().setColorFilter(n, PorterDuff.Mode.SRC_IN);
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzd();
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzd();
    }

    @Override
    public final void onSessionEnded() {
        super.onSessionEnded();
        this.zzd();
    }

    @Override
    public final void zza(boolean bl) {
        super.zza(bl);
        this.zzd();
    }

    @Override
    public final void zzb(long l) {
        this.zzd();
    }

    @VisibleForTesting
    final void zzd() {
        Object object = this.getRemoteMediaClient();
        if (object == null || !((RemoteMediaClient)object).hasMediaSession() || this.zzc()) {
            this.zza.setVisibility(8);
            return;
        }
        this.zza.setVisibility(0);
        object = this.zzd;
        this.zzb.setText((CharSequence)((zza)object).zzl((long)this.zzc.getProgress() + ((zza)object).zze()));
        int n = this.zzc.getMeasuredWidth() - this.zzc.getPaddingLeft() - this.zzc.getPaddingRight();
        int n2 = View.MeasureSpec.makeMeasureSpec((int)n, (int)Integer.MIN_VALUE);
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.zzb.measure(n2, n3);
        n2 = this.zzb.getMeasuredWidth();
        n3 = n2 / 2;
        n = Math.min(Math.max(0, (int)((double)this.zzc.getProgress() / (double)this.zzc.getMaxProgress() * (double)n) - n3), n - n2);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.zzb.getLayoutParams();
        layoutParams.leftMargin = n;
        this.zzb.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

