/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.cast.zzbv;

public final class zzbw
extends UIController {
    private final ImageView zza;
    private final ImageHints zzb;
    private final Bitmap zzc;
    @Nullable
    private final ImagePicker zzd;
    private final zzb zze;

    static /* bridge */ /* synthetic */ ImageView zza(zzbw zzbw2) {
        return zzbw2.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    public zzbw(ImageView object, Context context, @NonNull ImageHints imageHints, int n) {
        zzb zzb2 = new zzb(context.getApplicationContext());
        this.zza = object;
        this.zzb = imageHints;
        this.zzc = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        object = CastContext.zza(context);
        if (object != null) {
            object = (object = ((CastContext)object).getCastOptions().getCastMediaOptions()) != null ? ((CastMediaOptions)((Object)object)).getImagePicker() : null;
            this.zzd = object;
        } else {
            this.zzd = null;
        }
        this.zze = zzb2;
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzb();
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zze.zzc(new zzbv(this));
        this.zza.setImageBitmap(this.zzc);
        this.zzb();
    }

    @Override
    public final void onSessionEnded() {
        this.zze.zza();
        this.zza.setImageBitmap(this.zzc);
        super.onSessionEnded();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzb() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zza.setImageBitmap(this.zzc);
            return;
        }
        if ((remoteMediaClient = remoteMediaClient.getPreloadedItem()) == null) {
            remoteMediaClient = null;
        } else if ((remoteMediaClient = remoteMediaClient.getMedia()) == null) {
            remoteMediaClient = null;
        } else {
            MediaMetadata mediaMetadata = remoteMediaClient.getMetadata();
            ImagePicker imagePicker = this.zzd;
            remoteMediaClient = imagePicker != null && mediaMetadata != null && (mediaMetadata = imagePicker.onPickImage(mediaMetadata, this.zzb)) != null && mediaMetadata.getUrl() != null ? mediaMetadata.getUrl() : MediaUtils.getImageUri((MediaInfo)remoteMediaClient, 0);
        }
        if (remoteMediaClient == null) {
            this.zza.setImageBitmap(this.zzc);
            return;
        }
        this.zze.zzd((Uri)remoteMediaClient);
    }
}

