/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.SessionState;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionTransferCallback;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzbg;
import com.google.android.gms.internal.cast.zzbh;
import com.google.android.gms.internal.cast.zzbi;
import com.google.android.gms.internal.cast.zzbj;
import com.google.android.gms.internal.cast.zzbl;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.internal.cast.zzln;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@TargetApi(value=30)
public final class zzbm {
    private static final Logger zza = new Logger("SessionTransController");
    private final CastOptions zzb;
    private final Set zzc = Collections.synchronizedSet(new HashSet());
    private final Handler zzd;
    private final Runnable zze;
    private int zzf;
    private SessionManager zzg;
    @Nullable
    private CallbackToFutureAdapter.Completer zzh;
    @Nullable
    private SessionState zzi;

    static /* bridge */ /* synthetic */ int zza(zzbm zzbm2) {
        return zzbm2.zzf;
    }

    static /* bridge */ /* synthetic */ CastOptions zzb(zzbm zzbm2) {
        return zzbm2.zzb;
    }

    @Nullable
    private final RemoteMediaClient zzo() {
        Object object = object.zzg;
        if (object == null) {
            object = new Object[]{};
            zza.d("skip transferring as SessionManager is null", object);
            return null;
        }
        if ((object = object.getCurrentCastSession()) == null) {
            object = new Object[]{};
            zza.d("skip transferring as CastSession is null", object);
            return null;
        }
        return object.getRemoteMediaClient();
    }

    static /* bridge */ /* synthetic */ Logger zzc() {
        return zza;
    }

    public static /* synthetic */ void zzd(zzbm zzbm2, SessionState sessionState) {
        zzbm2.zzi = sessionState;
        zzbm2 = zzbm2.zzh;
        if (zzbm2 != null) {
            zzbm2.set(null);
            return;
        }
    }

    public static /* synthetic */ void zze(zzbm zzbm2) {
        Object[] objectArray = new Object[]{zzbm2.zzf};
        zza.i("transfer with type = %d has timed out", objectArray);
        zzbm2.zzp(101);
    }

    public static /* synthetic */ void zzf(zzbm zzbm2) {
        zzbl zzbl2 = new zzbl(zzbm2, null);
        ((SessionManager)Preconditions.checkNotNull((Object)zzbm2.zzg)).addSessionManagerListener(zzbl2, CastSession.class);
    }

    static /* bridge */ /* synthetic */ void zzg(zzbm objectArray) {
        int n = objectArray.zzf;
        if (n == 0) {
            objectArray = new Object[]{};
            zza.d("No need to notify transferred if the transfer type is unknown", objectArray);
            return;
        }
        SessionState sessionState = objectArray.zzi;
        if (sessionState == null) {
            objectArray = new Object[]{};
            zza.d("No need to notify with null sessionState", objectArray);
            return;
        }
        Object[] objectArray2 = new Object[]{n, objectArray.zzi};
        zza.d("notify transferred with type = %d, sessionState = %s", objectArray2);
        Iterator iterator = new HashSet(objectArray.zzc).iterator();
        while (iterator.hasNext()) {
            ((SessionTransferCallback)iterator.next()).onTransferred(objectArray.zzf, sessionState);
        }
    }

    static /* bridge */ /* synthetic */ void zzh(zzbm zzbm2) {
        zzbm2.zzq();
    }

    static /* bridge */ /* synthetic */ void zzi(zzbm objectArray) {
        if (objectArray.zzi == null) {
            objectArray = new Object[]{};
            zza.d("skip restoring session state due to null SessionState", objectArray);
            return;
        }
        RemoteMediaClient remoteMediaClient = objectArray.zzo();
        if (remoteMediaClient == null) {
            objectArray = new Object[]{};
            zza.d("skip restoring session state due to null RemoteMediaClient", objectArray);
            return;
        }
        Object[] objectArray2 = new Object[]{};
        zza.d("resume SessionState to current session", objectArray2);
        remoteMediaClient.zzq(objectArray.zzi);
    }

    public zzbm(CastOptions castOptions) {
        this.zzb = castOptions;
        this.zzf = 0;
        this.zzd = new zzdy(Looper.getMainLooper());
        this.zze = new zzbh(this);
    }

    public final void zzj(SessionManager sessionManager) {
        this.zzg = sessionManager;
        ((Handler)Preconditions.checkNotNull((Object)this.zzd)).post((Runnable)new zzbg(this));
    }

    private final void zzp(int n) {
        Object object = this.zzh;
        if (object != null) {
            object.setCancelled();
        }
        object = new Object[]{this.zzf, n};
        zza.d("notify failed transfer with type = %d, reason = %d", (Object[])object);
        object = new HashSet(this.zzc).iterator();
        while (object.hasNext()) {
            ((SessionTransferCallback)object.next()).onTransferFailed(this.zzf, n);
        }
        this.zzq();
    }

    final /* synthetic */ void zzk(Exception exception) {
        zza.w((Throwable)exception, "Fail to store SessionState", new Object[0]);
        this.zzp(100);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzl(MediaRouter.RouteInfo objectArray, MediaRouter.RouteInfo objectArray2, CallbackToFutureAdapter.Completer completer) {
        int n;
        Object[] objectArray3;
        if (new HashSet(objectArray3.zzc).isEmpty()) {
            objectArray3 = new Object[]{};
            zza.d("No need to prepare transfer without any callback", objectArray3);
            completer.set(null);
            return;
        }
        if (objectArray.getPlaybackType() != 1) {
            objectArray3 = new Object[]{};
            zza.d("No need to prepare transfer when transferring from local", objectArray3);
            completer.set(null);
            return;
        }
        RemoteMediaClient remoteMediaClient = super.zzo();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            objectArray3 = new Object[]{};
            zza.d("No need to prepare transfer when there is no media session", objectArray3);
            completer.set(null);
            return;
        }
        objectArray = new Object[]{};
        zza.d("Prepare route transfer for changing endpoint", objectArray);
        if (objectArray2.getPlaybackType() == 0) {
            zzr.zzd(zzln.zzP);
            n = 1;
        } else {
            n = CastDevice.getFromBundle((Bundle)objectArray2.getExtras()) == null ? 3 : 2;
        }
        objectArray3.zzf = n;
        objectArray3.zzh = completer;
        objectArray2 = new Object[]{n};
        zza.d("notify transferring with type = %d", objectArray2);
        Iterator iterator = new HashSet(objectArray3.zzc).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                objectArray3.zzi = null;
                remoteMediaClient.zzk(null).addOnSuccessListener((OnSuccessListener)new zzbi((zzbm)objectArray3)).addOnFailureListener((OnFailureListener)new zzbj((zzbm)objectArray3));
                ((Handler)Preconditions.checkNotNull((Object)objectArray3.zzd)).postDelayed((Runnable)Preconditions.checkNotNull((Object)objectArray3.zze), 10000L);
                return;
            }
            ((SessionTransferCallback)iterator.next()).onTransferring(objectArray3.zzf);
        }
    }

    public final void zzm(SessionTransferCallback sessionTransferCallback) {
        Object[] objectArray = new Object[]{sessionTransferCallback};
        zza.d("register callback = %s", objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)sessionTransferCallback);
        this.zzc.add(sessionTransferCallback);
    }

    private final void zzq() {
        ((Handler)Preconditions.checkNotNull((Object)this.zzd)).removeCallbacks((Runnable)Preconditions.checkNotNull((Object)this.zze));
        this.zzf = 0;
        this.zzi = null;
    }

    public final void zzn(SessionTransferCallback sessionTransferCallback) {
        Object[] objectArray = new Object[]{sessionTransferCallback};
        zza.d("unregister callback = %s", objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (sessionTransferCallback != null) {
            this.zzc.remove(sessionTransferCallback);
            return;
        }
    }
}

