/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.os.Looper;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzat;
import com.google.android.gms.internal.cast.zzau;
import com.google.android.gms.internal.cast.zzav;
import com.google.android.gms.internal.cast.zzaw;
import com.google.android.gms.internal.cast.zzax;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.internal.cast.zzen;
import com.google.android.gms.internal.cast.zzfk;
import com.google.android.gms.internal.cast.zzfl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzay
extends MediaRouter.Callback {
    private static final Logger zzb = new Logger("MRDiscoveryCallback");
    public final zzaw zza;
    private final Set zzc;
    private final Map zzd;
    private final LinkedHashSet zze;
    private final zzax zzf;

    public zzay(Context context) {
        this.zzf = new zzax(context);
        this.zzd = Collections.synchronizedMap(new HashMap());
        this.zze = new LinkedHashSet();
        this.zzc = Collections.synchronizedSet(new LinkedHashSet());
        this.zza = new zzaw(this);
    }

    public final void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        zzb.d("MediaRouterDiscoveryCallback.onRouteAdded.", new Object[0]);
        this.zzf(routeInfo, true);
    }

    public final void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        zzb.d("MediaRouterDiscoveryCallback.onRouteChanged.", new Object[0]);
        this.zzf(routeInfo, true);
    }

    public final void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
        zzb.d("MediaRouterDiscoveryCallback.onRouteRemoved.", new Object[0]);
        this.zzf(routeInfo, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza(List object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SetRouteDiscovery for ");
        stringBuilder.append(object.size());
        stringBuilder.append(" IDs");
        zzb.d(stringBuilder.toString(), new Object[0]);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        object = object.iterator();
        while (object.hasNext()) {
            linkedHashSet.add(zzen.zza((String)((String)object.next())));
        }
        object = String.valueOf(String.valueOf(this.zzd.keySet()));
        zzb.d("resetting routes. appIdToRouteInfo has these appId route keys: ".concat((String)object), new Object[0]);
        object = new HashMap();
        Object[] objectArray = this.zzd;
        synchronized (objectArray) {
            boolean bl;
            Iterator iterator = linkedHashSet.iterator();
            while (bl = iterator.hasNext()) {
                String string2 = (String)iterator.next();
                zzav zzav2 = (zzav)this.zzd.get(zzen.zza((String)string2));
                if (zzav2 == null) continue;
                ((HashMap)object).put(string2, zzav2);
            }
            this.zzd.clear();
            this.zzd.putAll(object);
        }
        object = String.valueOf(String.valueOf(this.zzd.keySet()));
        objectArray = new Object[]{};
        zzb.d("Routes reset. appIdToRouteInfo has these appId route keys: ".concat((String)object), objectArray);
        object = this.zze;
        synchronized (object) {
            this.zze.clear();
            this.zze.addAll(linkedHashSet);
            // MONITOREXIT @DISABLED, blocks:[1, 5] lbl40 : MonitorExitStatement: MONITOREXIT : var1_2
            this.zzb();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    final void zzb() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Starting RouteDiscovery with ");
        stringBuilder.append(this.zze.size());
        stringBuilder.append(" IDs");
        zzb.d(stringBuilder.toString(), new Object[0]);
        String string2 = String.valueOf(String.valueOf(this.zzd.keySet()));
        zzb.d("appIdToRouteInfo has these appId route keys: ".concat(string2), new Object[0]);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzc();
            return;
        }
        new zzdy(Looper.getMainLooper()).post((Runnable)new zzau(this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void zzc() {
        object.zzf.zzb((MediaRouter.Callback)object);
        Object[] objectArray = object.zze;
        synchronized (objectArray) {
            boolean bl;
            Iterator iterator = object.zze.iterator();
            while (bl = iterator.hasNext()) {
                Object object = (String)iterator.next();
                MediaRouteSelector mediaRouteSelector = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast((String)object)).build();
                zzav zzav2 = (zzav)object.zzd.get(object);
                if (zzav2 == null) {
                    object.zzd.put(object, new zzav(mediaRouteSelector));
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Adding mediaRouter callback for control category ");
                stringBuilder.append(CastMediaControlIntent.categoryForCast((String)object));
                zzb.d(stringBuilder.toString(), new Object[0]);
                object = object.zzf;
                ((zzax)object).zza().addCallback(mediaRouteSelector, (MediaRouter.Callback)object, 4);
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        Object object = String.valueOf(String.valueOf(object.zzd.keySet()));
        objectArray = new Object[]{};
        zzb.d("appIdToRouteInfo has these appId route keys: ".concat((String)object), objectArray);
    }

    public final void zzd() {
        zzb.d("Stopping RouteDiscovery.", new Object[0]);
        this.zzd.clear();
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.zzf.zzb(this);
            return;
        }
        new zzdy(Looper.getMainLooper()).post((Runnable)new zzat(this));
    }

    final void zze() {
        this.zzf.zzb(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public final void zzf(MediaRouter.RouteInfo object, boolean bl) {
        boolean bl2;
        Iterator iterator;
        Object[] objectArray = new Object[]{bl, object};
        zzb.d("MediaRouterDiscoveryCallback.updateRouteToAppIds (add=%b) route %s", objectArray);
        Map map = ((zzay)((Object)iterator2)).zzd;
        synchronized (map) {
            boolean bl3;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("appIdToRouteInfo has these appId route keys: ");
            stringBuilder.append(String.valueOf(((zzay)((Object)iterator2)).zzd.keySet()));
            zzb.d(stringBuilder.toString(), new Object[0]);
            iterator = ((zzay)((Object)iterator2)).zzd.entrySet().iterator();
            bl2 = false;
            while (bl3 = iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                zzav zzav2 = (zzav)entry.getValue();
                boolean bl4 = object.matchesSelector(zzav2.zzb);
                if (!bl4) continue;
                if (bl) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append("Adding/updating route for appId ");
                    stringBuilder2.append(string2);
                    zzb.d(stringBuilder2.toString(), new Object[0]);
                    bl2 = zzav2.zza.add(object);
                    if (bl2) continue;
                    StringBuilder stringBuilder3 = new StringBuilder();
                    stringBuilder3.append("Route ");
                    stringBuilder3.append(String.valueOf(object));
                    stringBuilder3.append(" already exists for appId ");
                    stringBuilder3.append(string2);
                    zzb.w(stringBuilder3.toString(), new Object[0]);
                    continue;
                }
                StringBuilder stringBuilder4 = new StringBuilder();
                stringBuilder4.append("Removing route for appId ");
                stringBuilder4.append(string2);
                zzb.d(stringBuilder4.toString(), new Object[0]);
                bl2 = zzav2.zza.remove(object);
                if (bl2) continue;
                StringBuilder stringBuilder5 = new StringBuilder();
                stringBuilder5.append("Route ");
                stringBuilder5.append(String.valueOf(object));
                stringBuilder5.append(" already removed from appId ");
                stringBuilder5.append(string2);
                zzb.w(stringBuilder5.toString(), new Object[0]);
            }
        }
        if (!bl2) return;
        zzb.d("Invoking callback.onRouteUpdated.", new Object[0]);
        Set set = ((zzay)((Object)iterator2)).zzc;
        synchronized (set) {
            boolean bl5;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            map = ((zzay)((Object)iterator2)).zzd;
            synchronized (map) {
                iterator = ((zzay)((Object)iterator2)).zzd.keySet().iterator();
                while (bl5 = iterator.hasNext()) {
                    String string3 = (String)((Object)iterator.next());
                    object = (zzav)((zzay)((Object)iterator2)).zzd.get(zzen.zza((String)string3));
                    object = object == null ? zzfl.zzk() : zzfl.zzj((Collection)((zzav)object).zza);
                    boolean bl6 = object.isEmpty();
                    if (bl6) continue;
                    hashMap.put(string3, object);
                }
            }
            zzfk.zzc(hashMap.entrySet());
            Iterator iterator2 = ((zzay)((Object)iterator2)).zzc.iterator();
            while (bl5 = iterator2.hasNext()) {
                ((com.google.android.gms.cast.framework.zzaw)iterator2.next()).zza();
            }
            return;
        }
    }
}

