/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.text.format.DateUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import java.text.DateFormat;
import java.util.Date;

@ShowFirstParty
public final class zza {
    @Nullable
    @VisibleForTesting
    RemoteMediaClient zza;

    public final int zza() {
        RemoteMediaClient remoteMediaClient = this.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return 0;
        }
        remoteMediaClient = this.zza;
        if (remoteMediaClient.isLiveStream() || !remoteMediaClient.isLoadingNextItem()) {
            long l = remoteMediaClient.getApproximateStreamPosition() - this.zze();
            int n = (int)l;
            if (remoteMediaClient.zzv()) {
                int n2 = this.zzc();
                n = Math.min(Math.max(n, this.zzd()), n2);
            }
            int n3 = this.zzb();
            return Math.min(Math.max(n, 0), n3);
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int zzb() {
        long l;
        RemoteMediaClient remoteMediaClient = this.zza;
        if (remoteMediaClient != null) {
            if (!remoteMediaClient.hasMediaSession()) {
                l = 1L;
                return Math.max((int)(l - this.zze()), 1);
            }
            remoteMediaClient = this.zza;
            if (!remoteMediaClient.isLiveStream()) {
                if (remoteMediaClient.isLoadingNextItem()) {
                    if ((remoteMediaClient = remoteMediaClient.getLoadingItem()) != null) {
                        if ((remoteMediaClient = remoteMediaClient.getMedia()) != null) {
                            l = Math.max(remoteMediaClient.getStreamDuration(), 1L);
                            return Math.max((int)(l - this.zze()), 1);
                        }
                        l = 1L;
                        return Math.max((int)(l - this.zze()), 1);
                    }
                    l = 1L;
                    return Math.max((int)(l - this.zze()), 1);
                }
                l = Math.max(remoteMediaClient.getStreamDuration(), 1L);
                return Math.max((int)(l - this.zze()), 1);
            }
            Long l2 = this.zzi();
            if (l2 != null) {
                l = l2;
                return Math.max((int)(l - this.zze()), 1);
            }
            l2 = this.zzg();
            if (l2 != null) {
                l = l2;
                return Math.max((int)(l - this.zze()), 1);
            }
            l = Math.max(remoteMediaClient.getApproximateStreamPosition(), 1L);
            return Math.max((int)(l - this.zze()), 1);
        }
        l = 1L;
        return Math.max((int)(l - this.zze()), 1);
    }

    public final int zzc() {
        RemoteMediaClient remoteMediaClient = this.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !this.zza.isLiveStream()) {
            return this.zzb();
        }
        if (!this.zza.zzv()) {
            return 0;
        }
        int n = this.zzb();
        return Math.min(Math.max((int)((Long)Preconditions.checkNotNull((Object)this.zzg()) - this.zze()), 0), n);
    }

    public final int zzd() {
        RemoteMediaClient remoteMediaClient = this.zza;
        if (!(remoteMediaClient != null && remoteMediaClient.hasMediaSession() && this.zza.isLiveStream() && this.zza.zzv())) {
            return 0;
        }
        int n = this.zzb();
        return Math.min(Math.max((int)((Long)Preconditions.checkNotNull((Object)this.zzh()) - this.zze()), 0), n);
    }

    @VisibleForTesting
    public final long zze() {
        RemoteMediaClient remoteMediaClient = ((zza)this).zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !((zza)this).zza.isLiveStream()) {
            return 0L;
        }
        remoteMediaClient = ((zza)this).zza;
        Long l = ((zza)this).zzj();
        if (l != null) {
            return l;
        }
        if ((this = ((zza)this).zzh()) != null) {
            return (Long)this;
        }
        return remoteMediaClient.getApproximateStreamPosition();
    }

    @Nullable
    private final MediaMetadata zzo() {
        RemoteMediaClient remoteMediaClient = zza2.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return null;
        }
        zza zza2 = zza2.zza.getMediaInfo();
        if (zza2 == null) {
            return null;
        }
        return zza2.getMetadata();
    }

    @VisibleForTesting(otherwise=3)
    public static zza zzf() {
        return new zza();
    }

    @VisibleForTesting
    @Nullable
    final Long zzg() {
        RemoteMediaClient remoteMediaClient = ((zza)((Object)remoteMediaClient2)).zza;
        if (!(remoteMediaClient != null && remoteMediaClient.hasMediaSession() && ((zza)((Object)remoteMediaClient2)).zza.isLiveStream() && ((zza)((Object)remoteMediaClient2)).zza.zzv())) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = ((zza)((Object)remoteMediaClient2)).zza;
        remoteMediaClient = remoteMediaClient2.getMediaStatus();
        if (remoteMediaClient != null && remoteMediaClient.getLiveSeekableRange() != null) {
            return remoteMediaClient2.getApproximateLiveSeekableRangeEnd();
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    final Long zzh() {
        RemoteMediaClient remoteMediaClient = ((zza)((Object)remoteMediaClient2)).zza;
        if (!(remoteMediaClient != null && remoteMediaClient.hasMediaSession() && ((zza)((Object)remoteMediaClient2)).zza.isLiveStream() && ((zza)((Object)remoteMediaClient2)).zza.zzv())) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = ((zza)((Object)remoteMediaClient2)).zza;
        remoteMediaClient = remoteMediaClient2.getMediaStatus();
        if (remoteMediaClient != null && remoteMediaClient.getLiveSeekableRange() != null) {
            return remoteMediaClient2.getApproximateLiveSeekableRangeStart();
        }
        return null;
    }

    @Nullable
    public final Long zzi() {
        RemoteMediaClient remoteMediaClient = ((zza)this).zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !((zza)this).zza.isLiveStream()) {
            return null;
        }
        remoteMediaClient = ((zza)this).zzo();
        if (remoteMediaClient != null && remoteMediaClient.containsKey("com.google.android.gms.cast.metadata.SECTION_DURATION") && (this = ((zza)this).zzj()) != null) {
            return (Long)this + remoteMediaClient.getTimeMillis("com.google.android.gms.cast.metadata.SECTION_DURATION");
        }
        return null;
    }

    @Nullable
    public final Long zzj() {
        RemoteMediaClient remoteMediaClient = zza2.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !zza2.zza.isLiveStream()) {
            return null;
        }
        remoteMediaClient = zza2.zza;
        zza zza2 = zza2.zzo();
        if (remoteMediaClient.getMediaInfo() != null && zza2 != null && zza2.containsKey("com.google.android.gms.cast.metadata.SECTION_START_TIME_IN_MEDIA") && (zza2.containsKey("com.google.android.gms.cast.metadata.SECTION_DURATION") || remoteMediaClient.zzv())) {
            return zza2.getTimeMillis("com.google.android.gms.cast.metadata.SECTION_START_TIME_IN_MEDIA");
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    final Long zzk() {
        RemoteMediaClient remoteMediaClient = zza2.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !zza2.zza.isLiveStream()) {
            return null;
        }
        zza zza2 = zza2.zza.getMediaInfo();
        if (zza2 != null && zza2.getStartAbsoluteTime() != -1L) {
            return zza2.getStartAbsoluteTime();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final String zzl(long l) {
        RemoteMediaClient remoteMediaClient = this.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = this.zza;
        int n = remoteMediaClient2 != null ? (!remoteMediaClient2.hasMediaSession() ? 1 : (this.zza.isLiveStream() ? (this.zzk() != null ? 2 : 1) : 1)) : 1;
        switch (n + -1) {
            default: {
                if (remoteMediaClient2.isLiveStream() && this.zzj() == null) {
                    return com.google.android.gms.cast.framework.media.uicontroller.zza.zzp(l);
                }
                return com.google.android.gms.cast.framework.media.uicontroller.zza.zzp(l - this.zze());
            }
            case 1: 
        }
        l = (Long)Preconditions.checkNotNull((Object)this.zzk()) + l;
        return DateFormat.getTimeInstance().format(new Date(l));
    }

    private zza() {
    }

    public final boolean zzm() {
        zza zza2 = this;
        return zza2.zzn((long)zza2.zza() + this.zze());
    }

    public final boolean zzn(long l) {
        RemoteMediaClient remoteMediaClient = this.zza;
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return false;
        }
        if (!this.zza.zzv()) {
            return false;
        }
        return (long)this.zzc() + this.zze() - l < 10000L;
    }

    private static final String zzp(long l) {
        if (l >= 0L) {
            return DateUtils.formatElapsedTime((long)(l / 1000L));
        }
        String string2 = String.valueOf(DateUtils.formatElapsedTime((long)(-l / 1000L)));
        return "-".concat(string2);
    }
}

