/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaError;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaLoadRequestData;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaSeekOptions;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.SessionState;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.MediaQueue;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzap;
import com.google.android.gms.cast.framework.media.zzaq;
import com.google.android.gms.cast.framework.media.zzar;
import com.google.android.gms.cast.framework.media.zzas;
import com.google.android.gms.cast.framework.media.zzat;
import com.google.android.gms.cast.framework.media.zzau;
import com.google.android.gms.cast.framework.media.zzav;
import com.google.android.gms.cast.framework.media.zzaw;
import com.google.android.gms.cast.framework.media.zzax;
import com.google.android.gms.cast.framework.media.zzay;
import com.google.android.gms.cast.framework.media.zzaz;
import com.google.android.gms.cast.framework.media.zzba;
import com.google.android.gms.cast.framework.media.zzbb;
import com.google.android.gms.cast.framework.media.zzbc;
import com.google.android.gms.cast.framework.media.zzbd;
import com.google.android.gms.cast.framework.media.zzbf;
import com.google.android.gms.cast.framework.media.zzbg;
import com.google.android.gms.cast.framework.media.zzbh;
import com.google.android.gms.cast.framework.media.zzbj;
import com.google.android.gms.cast.framework.media.zzbk;
import com.google.android.gms.cast.framework.media.zzbn;
import com.google.android.gms.cast.framework.media.zzbp;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.zzr;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzdy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    @NonNull
    public static final String NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;
    private static final Logger zzb;
    private final Object zzc;
    private final Handler zzd;
    private final com.google.android.gms.cast.internal.zzaq zze;
    private final zzbf zzf;
    @NotOnlyInitialized
    private final MediaQueue zzg;
    @Nullable
    private zzr zzh;
    private TaskCompletionSource zzi;
    private final List zzj = new CopyOnWriteArrayList();
    @VisibleForTesting
    final List zza = new CopyOnWriteArrayList();
    private final Map zzk = new ConcurrentHashMap();
    private final Map zzl = new ConcurrentHashMap();
    private ParseAdsInfoCallback zzm;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIdleReason() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            RemoteMediaClient this_ = this_.getMediaStatus();
            if (this_ == null) return 0;
            return this_.getIdleReason();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerState() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            RemoteMediaClient this_ = this_.getMediaStatus();
            if (this_ == null) return 1;
            return this_.getPlayerState();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateAdBreakClipPositionMs() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzj();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateLiveSeekableRangeEnd() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzk();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateLiveSeekableRangeStart() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzl();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzm();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStreamDuration() {
        Object object = this.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this.zze.zzo();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MediaInfo getMediaInfo() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this_.zze.zzK();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Nullable
    public MediaQueueItem getCurrentItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = remoteMediaClient;
        return remoteMediaClient2.getQueueItemById(remoteMediaClient2.getCurrentItemId());
    }

    @Nullable
    public MediaQueueItem getLoadingItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = remoteMediaClient;
        return remoteMediaClient2.getQueueItemById(remoteMediaClient2.getLoadingItemId());
    }

    @Nullable
    public MediaQueueItem getPreloadedItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        if (remoteMediaClient == null) {
            return null;
        }
        RemoteMediaClient remoteMediaClient2 = remoteMediaClient;
        return remoteMediaClient2.getQueueItemById(remoteMediaClient2.getPreloadedItemId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public MediaStatus getMediaStatus() {
        Object object = this_.zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return this_.zze.zzL();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public MediaQueue getMediaQueue() {
        Object object = ((RemoteMediaClient)this_).zzc;
        synchronized (object) {
            Preconditions.checkMainThread((String)"Must be called from the main thread.");
            return ((RemoteMediaClient)this_).zzg;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo) {
        void var1_1;
        return this.load((MediaInfo)var1_1, new MediaLoadOptions.Builder().build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaLoadRequestData loadRequestData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzav zzav2 = new zzav(this, (MediaLoadRequestData)var1_1);
        RemoteMediaClient.zzy(zzav2);
        return zzav2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, @NonNull MediaLoadOptions mediaLoadOptions) {
        void var2_2;
        void var1_1;
        MediaLoadRequestData.Builder builder = new MediaLoadRequestData.Builder();
        builder.setMediaInfo((MediaInfo)var1_1);
        builder.setAutoplay(Boolean.valueOf(var2_2.getAutoplay()));
        builder.setCurrentTime(var2_2.getPlayPosition());
        builder.setPlaybackRate(var2_2.getPlaybackRate());
        builder.setActiveTrackIds(var2_2.getActiveTrackIds());
        builder.setCustomData(var2_2.getCustomData());
        builder.setCredentials(var2_2.getCredentials());
        builder.setCredentialsType(var2_2.getCredentialsType());
        return this.load(builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay) {
        void var1_1;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        void var1_1;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition, @Nullable JSONObject customData) {
        void var1_1;
        void var5_4;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        builder.setCustomData((JSONObject)var5_4);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> load(@NonNull MediaInfo mediaInfo, boolean autoplay, long playPosition, @NonNull long[] activeTrackIds, @Nullable JSONObject customData) {
        void var1_1;
        void var6_5;
        void var5_4;
        void var3_3;
        void var2_2;
        MediaLoadOptions.Builder builder = new MediaLoadOptions.Builder();
        builder.setAutoplay((boolean)var2_2);
        builder.setPlayPosition((long)var3_3);
        builder.setActiveTrackIds((long[])var5_4);
        builder.setCustomData((JSONObject)var6_5);
        return this.load((MediaInfo)var1_1, builder.build());
    }

    @NonNull
    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> pause(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzax zzax2 = new zzax(this, (JSONObject)var1_1);
        RemoteMediaClient.zzy(zzax2);
        return zzax2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> play(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzaz zzaz2 = new zzaz(this, (JSONObject)var1_1);
        RemoteMediaClient.zzy(zzaz2);
        return zzaz2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueAppendItem(@NonNull MediaQueueItem item, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        return this.queueInsertItems(new MediaQueueItem[]{var1_1}, 0, (JSONObject)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(@NonNull MediaQueueItem item, int insertBeforeItemId, @Nullable JSONObject customData) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.queueInsertAndPlayItem((MediaQueueItem)var1_1, (int)var2_2, -1L, (JSONObject)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(@NonNull MediaQueueItem item, int insertBeforeItemId, long playPosition, @Nullable JSONObject customData) {
        void var5_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzah zzah2 = new zzah(this, (MediaQueueItem)var1_1, (int)var2_2, (long)var3_3, (JSONObject)var5_4);
        RemoteMediaClient.zzy(zzah2);
        return zzah2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueInsertItems(@NonNull MediaQueueItem[] itemsToInsert, int insertBeforeItemId, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzag zzag2 = new zzag(this, (MediaQueueItem[])var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzy(zzag2);
        return zzag2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueJumpToItem(int itemId, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        return this.queueJumpToItem((int)var1_1, -1L, (JSONObject)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueJumpToItem(int itemId, long playPosition, @Nullable JSONObject customData) {
        void var4_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzaq zzaq2 = new zzaq(this, (int)var1_1, (long)var2_2, (JSONObject)var4_3);
        RemoteMediaClient.zzy(zzaq2);
        return zzaq2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueLoad(@NonNull MediaQueueItem[] items, int startIndex, int repeatMode, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.queueLoad((MediaQueueItem[])var1_1, (int)var2_2, (int)var3_3, -1L, (JSONObject)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueLoad(@NonNull MediaQueueItem[] items, int startIndex, int repeatMode, long playPosition, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var6_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzaf zzaf2 = new zzaf(this, (MediaQueueItem[])var1_1, (int)var2_2, (int)var3_3, (long)var4_4, (JSONObject)var6_5);
        RemoteMediaClient.zzy(zzaf2);
        return zzaf2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int itemId, int newIndex, @Nullable JSONObject customData) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzar zzar2 = new zzar(this, (int)var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzy(zzar2);
        return zzar2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueNext(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzan zzan2 = new zzan(this, (JSONObject)var1_1);
        RemoteMediaClient.zzy(zzan2);
        return zzan2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queuePrev(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzam zzam2 = new zzam(this, (JSONObject)var1_1);
        RemoteMediaClient.zzy(zzam2);
        return zzam2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueRemoveItem(int itemId, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzap zzap2 = new zzap(this, (int)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzy(zzap2);
        return zzap2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueRemoveItems(@NonNull int[] itemIdsToRemove, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzaj zzaj2 = new zzaj(this, (int[])var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzy(zzaj2);
        return zzaj2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueReorderItems(@NonNull int[] itemIdsToReorder, int insertBeforeItemId, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzak zzak2 = new zzak(this, (int[])var1_1, (int)var2_2, (JSONObject)var3_3);
        RemoteMediaClient.zzy(zzak2);
        return zzak2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueSetRepeatMode(int repeatMode, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzao zzao2 = new zzao(this, (int)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzy(zzao2);
        return zzao2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public PendingResult<MediaChannelResult> queueShuffle(@Nullable JSONObject customData) {
        void var1_4;
        void var0_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            PendingResult pendingResult = RemoteMediaClient.zzf(17, null);
            return var0_2;
        }
        zzal zzal2 = new zzal(this, true, (JSONObject)var1_4);
        RemoteMediaClient.zzy(zzal2);
        zzal zzal3 = zzal2;
        return var0_2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> queueUpdateItems(@NonNull MediaQueueItem[] itemsToUpdate, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzai zzai2 = new zzai(this, (MediaQueueItem[])var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzy(zzai2);
        return zzai2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> requestStatus() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzac zzac2 = new zzac(this);
        RemoteMediaClient.zzy(zzac2);
        return zzac2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position) {
        void var1_1;
        return this.seek((long)var1_1, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> seek(@NonNull MediaSeekOptions seekOptions) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzba zzba2 = new zzba(this, (MediaSeekOptions)var1_1);
        RemoteMediaClient.zzy(zzba2);
        return zzba2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position, int resumeState) {
        void var3_2;
        void var1_1;
        return this.seek((long)var1_1, (int)var3_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public PendingResult<MediaChannelResult> seek(long position, int resumeState, @Nullable JSONObject customData) {
        void var4_3;
        void var3_2;
        void var1_1;
        MediaSeekOptions.Builder builder = new MediaSeekOptions.Builder();
        builder.setPosition((long)var1_1);
        builder.setResumeState((int)var3_2);
        builder.setCustomData((JSONObject)var4_3);
        return this.seek(builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setActiveMediaTracks(@NonNull long[] trackIds) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzad zzad2 = new zzad(this, (long[])var1_1);
        RemoteMediaClient.zzy(zzad2);
        return zzad2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setPlaybackRate(double playbackRate) {
        void var1_1;
        return this.setPlaybackRate((double)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setPlaybackRate(double playbackRate, @Nullable JSONObject customData) {
        void var3_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzbd zzbd2 = new zzbd(this, (double)var1_1, (JSONObject)var3_2);
        RemoteMediaClient.zzy(zzbd2);
        return zzbd2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamMute(boolean muted) {
        void var1_1;
        return this.setStreamMute((boolean)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamMute(boolean muted, @Nullable JSONObject customData) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzbc zzbc2 = new zzbc(this, (boolean)var1_1, (JSONObject)var2_2);
        RemoteMediaClient.zzy(zzbc2);
        return zzbc2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamVolume(double volume) throws IllegalArgumentException {
        void var1_1;
        return this.setStreamVolume((double)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setStreamVolume(double volume, @Nullable JSONObject customData) throws IllegalArgumentException {
        void var3_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzbb zzbb2 = new zzbb(this, (double)var1_1, (JSONObject)var3_2);
        RemoteMediaClient.zzy(zzbb2);
        return zzbb2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> setTextTrackStyle(@NonNull TextTrackStyle trackStyle) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzae zzae2 = new zzae(this, (TextTrackStyle)var1_1);
        RemoteMediaClient.zzy(zzae2);
        return zzae2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> skipAd() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzab zzab2 = new zzab(this);
        RemoteMediaClient.zzy(zzab2);
        return zzab2;
    }

    @NonNull
    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public PendingResult<MediaChannelResult> stop(@Nullable JSONObject customData) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzay zzay2 = new zzay(this, (JSONObject)var1_1);
        RemoteMediaClient.zzy(zzay2);
        return zzay2;
    }

    @NonNull
    public String getNamespace() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zze.zze();
    }

    static {
        zzb = new Logger("RemoteMediaClient");
        NAMESPACE = com.google.android.gms.cast.internal.zzaq.zzb;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void addListener(@NonNull Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzj.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMessageReceived(@NonNull CastDevice castDevice, @NonNull String string2, @NonNull String message) {
        void var3_3;
        this.zze.zzO((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void registerCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zza.add(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void removeListener(@NonNull Listener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zzj.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeProgressListener(@NonNull ProgressListener listener) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzbp zzbp2 = (zzbp)this.zzk.remove(var1_1);
        if (zzbp2 != null) {
            zzbp2.zze((ProgressListener)var1_1);
            if (!zzbp2.zzh()) {
                this.zzl.remove(zzbp2.zzb());
                zzbp2.zzg();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setParseAdsInfoCallback(@NonNull ParseAdsInfoCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        this.zzm = var1_1;
    }

    public void togglePlayback() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterCallback(@NonNull Callback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 != null) {
            this.zza.remove(var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean addProgressListener(@NonNull ProgressListener listener, long periodMs) {
        void var2_2;
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 == null || this.zzk.containsKey(var1_1)) {
            return false;
        }
        Object object = (long)var2_2;
        zzbp zzbp2 = (zzbp)this.zzl.get(object);
        if (zzbp2 == null) {
            zzbp2 = new zzbp(this, (long)var2_2);
            this.zzl.put(object, zzbp2);
            object = zzbp2;
        } else {
            object = zzbp2;
        }
        ((zzbp)object).zzd((ProgressListener)var1_1);
        this.zzk.put(var1_1, object);
        if (this.hasMediaSession()) {
            ((zzbp)object).zzf();
        }
        return true;
    }

    public boolean hasMediaSession() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.isBuffering() || this.zzu() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public boolean isBuffering() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 4;
    }

    public boolean isLiveStream() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaInfo();
        return remoteMediaClient != null && remoteMediaClient.getStreamType() == 2;
    }

    public boolean isLoadingNextItem() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getLoadingItemId() != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPaused() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) return false;
        if (mediaStatus.getPlayerState() == 3) return true;
        if (!this.isLiveStream()) return false;
        if (this.getIdleReason() == 2) return true;
        return false;
    }

    public boolean isPlaying() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 2;
    }

    public boolean isPlayingAd() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.isPlayingAd();
    }

    public final int zza() {
        if (this.getMediaInfo() == null || !this.hasMediaSession()) {
            return 0;
        }
        if (this.isBuffering()) {
            return 6;
        }
        if (this.isPlaying()) {
            return 3;
        }
        if (this.isPaused()) {
            return 2;
        }
        if (this.isLoadingNextItem() && (this = this.getLoadingItem()) != null && this.getMedia() != null) {
            return 6;
        }
        return 0;
    }

    static /* bridge */ /* synthetic */ Handler zzb(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzd;
    }

    static /* bridge */ /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzm;
    }

    static /* bridge */ /* synthetic */ Logger zzd() {
        return zzb;
    }

    static /* bridge */ /* synthetic */ com.google.android.gms.cast.internal.zzaq zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zze;
    }

    @NonNull
    public static PendingResult zzf(int n, @Nullable String string2) {
        zzbh zzbh2 = new zzbh();
        Status status = new Status(n, string2);
        zzbh zzbh3 = zzbh2;
        zzbh3.setResult(new zzbg(zzbh3, status));
        return zzbh2;
    }

    @NonNull
    public final PendingResult zzg(@Nullable String string2, @Nullable List list) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzaw zzaw2 = new zzaw(this, true, string2, null);
        RemoteMediaClient.zzy(zzaw2);
        return zzaw2;
    }

    @NonNull
    public final PendingResult zzh(int n, int n2, int n3) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzau zzau2 = new zzau(this, true, n, n2, n3);
        RemoteMediaClient.zzy(zzau2);
        return zzau2;
    }

    @NonNull
    public final PendingResult zzi() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzas zzas2 = new zzas(this, true);
        RemoteMediaClient.zzy(zzas2);
        return zzas2;
    }

    @NonNull
    public final PendingResult zzj(@NonNull int[] nArray) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return RemoteMediaClient.zzf(17, null);
        }
        zzat zzat2 = new zzat(this, true, nArray);
        RemoteMediaClient.zzy(zzat2);
        return zzat2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public final Task zzk(@Nullable JSONObject jSONObject) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.zzx()) {
            return Tasks.forException((Exception)new com.google.android.gms.cast.internal.zzao());
        }
        this.zzi = new TaskCompletionSource();
        zzb.d("create SessionState with cached mediaInfo and mediaStatus", new Object[0]);
        jSONObject = this.getMediaInfo();
        MediaStatus mediaStatus = this.getMediaStatus();
        if (jSONObject != null) {
            if (mediaStatus == null) {
                jSONObject = null;
            } else {
                MediaLoadRequestData.Builder builder = new MediaLoadRequestData.Builder();
                builder.setMediaInfo((MediaInfo)jSONObject);
                builder.setCurrentTime(this.getApproximateStreamPosition());
                builder.setQueueData(mediaStatus.getQueueData());
                builder.setPlaybackRate(mediaStatus.getPlaybackRate());
                builder.setActiveTrackIds(mediaStatus.getActiveTrackIds());
                builder.setCustomData(mediaStatus.getCustomData());
                SessionState.Builder builder2 = new SessionState.Builder();
                builder2.setLoadRequestData(builder.build());
                jSONObject = builder2.build();
            }
        } else {
            jSONObject = null;
        }
        if (jSONObject != null) {
            this.zzi.setResult((Object)jSONObject);
            return this.zzi.getTask();
        }
        this.zzi.setException((Exception)new com.google.android.gms.cast.internal.zzao());
        return this.zzi.getTask();
    }

    static /* bridge */ /* synthetic */ Object zzl(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzc;
    }

    static /* bridge */ /* synthetic */ List zzm(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzj;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzn(RemoteMediaClient remoteMediaClient) {
        Iterator iterator = remoteMediaClient.zzl.values().iterator();
        while (iterator.hasNext()) {
            zzbp zzbp2 = (zzbp)iterator.next();
            if (remoteMediaClient.hasMediaSession() && !zzbp2.zzi()) {
                zzbp2.zzf();
            } else if (!remoteMediaClient.hasMediaSession() && zzbp2.zzi()) {
                zzbp2.zzg();
            }
            if (!zzbp2.zzi() || !remoteMediaClient.isBuffering() && !remoteMediaClient.zzu() && !remoteMediaClient.isPaused() && !remoteMediaClient.isLoadingNextItem()) continue;
            remoteMediaClient.zzw(zzbp.zzc(zzbp2));
        }
        return;
    }

    static /* bridge */ /* synthetic */ void zzo(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zzw(set);
    }

    public RemoteMediaClient(com.google.android.gms.cast.internal.zzaq zzaq2) {
        this.zzc = new Object();
        this.zzd = new zzdy(Looper.getMainLooper());
        this.zzf = new zzbf(this);
        this.zze = (com.google.android.gms.cast.internal.zzaq)Preconditions.checkNotNull((Object)zzaq2);
        this.zze.zzQ((com.google.android.gms.cast.internal.zzan)new zzbn(this, null));
        this.zze.zzh((com.google.android.gms.cast.internal.zzar)this.zzf);
        this.zzg = new MediaQueue(this, 20, 20);
    }

    public final void zzp() {
        zzr zzr2 = this.zzh;
        if (zzr2 == null) {
            return;
        }
        zzr2.zzi(this.getNamespace(), (Cast.MessageReceivedCallback)this);
        this.requestStatus();
    }

    public final void zzq(@Nullable SessionState sessionState) {
        if (sessionState == null) {
            return;
        }
        if ((sessionState = sessionState.getLoadRequestData()) != null) {
            zzb.d("resume SessionState", new Object[0]);
            this.load((MediaLoadRequestData)sessionState);
            return;
        }
    }

    public final void zzr(@Nullable zzr zzr2) {
        zzr zzr3 = this.zzh;
        if (zzr3 == zzr2) {
            return;
        }
        if (zzr3 != null) {
            this.zze.zzf();
            this.zzg.zzl();
            zzr3.zzg(this.getNamespace());
            this.zzf.zzc(null);
            this.zzd.removeCallbacksAndMessages(null);
        }
        if ((zzr2 = (this.zzh = zzr2)) != null) {
            this.zzf.zzc(zzr2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzw(Set iterator) {
        HashSet hashSet = new HashSet(iterator);
        if (((RemoteMediaClient)object).isPlaying() || ((RemoteMediaClient)object).isPaused() || ((RemoteMediaClient)object).isBuffering() || ((RemoteMediaClient)object).zzu()) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(((RemoteMediaClient)object).getApproximateStreamPosition(), ((RemoteMediaClient)object).getStreamDuration());
            }
            return;
        }
        if (((RemoteMediaClient)object).isLoadingNextItem()) {
            if ((object = ((RemoteMediaClient)object).getLoadingItem()) == null || (object = object.getMedia()) == null) return;
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(0L, object.getStreamDuration());
            }
            return;
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            ((ProgressListener)object.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final boolean zzx() {
        return this.zzh != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzs() {
        if (!this.hasMediaSession()) {
            return false;
        }
        if ((this = (MediaStatus)Preconditions.checkNotNull((Object)this.getMediaStatus())).isMediaCommandSupported(64L)) {
            return true;
        }
        if (this.getQueueRepeatMode() != 0) return true;
        RemoteMediaClient remoteMediaClient = this;
        Integer n = remoteMediaClient.getIndexById(remoteMediaClient.getCurrentItemId());
        if (n == null) return false;
        if (n >= this.getQueueItemCount() + -1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzt() {
        if (!((RemoteMediaClient)object).hasMediaSession()) {
            return false;
        }
        if ((object = (MediaStatus)Preconditions.checkNotNull((Object)((RemoteMediaClient)object).getMediaStatus())).isMediaCommandSupported(128L)) {
            return true;
        }
        if (object.getQueueRepeatMode() != 0) return true;
        RemoteMediaClient remoteMediaClient = object;
        Object object = remoteMediaClient.getIndexById(remoteMediaClient.getCurrentItemId());
        if (object == null) return false;
        if ((Integer)object <= 0) return false;
        return true;
    }

    final boolean zzu() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        RemoteMediaClient remoteMediaClient = remoteMediaClient.getMediaStatus();
        return remoteMediaClient != null && remoteMediaClient.getPlayerState() == 5;
    }

    public final boolean zzv() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (!this.isLiveStream()) {
            return true;
        }
        if ((this = this.getMediaStatus()) == null) {
            return false;
        }
        return this.isMediaCommandSupported(2L) && this.getLiveSeekableRange() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final zzbk zzy(zzbk zzbk2) {
        try {
            zzbk2.zzc();
            return zzbk2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Throwable throwable) {
            Status status = new Status(2100);
            zzbk zzbk3 = zzbk2;
            zzbk3.setResult(new zzbj(zzbk3, status));
            return zzbk2;
        }
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface ParseAdsInfoCallback {
        @NonNull
        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(@NonNull MediaStatus var1);

        public boolean parseIsPlayingAdFromMediaStatus(@NonNull MediaStatus var1);
    }

    public static interface MediaChannelResult
    extends Result {
        @Nullable
        public MediaError getMediaError();

        @Nullable
        public JSONObject getCustomData();
    }

    public static abstract class Callback {
        public void onAdBreakStatusUpdated() {
        }

        public void onMediaError(@NonNull MediaError mediaError) {
        }

        public void onMetadataUpdated() {
        }

        public void onPreloadStatusUpdated() {
        }

        public void onQueueStatusUpdated() {
        }

        public void onSendingRemoteMediaRequest() {
        }

        public void onStatusUpdated() {
        }

        public void zza(@NonNull int[] nArray) {
        }

        public void zzb(@NonNull int[] nArray, int n) {
        }

        public void zzc(@NonNull MediaQueueItem[] mediaQueueItemArray) {
        }

        public void zzd(@NonNull int[] nArray) {
        }

        public void zze(@NonNull List list, @NonNull List list2, int n) {
        }

        public void zzf(@NonNull int[] nArray) {
        }

        public void zzg() {
        }
    }

    @Deprecated
    public static interface Listener {
        public void onAdBreakStatusUpdated();

        public void onMetadataUpdated();

        public void onPreloadStatusUpdated();

        public void onQueueStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onStatusUpdated();
    }
}

