/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.cast.zzek;
import com.google.android.gms.internal.cast.zzel;

class OuterHighlightDrawable
extends Drawable {
    private final int zza;
    private final int zzb;
    private final int zzc;
    private final Rect zzd = new Rect();
    private final Rect zze = new Rect();
    private final Paint zzf = new Paint();
    private float zzg;
    private float zzh = 1.0f;
    private float zzi;
    private float zzj;
    private float zzk = 0.0f;
    private float zzl = 0.0f;
    private int zzm = 244;

    public final int getAlpha() {
        return this.zzf.getAlpha();
    }

    public final int getOpacity() {
        return -3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public OuterHighlightDrawable(Context context) {
        int n;
        if (PlatformVersion.isAtLeastLollipop()) {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(16843827, typedValue, true);
            n = ColorUtils.setAlphaComponent((int)typedValue.data, (int)244);
        } else {
            n = context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color);
        }
        this.zzf.setColor(n);
        this.zzm = this.zzf.getAlpha();
        this.zzf.setAntiAlias(true);
        this.zzf.setStyle(Paint.Style.FILL);
        OuterHighlightDrawable outerHighlightDrawable = this;
        Resources resources = context.getResources();
        outerHighlightDrawable.zza = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        outerHighlightDrawable.zzb = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        outerHighlightDrawable.zzc = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public final void draw(Canvas canvas) {
        canvas.drawCircle(this.zzi + this.zzk, this.zzj + this.zzl, this.zzg * this.zzh, this.zzf);
    }

    public final void setAlpha(int n) {
        this.zzf.setAlpha(n);
        this.invalidateSelf();
    }

    public final void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.zzf.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setScale(float scale) {
        void var1_1;
        this.zzh = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setTranslationX(float translationX) {
        void var1_1;
        this.zzk = var1_1;
        this.invalidateSelf();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    public void setTranslationY(float translationY) {
        void var1_1;
        this.zzl = var1_1;
        this.invalidateSelf();
    }

    public final float zza() {
        return this.zzi;
    }

    public final float zzb() {
        return this.zzj;
    }

    @ColorInt
    public final int zzc() {
        return this.zzf.getColor();
    }

    public final Animator zzd(float f, float f2) {
        Object object = new float[]{0.0f, 1.0f};
        object = PropertyValuesHolder.ofFloat((String)"scale", (float[])object);
        Object[] objectArray = new float[]{f, 0.0f};
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"translationX", (float[])objectArray);
        objectArray = new float[]{f2, 0.0f};
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])objectArray);
        objectArray = new int[2];
        objectArray[0] = 0.0f;
        objectArray[1] = this.zzm;
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofInt((String)"alpha", (int[])objectArray);
        objectArray = new PropertyValuesHolder[4];
        objectArray[0] = (float)object;
        objectArray[1] = (float)propertyValuesHolder;
        objectArray[2] = (float)propertyValuesHolder2;
        objectArray[3] = (float)propertyValuesHolder3;
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])objectArray);
        objectAnimator.setInterpolator((TimeInterpolator)zzek.zzc());
        return objectAnimator.setDuration(350L);
    }

    public final void zze(@ColorInt int n) {
        this.zzf.setColor(n);
        this.zzm = this.zzf.getAlpha();
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(Rect rect, Rect rect2) {
        this.zzd.set(rect);
        this.zze.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zza) {
            this.zzi = f;
            this.zzj = f2;
            f = f2;
        } else {
            f = f <= rect3.exactCenterX() ? rect2.exactCenterX() + (float)this.zzb : rect2.exactCenterX() - (float)this.zzb;
            this.zzi = f;
            f = this.zzj = rect2.exactCenterY();
        }
        this.zzg = (float)this.zzc + Math.max(OuterHighlightDrawable.zzh(this.zzi, f, rect), OuterHighlightDrawable.zzh(this.zzi, this.zzj, rect2));
        this.invalidateSelf();
    }

    public final boolean zzg(float f, float f2) {
        return zzel.zza(f, f2, this.zzi, this.zzj) < this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final float zzh(float f, float f2, Rect rect) {
        float f3 = rect.left;
        float f4 = rect.top;
        float f5 = rect.right;
        float f6 = rect.bottom;
        float f7 = zzel.zza(f, f2, f3, f4);
        f4 = zzel.zza(f, f2, f5, f4);
        float f8 = f;
        float f9 = f2;
        f = zzel.zza(f8, f9, f5, f6);
        f2 = zzel.zza(f8, f9, f3, f6);
        if (f7 > f4 && f7 > f && f7 > f2) {
            f = f7;
            return (float)Math.ceil(f);
        }
        if (f4 > f && f4 > f2) {
            f = f4;
            return (float)Math.ceil(f);
        }
        if (f > f2) return (float)Math.ceil(f);
        f = f2;
        return (float)Math.ceil(f);
    }
}

