/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.mediarouter.R;
import androidx.mediarouter.app.MediaRouteChooserDialog;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzaa;
import com.google.android.gms.internal.cast.zzdm;
import com.google.android.gms.internal.cast.zzp;
import com.google.android.gms.internal.cast.zzs;
import com.google.android.gms.internal.cast.zzt;
import com.google.android.gms.internal.cast.zzu;
import com.google.android.gms.internal.cast.zzv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class zzw
extends MediaRouteChooserDialog
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final Logger zzf;
    private final zzu zzg;
    private final List zzh;
    private final long zzi;
    private MediaRouter zzj;
    private zzdm zzk;
    private MediaRouteSelector zzl;
    private ArrayAdapter zzm;
    private boolean zzn;
    private Runnable zzo;
    private MediaRouter.RouteInfo zzp;
    @Nullable
    protected TextView zza;
    @Nullable
    protected ListView zzb;
    @Nullable
    protected View zzc;
    @Nullable
    protected LinearLayout zzd;
    @Nullable
    protected LinearLayout zze;

    public final MediaRouteSelector getRouteSelector() {
        return this.zzl;
    }

    static /* bridge */ /* synthetic */ void zza(zzw zzw2, MediaRouter.RouteInfo routeInfo) {
        zzw2.zzp = routeInfo;
    }

    static /* bridge */ /* synthetic */ void zzb(zzw zzw2) {
        zzw2.zze();
    }

    static {
        Logger logger;
        zzf = logger = new Logger("DeviceChooserDialog");
    }

    public zzw(Context object, int n) {
        super(object, 0);
        super();
        this.zzh = object;
        this.zzl = MediaRouteSelector.EMPTY;
        super(this);
        this.zzg = object;
        this.zzi = zzaa.zza();
    }

    @CallSuper
    public final void dismiss() {
        super.dismiss();
        Object object = this.zzk;
        if (object != null) {
            object.removeCallbacks(this.zzo);
        }
        if ((object = this.zzc) != null) {
            object.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        object = this.zzh.iterator();
        while (object.hasNext()) {
            ((zzt)object.next()).zzb(this.zzp);
        }
        this.zzh.clear();
    }

    final /* synthetic */ void zzc() {
        LinearLayout linearLayout = ((zzw)((Object)iterator)).zzd;
        if (linearLayout != null && ((zzw)((Object)iterator)).zze != null) {
            ((LinearLayout)Preconditions.checkNotNull((Object)linearLayout)).setVisibility(8);
            ((LinearLayout)Preconditions.checkNotNull((Object)((zzw)((Object)iterator)).zze)).setVisibility(0);
        }
        Iterator iterator = ((zzw)((Object)iterator)).zzh.iterator();
        while (iterator.hasNext()) {
            zzt cfr_ignored_0 = (zzt)iterator.next();
        }
    }

    private final void zze() {
        MediaRouter mediaRouter = ((zzw)((Object)iterator)).zzj;
        if (mediaRouter != null) {
            ArrayList arrayList = new ArrayList(mediaRouter.getRoutes());
            iterator.onFilterRoutes(arrayList);
            Collections.sort(arrayList, zzv.zza);
            Iterator iterator = ((zzw)((Object)iterator)).zzh.iterator();
            while (iterator.hasNext()) {
                ((zzt)iterator.next()).zza(arrayList);
            }
        }
    }

    @CallSuper
    public final void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.zzn = true;
        this.zzf();
        this.zze();
    }

    protected final void onCreate(@Nullable Bundle object) {
        super.onCreate(object);
        object = (ListView)super.findViewById(R.id.mr_chooser_list);
        if (object == null) {
            return;
        }
        this.setContentView(R.layout.cast_device_chooser_dialog);
        this.zzm = (ArrayAdapter)object.getAdapter();
        ListView listView = this.zzb = (ListView)this.findViewById(R.id.cast_device_chooser_list);
        if (listView != null) {
            listView.setAdapter((ListAdapter)this.zzm);
            this.zzb.setOnItemClickListener(object.getOnItemClickListener());
        }
        this.zza = (TextView)this.findViewById(R.id.cast_device_chooser_title);
        this.zzd = (LinearLayout)this.findViewById(R.id.cast_device_chooser_searching);
        this.zze = (LinearLayout)this.findViewById(R.id.cast_device_chooser_zero_devices);
        object = (TextView)this.findViewById(R.id.cast_device_chooser_learn_more);
        if (object != null) {
            object.setMovementMethod(LinkMovementMethod.getInstance());
        }
        this.zzc = this.findViewById(16908292);
        if (this.zzb != null && (object = this.zzc) != null) {
            ((View)Preconditions.checkNotNull((Object)object)).getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            ((ListView)Preconditions.checkNotNull((Object)this.zzb)).setEmptyView((View)Preconditions.checkNotNull((Object)this.zzc));
        }
        object = new zzs(this);
        this.zzo = object;
    }

    @CallSuper
    public final void onDetachedFromWindow() {
        this.zzn = false;
        super.onDetachedFromWindow();
        this.zzg();
    }

    public final void onGlobalLayout() {
        Object object = this.zzc;
        if (object == null) {
            return;
        }
        object = object.getTag();
        int n = this.zzc.getVisibility();
        if (object == null || (Integer)object != n) {
            if (n == 0) {
                object = this.zzd;
                if (object != null && this.zze != null) {
                    ((LinearLayout)Preconditions.checkNotNull((Object)object)).setVisibility(0);
                    ((LinearLayout)Preconditions.checkNotNull((Object)this.zze)).setVisibility(8);
                }
                if ((object = this.zzk) != null) {
                    object.removeCallbacks(this.zzo);
                    this.zzk.postDelayed(this.zzo, this.zzi);
                }
            }
            ((View)Preconditions.checkNotNull((Object)this.zzc)).setTag((Object)n);
            return;
        }
    }

    public final void refreshRoutes() {
        super.refreshRoutes();
        this.zze();
    }

    public final void setRouteSelector(MediaRouteSelector mediaRouteSelector) {
        if (mediaRouteSelector == null) {
            Object object = new IllegalArgumentException("selector must not be null");
            throw object;
        }
        super.setRouteSelector(mediaRouteSelector);
        if (!((zzw)((Object)object)).zzl.equals((Object)mediaRouteSelector)) {
            ((zzw)((Object)object)).zzl = mediaRouteSelector;
            ((zzw)((Object)object)).zzg();
            if (((zzw)((Object)object)).zzn) {
                super.zzf();
            }
            super.zze();
            return;
        }
    }

    public final void setTitle(int n) {
        zzw zzw2 = zzw2.zza;
        if (zzw2 != null) {
            zzw2.setText(n);
            return;
        }
    }

    public final void setTitle(@Nullable CharSequence charSequence) {
        zzw zzw2 = zzw2.zza;
        if (zzw2 != null) {
            zzw2.setText(charSequence);
            return;
        }
    }

    public final void zzd() {
        Object object;
        this.zzj = MediaRouter.getInstance((Context)this.getContext());
        this.zzk = object = new zzdm(Looper.getMainLooper());
        object = com.google.android.gms.internal.cast.zzp.zza();
        if (object != null) {
            this.zzh.add(object);
            return;
        }
    }

    private final void zzf() {
        zzf.d("startDiscovery", new Object[0]);
        MediaRouter mediaRouter = ((zzw)((Object)iterator)).zzj;
        if (mediaRouter == null) {
            zzf.d("Can't start discovery. setUpMediaRouter needs to be called first", new Object[0]);
            return;
        }
        mediaRouter.addCallback(((zzw)((Object)iterator)).zzl, (MediaRouter.Callback)((zzw)((Object)iterator)).zzg, 1);
        Iterator iterator = ((zzw)((Object)iterator)).zzh.iterator();
        while (iterator.hasNext()) {
            ((zzt)iterator.next()).zzc(1);
        }
    }

    private final void zzg() {
        zzf.d("stopDiscovery", new Object[0]);
        MediaRouter mediaRouter = ((zzw)((Object)iterator)).zzj;
        if (mediaRouter == null) {
            zzf.d("Can't stop discovery. setUpMediaRouter needs to be called first", new Object[0]);
            return;
        }
        mediaRouter.removeCallback((MediaRouter.Callback)((zzw)((Object)iterator)).zzg);
        ((zzw)((Object)iterator)).zzj.addCallback(((zzw)((Object)iterator)).zzl, (MediaRouter.Callback)((zzw)((Object)iterator)).zzg, 0);
        Iterator iterator = ((zzw)((Object)iterator)).zzh.iterator();
        while (iterator.hasNext()) {
            ((zzt)iterator.next()).zzd();
        }
    }
}

