/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transformer;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.runtime.Destination;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionTransferCallback;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.zzax;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.cast.zzac;
import com.google.android.gms.internal.cast.zzbh;
import com.google.android.gms.internal.cast.zzd;
import com.google.android.gms.internal.cast.zze;
import com.google.android.gms.internal.cast.zzi;
import com.google.android.gms.internal.cast.zzj;
import com.google.android.gms.internal.cast.zzk;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzma;
import com.google.android.gms.internal.cast.zzp;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnSuccessListener;
import java.util.Locale;
import java.util.UUID;
import org.checkerframework.dataflow.qual.Pure;

@MainThread
@ShowFirstParty
public final class zzf {
    private final Context zzb;
    private final zzn zzc;
    private final SessionManager zzd;
    @Nullable
    private final zzbh zze;
    private final zzac zzf;
    private final String zzg;
    @VisibleForTesting
    @Nullable
    Transport zza;
    private int zzh;

    public static zzf zza(Context context, zzn zzn2, SessionManager sessionManager, @Nullable zzbh zzbh2, zzac zzac2) {
        zzf zzf2 = new zzf(context, zzn2, sessionManager, zzbh2, zzac2);
        return zzf2;
    }

    private zzf(Context context, zzn zzn2, SessionManager sessionManager, @Nullable zzbh zzbh2, zzac zzac2) {
        this.zzb = context;
        this.zzc = zzn2;
        this.zzd = sessionManager;
        this.zze = zzbh2;
        this.zzf = zzac2;
        this.zzh = 1;
        this.zzg = UUID.randomUUID().toString();
    }

    final /* synthetic */ void zzb(String string2, SharedPreferences sharedPreferences, Bundle bundle) {
        Preconditions.checkNotNull((Object)((zzf)object).zzd);
        SessionManager sessionManager = ((zzf)object).zzd;
        zzbh zzbh2 = ((zzf)object).zze;
        zzk zzk2 = new zzk(sharedPreferences, (zzf)object, bundle, string2);
        ((zzf)object).zzf.zze(zzk2.zzc());
        Object object = new zzi(zzk2);
        sessionManager.addSessionManagerListener(object, CastSession.class);
        if (zzbh2 != null) {
            object = new zzj(zzk2);
            zzbh2.zzg((SessionTransferCallback)object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzc(Bundle bundle) {
        boolean bl = bundle.getBoolean("com.google.android.gms.cast.FLAG_CLIENT_SESSION_ANALYTICS_ENABLED");
        boolean bl2 = bundle.getBoolean("com.google.android.gms.cast.FLAG_CLIENT_FEATURE_USAGE_ANALYTICS_ENABLED");
        if (!bl && !bl2) {
            return;
        }
        String string2 = this.zzb.getPackageName();
        Locale locale = Locale.ROOT;
        Object[] objectArray = new Object[]{string2, "client_cast_analytics_data"};
        String string3 = String.format(locale, "%s.%s", objectArray);
        int n = bundle.getLong("com.google.android.gms.cast.FLAG_FIRELOG_UPLOAD_MODE") == 0L ? 1 : 2;
        this.zzh = n;
        TransportRuntime.initialize((Context)this.zzb);
        this.zza = TransportRuntime.getInstance().newFactory((Destination)CCTDestination.INSTANCE).getTransport("CAST_SENDER_SDK", zzma.class, Encoding.of((String)"proto"), (Transformer)com.google.android.gms.internal.cast.zze.zza);
        SharedPreferences sharedPreferences = this.zzb.getApplicationContext().getSharedPreferences(string3, 0);
        if (bl) {
            zzn zzn2 = this.zzc;
            String[] stringArray = new String[]{"com.google.android.gms.cast.DICTIONARY_CAST_STATUS_CODES_TO_APP_SESSION_ERROR", "com.google.android.gms.cast.DICTIONARY_CAST_STATUS_CODES_TO_APP_SESSION_CHANGE_REASON"};
            TaskApiCall.Builder builder = TaskApiCall.builder();
            com.google.android.gms.cast.internal.zzf zzf2 = new com.google.android.gms.cast.internal.zzf(zzn2, stringArray);
            TaskApiCall.Builder builder2 = builder.run((RemoteCall)zzf2);
            Feature[] featureArray = new Feature[]{zzax.zzg};
            TaskApiCall.Builder builder5 = builder2.setFeatures(featureArray);
            builder5 = builder5.setAutoResolveMissingFeatures(false);
            builder5 = builder5.setMethodKey(8426);
            TaskApiCall taskApiCall = builder5.build();
            zzn2 = zzn2.doRead(taskApiCall);
            zzd zzd2 = new zzd(this, string2, sharedPreferences);
            zzn2.addOnSuccessListener((OnSuccessListener)zzd2);
        }
        if (bl2) {
            Preconditions.checkNotNull((Object)sharedPreferences);
            zzr.zza(sharedPreferences, this, string2).zze();
            zzr.zzd(zzkx.zzf);
        }
        zzp.zzf(this, string2);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @Pure
    public final void zzd(zzma zzma2, int n) {
        zzma2 = zzma.zzd((zzma)zzma2);
        zzma2.zzk(zzf2.zzg);
        zzma2.zzf(zzf2.zzg);
        zzma2 = (zzma)zzma2.zzp();
        int n2 = zzf2.zzh;
        int n3 = n2 + -1;
        if (n2 == 0) {
            throw null;
        }
        switch (n3) {
            default: {
                zzma2 = null;
                break;
            }
            case 1: {
                zzma2 = Event.ofData((int)(n + -1), (Object)zzma2);
                break;
            }
            case 0: {
                zzma2 = Event.ofTelemetry((int)(n + -1), (Object)zzma2);
            }
        }
        Preconditions.checkNotNull((Object)zzma2);
        zzf zzf2 = zzf2.zza;
        if (zzf2 != null) {
            zzf2.send((Event)zzma2);
            return;
        }
    }
}

