/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.graphics.PorterDuff;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;

public final class zzcp
extends UIController
implements RemoteMediaClient.ProgressListener {
    private final TextView zza;
    private final ImageView zzb;
    private final zza zzc;

    public zzcp(View view, zza zza2) {
        this.zza = (TextView)view.findViewById(R.id.live_indicator_text);
        this.zzb = (ImageView)view.findViewById(R.id.live_indicator_dot);
        this.zzc = zza2;
        view = this.zzb.getContext().obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        int n = R.styleable.CastExpandedController_castLiveIndicatorColor;
        n = view.getResourceId(n, 0);
        view.recycle();
        view = this.zzb;
        view = view.getContext();
        view = view.getResources();
        int n2 = view.getColor(n);
        this.zzb.getDrawable().setColorFilter(n2, PorterDuff.Mode.SRC_IN);
        this.zza.setVisibility(8);
        this.zzb.setVisibility(8);
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zza();
    }

    @Override
    public final void onProgressUpdated(long l, long l2) {
        this.zza();
    }

    @Override
    public final void onSessionConnected(CastSession object) {
        super.onSessionConnected((CastSession)object);
        object = this.getRemoteMediaClient();
        if (object != null) {
            ((RemoteMediaClient)object).addProgressListener(this, 1000L);
        }
        this.zza();
    }

    @Override
    public final void onSessionEnded() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null) {
            remoteMediaClient.removeProgressListener(this);
        }
        super.onSessionEnded();
        this.zza();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    final void zza() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession() || !remoteMediaClient.isLiveStream()) {
            this.zza.setVisibility(8);
            this.zzb.setVisibility(8);
            return;
        }
        boolean bl = !remoteMediaClient.zzv() ? remoteMediaClient.isPlaying() : this.zzc.zzm();
        this.zza.setVisibility(0);
        ImageView imageView = this.zzb;
        int n = true != bl ? 8 : 0;
        imageView.setVisibility(n);
        zzr.zzd(zzkx.zzz);
    }
}

