/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.cast;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.SessionState;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionTransferCallback;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzbf;
import com.google.android.gms.internal.cast.zzbg;
import com.google.android.gms.internal.cast.zzdm;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=30)
public final class zzbh {
    private static final Logger zza;
    private final Set zzb;
    private final Handler zzc;
    private final Runnable zzd;
    private int zze;
    private SessionManager zzf;
    @Nullable
    private CallbackToFutureAdapter.Completer zzg;
    @Nullable
    private SessionState zzh;

    public static /* synthetic */ void zza(zzbh zzbh2, SessionState sessionState) {
        zzbh2.zzh = sessionState;
        zzbh2 = zzbh2.zzg;
        if (zzbh2 != null) {
            zzbh2.set(null);
            return;
        }
    }

    public static /* synthetic */ void zzb(zzbh zzbh2) {
        Logger logger = zza;
        Object[] objectArray = new Object[]{zzbh2.zze};
        logger.i("transfer with type = %d has timed out", objectArray);
        zzbh2.zzj(101);
    }

    static {
        Logger logger;
        zza = logger = new Logger("SessionTransController");
    }

    public zzbh() {
        Object object = new HashSet();
        this.zzb = Collections.synchronizedSet(object);
        this.zze = 0;
        object = new zzdm(Looper.getMainLooper());
        this.zzc = object;
        super(this);
        this.zzd = object;
    }

    public final void zzc(SessionManager sessionManager) {
        this.zzf = sessionManager;
    }

    private final void zzi() {
        if (((zzbh)((Object)castSession)).zzf == null) {
            zza.d("skip detaching as sessionManager is null", new Object[0]);
            return;
        }
        zza.d("detach from CastSession", new Object[0]);
        CastSession castSession = ((zzbh)((Object)castSession)).zzf.getCurrentCastSession();
        if (castSession != null) {
            castSession.zzj(null);
            return;
        }
    }

    private final void zzj(int n) {
        Object object = this.zzg;
        if (object != null) {
            object.setCancelled();
        }
        object = zza;
        Object[] objectArray = new Object[]{this.zze, n};
        object.d("notify failed transfer with type = %d, reason = %d", objectArray);
        object = new HashSet(this.zzb);
        object = object.iterator();
        while (object.hasNext()) {
            ((SessionTransferCallback)object.next()).onTransferFailed(this.zze, n);
        }
        this.zzk();
    }

    final /* synthetic */ void zzd(Exception exception) {
        zza.w((Throwable)exception, "Fail to store SessionState", new Object[0]);
        this.zzj(100);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zze() {
        if (this.zze == 0) {
            zza.d("No need to notify non remote-to-local transfer", new Object[0]);
            return;
        }
        SessionState sessionState = this.zzh;
        if (sessionState == null) {
            zza.d("No need to notify with null sessionState", new Object[0]);
        } else {
            Object object = zza;
            Object[] objectArray = new Object[]{1, this.zzh};
            object.d("notify transferred with type = %d, sessionState = %s", objectArray);
            object = new HashSet(this.zzb);
            object = object.iterator();
            while (object.hasNext()) {
                ((SessionTransferCallback)object.next()).onTransferred(this.zze, sessionState);
            }
        }
        this.zzk();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzf(MediaRouter.RouteInfo object, MediaRouter.RouteInfo object2, CallbackToFutureAdapter.Completer objectArray) {
        HashSet hashSet = new HashSet(this.zzb);
        if (hashSet.isEmpty()) {
            zza.d("No need to prepare transfer without any callback", new Object[0]);
            objectArray.set(null);
            return;
        }
        if (object.getPlaybackType() != 1 || object2.getPlaybackType() != 0) {
            zza.d("No need to prepare transfer for non cast-to-phone case", new Object[0]);
            objectArray.set(null);
            return;
        }
        if (this.zzf == null) {
            zza.d("skip attaching as sessionManager is null", new Object[0]);
            object = null;
        } else {
            zza.d("attach to CastSession for transfer notification", new Object[0]);
            object = this.zzf.getCurrentCastSession();
            if (object != null) {
                ((CastSession)object).zzj(this);
            }
        }
        if (object == null) {
            zza.d("No need to prepare transfer when there is no Cast session", new Object[0]);
            objectArray.set(null);
            return;
        }
        if ((object = ((CastSession)object).getRemoteMediaClient()) == null || !((RemoteMediaClient)object).hasMediaSession()) {
            zza.d("No need to prepare transfer when there is no media session", new Object[0]);
            this.zzi();
            objectArray.set(null);
            return;
        }
        zza.d("Prepare route transfer for changing endpoint", new Object[0]);
        this.zze = 1;
        this.zzg = objectArray;
        object2 = zza;
        objectArray = new Object[]{1};
        object2.d("notify transferring with type = %d", objectArray);
        object2 = new HashSet(this.zzb);
        object2 = object2.iterator();
        while (true) {
            if (!object2.hasNext()) {
                this.zzh = null;
                object = ((RemoteMediaClient)object).zzj(null);
                object2 = new zzbf(this);
                object = object.addOnSuccessListener((OnSuccessListener)object2);
                object2 = new zzbg(this);
                object.addOnFailureListener((OnFailureListener)object2);
                ((Handler)Preconditions.checkNotNull((Object)this.zzc)).postDelayed((Runnable)Preconditions.checkNotNull((Object)this.zzd), 10000L);
                zzr.zzd(zzkx.zzP);
                return;
            }
            ((SessionTransferCallback)object2.next()).onTransferring(this.zze);
        }
    }

    public final void zzg(SessionTransferCallback sessionTransferCallback) {
        Logger logger = zza;
        Object[] objectArray = new Object[]{sessionTransferCallback};
        logger.d("register callback = %s", objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)sessionTransferCallback);
        this.zzb.add(sessionTransferCallback);
    }

    private final void zzk() {
        ((Handler)Preconditions.checkNotNull((Object)this.zzc)).removeCallbacks((Runnable)Preconditions.checkNotNull((Object)this.zzd));
        this.zze = 0;
        this.zzh = null;
        this.zzi();
    }

    public final void zzh(SessionTransferCallback sessionTransferCallback) {
        Logger logger = zza;
        Object[] objectArray = new Object[]{sessionTransferCallback};
        logger.d("unregister callback = %s", objectArray);
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (sessionTransferCallback != null) {
            this.zzb.remove(sessionTransferCallback);
            return;
        }
    }
}

