/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.TaskStackBuilder;
import androidx.media.app.NotificationCompat;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.R;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.NotificationAction;
import com.google.android.gms.cast.framework.media.NotificationActionsProvider;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.internal.zzb;
import com.google.android.gms.cast.framework.media.internal.zzs;
import com.google.android.gms.cast.framework.media.zzg;
import com.google.android.gms.cast.framework.media.zzk;
import com.google.android.gms.cast.framework.media.zzl;
import com.google.android.gms.cast.framework.media.zzm;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.internal.CastUtils;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.cast.zzdl;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MediaNotificationService
extends Service {
    @NonNull
    public static final String ACTION_UPDATE_NOTIFICATION = "com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION";
    private static final Logger zza;
    @Nullable
    private static Runnable zzb;
    private NotificationOptions zzc;
    @Nullable
    private ImagePicker zzd;
    private ComponentName zze;
    @Nullable
    private ComponentName zzf;
    private List zzg;
    @Nullable
    private int[] zzh;
    private long zzi;
    private zzb zzj;
    private ImageHints zzk;
    private Resources zzl;
    private zzm zzm;
    private zzn zzn;
    private NotificationManager zzo;
    private Notification zzp;
    private CastContext zzq;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public int onStartCommand(@NonNull Intent intent, int n, int startId) {
        void var3_4;
        Object object;
        MediaInfo mediaInfo = (MediaInfo)Preconditions.checkNotNull((Object)((MediaInfo)intent.getParcelableExtra("extra_media_info")));
        MediaMetadata mediaMetadata = (MediaMetadata)Preconditions.checkNotNull((Object)mediaInfo.getMetadata());
        n = object.getIntExtra("extra_remote_media_client_player_state", 0);
        CastDevice castDevice = (CastDevice)Preconditions.checkNotNull((Object)((CastDevice)object.getParcelableExtra("extra_cast_device")));
        n = n == 2 ? 1 : 0;
        zzm zzm2 = new zzm(n != 0, mediaInfo.getStreamType(), mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"), castDevice.getFriendlyName(), (MediaSessionCompat.Token)object.getParcelableExtra("extra_media_session_token"), object.getBooleanExtra("extra_can_skip_next", false), object.getBooleanExtra("extra_can_skip_prev", false));
        if (object.getBooleanExtra("extra_media_notification_force_update", false) || (object = this.zzm) == null || zzm2.zzb != ((zzm)object).zzb || zzm2.zzc != ((zzm)object).zzc || !CastUtils.zzh((Object)zzm2.zzd, (Object)((zzm)object).zzd) || !CastUtils.zzh((Object)zzm2.zze, (Object)((zzm)object).zze) || zzm2.zzf != ((zzm)object).zzf || zzm2.zzg != ((zzm)object).zzg) {
            this.zzm = zzm2;
            this.zzg();
        }
        object = (object = this.zzd) != null ? ((ImagePicker)object).onPickImage(mediaMetadata, this.zzk) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        zzn zzn2 = new zzn((WebImage)object);
        object = this.zzn;
        if (object == null || !CastUtils.zzh((Object)zzn2.zza, (Object)((zzn)object).zza)) {
            object = this.zzj;
            zzl zzl2 = new zzl(this, zzn2);
            ((zzb)object).zzc(zzl2);
            this.zzj.zzd(zzn2.zza);
        }
        this.startForeground(1, this.zzp);
        zzb = object = new zzk(this, (int)var3_4);
        return 2;
    }

    @Nullable
    public IBinder onBind(@NonNull Intent intent) {
        return null;
    }

    static {
        Logger logger;
        zza = logger = new Logger("MediaNotificationService");
    }

    public MediaNotificationService() {
        ArrayList arrayList;
        this.zzg = arrayList = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCreate() {
        ImageHints imageHints;
        ComponentName componentName;
        this.zzo = (NotificationManager)this.getSystemService("notification");
        this.zzq = CastContext.getSharedInstance((Context)this);
        CastMediaOptions castMediaOptions = (CastMediaOptions)((Object)Preconditions.checkNotNull((Object)((Object)this.zzq.getCastOptions().getCastMediaOptions())));
        this.zzc = (NotificationOptions)((Object)Preconditions.checkNotNull((Object)((Object)castMediaOptions.getNotificationOptions())));
        this.zzd = castMediaOptions.getImagePicker();
        this.zzl = this.getResources();
        this.zze = componentName = new ComponentName(this.getApplicationContext(), castMediaOptions.getMediaIntentReceiverClassName());
        if (!TextUtils.isEmpty((CharSequence)this.zzc.getTargetActivityClassName())) {
            castMediaOptions = new ComponentName(this.getApplicationContext(), this.zzc.getTargetActivityClassName());
            this.zzf = castMediaOptions;
        } else {
            this.zzf = null;
        }
        this.zzi = this.zzc.getSkipStepMs();
        int n = this.zzl.getDimensionPixelSize(this.zzc.zze());
        this.zzk = imageHints = new ImageHints(1, n, n);
        Object object = new zzb(this.getApplicationContext(), this.zzk);
        this.zzj = object;
        if (PlatformVersion.isAtLeastO()) {
            object = this.getResources();
            int n2 = R.string.media_notification_channel_name;
            object = object.getString(n2);
            NotificationChannel notificationChannel = new NotificationChannel("cast_media_notification", (CharSequence)object, 2);
            notificationChannel.setShowBadge(false);
            this.zzo.createNotificationChannel(notificationChannel);
        }
        zzr.zzd(zzkx.zzX);
    }

    public void onDestroy() {
        zzb zzb2 = this.zzj;
        if (zzb2 != null) {
            zzb2.zza();
        }
        zzb = null;
        this.zzo.cancel(1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static boolean isNotificationOptionsValid(@NonNull CastOptions options) {
        int n;
        CastMediaOptions castMediaOptions = options.getCastMediaOptions();
        if (castMediaOptions == null) {
            return false;
        }
        NotificationOptions notificationOptions = castMediaOptions.getNotificationOptions();
        if (notificationOptions == null) {
            return false;
        }
        zzg zzg2 = notificationOptions.zzm();
        if (zzg2 == null) {
            return true;
        }
        List list = zzs.zzf(zzg2);
        int[] nArray = zzs.zzg(zzg2);
        if (list == null) {
            boolean bl = false;
        } else {
            int n2 = list.size();
        }
        if (list == null || list.isEmpty()) {
            zza.e(String.valueOf(NotificationActionsProvider.class.getSimpleName()).concat(" doesn't provide any action."), new Object[0]);
            return false;
        }
        if (list.size() > 5) {
            zza.e(String.valueOf(NotificationActionsProvider.class.getSimpleName()).concat(" provides more than 5 actions."), new Object[0]);
            return false;
        }
        if (nArray == null || (n = nArray.length) == 0) {
            zza.e(String.valueOf(NotificationActionsProvider.class.getSimpleName()).concat(" doesn't provide any actions for compact view."), new Object[0]);
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            void var0_5;
            int n4 = nArray[n3];
            if (n4 < 0 || n4 >= var0_5) {
                zza.e(String.valueOf(NotificationActionsProvider.class.getSimpleName()).concat("provides a compact view action whose index is out of bounds."), new Object[0]);
                return false;
            }
            ++n3;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private final NotificationCompat.Action zzd(String var1_2) {
        switch (var1_2.hashCode()) lbl-1000:
        // 7 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_4 = -1;
lbl5:
                    // 8 sources

                    while (true) {
                        switch (var2_4) {
                            case 5: {
                                var1_2 = new Intent("com.google.android.gms.cast.framework.action.STOP_CASTING");
                                var1_2.setComponent(this.zze);
                                var2_4 = zzdl.zza;
                                var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)var2_4);
                                var2_5 = new NotificationCompat.Action.Builder(this.zzc.getDisconnectDrawableResId(), (CharSequence)this.zzl.getString(this.zzc.zza()), (PendingIntent)var1_2);
                                return var2_5.build();
                            }
                            case 6: {
                                var1_2 = new Intent("com.google.android.gms.cast.framework.action.DISCONNECT");
                                var1_2.setComponent(this.zze);
                                var2_4 = zzdl.zza;
                                var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)var2_4);
                                var3_14 = this.zzc;
                                var3_15 = var3_14.getDisconnectDrawableResId();
                                var4_22 = this.zzl;
                                this = this.zzc;
                                var0_1 = this.zza();
                                var5_27 = new Object[]{""};
                                var2_6 = new NotificationCompat.Action.Builder(var3_15, (CharSequence)var4_22.getString(var0_1, var5_27), (PendingIntent)var1_2);
                                return var2_6.build();
                            }
                            case 4: {
                                var6_28 = this.zzi;
                                var1_2 = new Intent("com.google.android.gms.cast.framework.action.REWIND");
                                var1_2.setComponent(this.zze);
                                var1_2.putExtra("googlecast-extra_skip_step_ms", var6_28);
                                var2_4 = zzdl.zza;
                                var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)(var2_4 | 0x8000000));
                                var2_7 = this.zzc;
                                var2_8 = zzs.zzc(var2_7, var6_28);
                                var3_16 = this.zzc;
                                var3_17 = zzs.zzd(var3_16, var6_28);
                                var4_23 = new NotificationCompat.Action.Builder(var2_8, (CharSequence)this.zzl.getString(var3_17), (PendingIntent)var1_2);
                                return var4_23.build();
                            }
                            case 3: {
                                var6_29 = this.zzi;
                                var1_2 = new Intent("com.google.android.gms.cast.framework.action.FORWARD");
                                var1_2.setComponent(this.zze);
                                var1_2.putExtra("googlecast-extra_skip_step_ms", var6_29);
                                var2_4 = zzdl.zza;
                                var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)(var2_4 | 0x8000000));
                                var2_9 = this.zzc;
                                var2_10 = zzs.zza(var2_9, var6_29);
                                var3_18 = this.zzc;
                                var3_19 = zzs.zzb(var3_18, var6_29);
                                var4_24 = new NotificationCompat.Action.Builder(var2_10, (CharSequence)this.zzl.getString(var3_19), (PendingIntent)var1_2);
                                return var4_24.build();
                            }
                            case 2: {
                                if (this.zzm.zzg) {
                                    var1_2 = new Intent("com.google.android.gms.cast.framework.action.SKIP_PREV");
                                    var1_2.setComponent(this.zze);
                                    var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)zzdl.zza);
lbl65:
                                    // 2 sources

                                    while (true) {
                                        var2_11 = new NotificationCompat.Action.Builder(this.zzc.getSkipPrevDrawableResId(), (CharSequence)this.zzl.getString(this.zzc.zzl()), (PendingIntent)var1_2);
                                        return var2_11.build();
                                    }
                                }
                                var1_2 = null;
                                ** continue;
                            }
                            case 1: {
                                if (this.zzm.zzf) {
                                    var1_2 = new Intent("com.google.android.gms.cast.framework.action.SKIP_NEXT");
                                    var1_2.setComponent(this.zze);
                                    var1_2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var1_2, (int)zzdl.zza);
lbl76:
                                    // 2 sources

                                    while (true) {
                                        var2_12 = new NotificationCompat.Action.Builder(this.zzc.getSkipNextDrawableResId(), (CharSequence)this.zzl.getString(this.zzc.zzk()), (PendingIntent)var1_2);
                                        return var2_12.build();
                                    }
                                }
                                var1_2 = null;
                                ** continue;
                            }
                            case 0: {
                                var1_2 = this.zzm;
                                var2_4 = var1_2.zzc;
                                var3_20 = var1_2.zzb;
                                if (var2_4 == 2) {
                                    var1_3 = this.zzc.getStopLiveStreamDrawableResId();
                                    var2_4 = this.zzc.getStopLiveStreamTitleResId();
lbl88:
                                    // 2 sources

                                    while (true) {
                                        if (!var3_20) {
                                            var1_3 = this.zzc.getPlayDrawableResId();
                                        }
                                        if (!var3_20) {
                                            var2_4 = this.zzc.zzg();
                                        }
                                        var3_21 = new Intent("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK");
                                        var3_21.setComponent(this.zze);
                                        var4_25 = zzdl.zza;
                                        var3_21 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)var3_21, (int)var4_25);
                                        var4_26 = new NotificationCompat.Action.Builder(var1_3, (CharSequence)this.zzl.getString(var2_4), (PendingIntent)var3_21);
                                        return var4_26.build();
                                    }
                                }
                                var1_3 = this.zzc.getPauseDrawableResId();
                                var2_4 = this.zzc.zzf();
                                ** continue;
                            }
                        }
                        this = MediaNotificationService.zza;
                        var2_13 = new Object[]{var1_2};
                        this.e("Action: %s is not a pre-defined action.", var2_13);
                        return null;
                    }
                    break;
                }
            }
            case 1362116196: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.FORWARD")) ** GOTO lbl-1000
                var2_4 = 3;
                ** GOTO lbl5
            }
            case 235550565: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK")) ** GOTO lbl-1000
                var2_4 = 0;
                ** GOTO lbl5
            }
            case -124479363: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.DISCONNECT")) ** GOTO lbl-1000
                var2_4 = 6;
                ** GOTO lbl5
            }
            case -668151673: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.STOP_CASTING")) ** GOTO lbl-1000
                var2_4 = 5;
                ** GOTO lbl5
            }
            case -945080078: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.SKIP_PREV")) ** GOTO lbl-1000
                var2_4 = 2;
                ** GOTO lbl5
            }
            case -945151566: {
                if (!var1_2.equals("com.google.android.gms.cast.framework.action.SKIP_NEXT")) ** GOTO lbl-1000
                var2_4 = 1;
                ** GOTO lbl5
            }
            case -1699820260: 
        }
        ** while (!var1_2.equals((Object)"com.google.android.gms.cast.framework.action.REWIND"))
lbl133:
        // 1 sources

        var2_4 = 4;
        ** while (true)
    }

    static /* bridge */ /* synthetic */ void zza(MediaNotificationService mediaNotificationService, zzn zzn2) {
        mediaNotificationService.zzn = zzn2;
    }

    static /* bridge */ /* synthetic */ void zzb(MediaNotificationService mediaNotificationService) {
        mediaNotificationService.zzg();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zze(zzg object) {
        ArrayList arrayList;
        void var2_10;
        int[] nArray = zzs.zzg((zzg)object);
        if (nArray == null) {
            Object var2_9 = null;
        } else {
            int[] nArray2 = (int[])nArray.clone();
        }
        this.zzh = var2_10;
        List list = zzs.zzf((zzg)object);
        this.zzg = arrayList = new ArrayList();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            void var1_6;
            NotificationAction notificationAction = (NotificationAction)((Object)iterator.next());
            String string2 = notificationAction.getAction();
            if (string2.equals("com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK") || string2.equals("com.google.android.gms.cast.framework.action.SKIP_NEXT") || string2.equals("com.google.android.gms.cast.framework.action.SKIP_PREV") || string2.equals("com.google.android.gms.cast.framework.action.FORWARD") || string2.equals("com.google.android.gms.cast.framework.action.REWIND") || string2.equals("com.google.android.gms.cast.framework.action.STOP_CASTING") || string2.equals("com.google.android.gms.cast.framework.action.DISCONNECT")) {
                NotificationCompat.Action action = this.zzd(notificationAction.getAction());
            } else {
                string2 = new Intent(notificationAction.getAction());
                string2.setComponent(this.zze);
                int n = zzdl.zza;
                string2 = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)string2, (int)n);
                NotificationCompat.Action.Builder builder = new NotificationCompat.Action.Builder(notificationAction.getIconResId(), (CharSequence)notificationAction.getContentDescription(), (PendingIntent)string2);
                NotificationCompat.Action action = builder.build();
            }
            if (var1_6 == null) continue;
            this.zzg.add(var1_6);
        }
        return;
    }

    private final void zzf() {
        Object object = new ArrayList();
        this.zzg = object;
        object = this.zzc.getActions().iterator();
        while (object.hasNext()) {
            NotificationCompat.Action action = this.zzd((String)object.next());
            if (action == null) continue;
            this.zzg.add(action);
        }
        this.zzh = (int[])this.zzc.getCompatActionIndices().clone();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void zzg() {
        zzg zzg2;
        void var1_9;
        void var1_3;
        if (this.zzm == null) {
            return;
        }
        zzn zzn2 = this.zzn;
        if (zzn2 == null) {
            Object var1_2 = null;
        } else {
            Bitmap bitmap = zzn2.zzb;
        }
        Object object = new NotificationCompat.Builder((Context)this, "cast_media_notification");
        NotificationCompat.Builder builder = object.setLargeIcon((Bitmap)var1_3);
        object = this.zzc;
        int n = ((NotificationOptions)((Object)object)).getSmallIconDrawableResId();
        NotificationCompat.Builder builder2 = builder.setSmallIcon(n);
        Object object2 = this.zzm;
        object2 = ((zzm)object2).zzd;
        NotificationCompat.Builder builder3 = builder2.setContentTitle((CharSequence)object2);
        object2 = this.zzl;
        NotificationOptions notificationOptions = this.zzc;
        int n2 = notificationOptions.getCastingToDeviceStringResId();
        Object[] objectArray = new Object[]{this.zzm.zze};
        object2 = builder3.setContentText((CharSequence)object2.getString(n2, objectArray)).setOngoing(true).setShowWhen(false).setVisibility(1);
        ComponentName componentName = this.zzf;
        if (componentName == null) {
            Object var1_8 = null;
        } else {
            Intent intent = new Intent();
            intent.putExtra("targetActivity", (Parcelable)componentName);
            intent.setAction(componentName.flattenToString());
            intent.setComponent(componentName);
            TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)this);
            taskStackBuilder.addNextIntentWithParentStack(intent);
            PendingIntent pendingIntent = taskStackBuilder.getPendingIntent(1, zzdl.zza | 0x8000000);
        }
        if (var1_9 != null) {
            object2.setContentIntent((PendingIntent)var1_9);
        }
        if ((zzg2 = this.zzc.zzm()) != null) {
            zza.i("actionsProvider != null", new Object[0]);
            this.zze(zzg2);
        } else {
            zza.i("actionsProvider == null", new Object[0]);
            this.zzf();
        }
        Iterator iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            object2.addAction((NotificationCompat.Action)iterator.next());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            MediaSessionCompat.Token token;
            NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle();
            int[] nArray = this.zzh;
            if (nArray != null) {
                mediaStyle.setShowActionsInCompactView(nArray);
            }
            if ((token = this.zzm.zza) != null) {
                mediaStyle.setMediaSession(token);
            }
            object2.setStyle((NotificationCompat.Style)mediaStyle);
        }
        this.zzp = object2.build();
        this.startForeground(1, this.zzp);
    }

    public static void zzc() {
        Runnable runnable = zzb;
        if (runnable != null) {
            runnable.run();
            return;
        }
    }
}

