/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.cast.framework.zzak;
import com.google.android.gms.cast.framework.zzaw;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.cast.zzad;

public abstract class Session {
    private static final Logger zza;
    @Nullable
    private final zzak zzb;
    private final zzaw zzc;

    public long getSessionRemainingTimeMs() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getCategory() {
        zzak object;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        object = ((Session)((Object)object)).zzb;
        if (object == null) return null;
        try {
            return object.zzh();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"getCategory", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSessionId() {
        zzak object;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        object = ((Session)((Object)object)).zzb;
        if (object == null) return null;
        try {
            return object.zzi();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"getSessionId", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    static {
        Logger logger;
        zza = logger = new Logger("Session");
    }

    /*
     * WARNING - void declaration
     */
    protected Session(@NonNull Context applicationContext, @NonNull String category, @Nullable String sessionId) {
        void var3_3;
        void var2_2;
        void var1_1;
        zzaw zzaw2;
        this.zzc = zzaw2 = new zzaw(this, null);
        this.zzb = zzad.zzd((Context)var1_1, (String)var2_2, (String)var3_3, this.zzc);
    }

    protected abstract void end(boolean var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifyFailedToResumeSession(int error) {
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzj((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"notifyFailedToResumeSession", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifyFailedToStartSession(int error) {
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzk((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"notifyFailedToStartSession", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifySessionEnded(int error) {
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzl((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"notifySessionEnded", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifySessionResumed(boolean wasSuspended) {
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzm((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"notifySessionResumed", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifySessionStarted(@NonNull String sessionId) {
        Logger logger;
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            this_.zzn((String)logger);
            return;
        }
        catch (RemoteException remoteException) {
            logger = zza;
            Object[] objectArray = new Object[]{"notifySessionStarted", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void notifySessionSuspended(int reason) {
        zzak this_ = ((Session)((Object)this_)).zzb;
        if (this_ == null) return;
        try {
            void var1_2;
            this_.zzo((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"notifySessionSuspended", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return;
        }
    }

    protected void onResuming(@Nullable Bundle bundle) {
    }

    protected void onStarting(@Nullable Bundle bundle) {
    }

    protected abstract void resume(@Nullable Bundle var1);

    protected abstract void start(@Nullable Bundle var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return false;
        try {
            return zzak2.zzp();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isConnected", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnecting() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return false;
        try {
            return zzak2.zzq();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isConnecting", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDisconnected() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return true;
        try {
            return zzak2.zzr();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isDisconnected", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDisconnecting() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return false;
        try {
            return zzak2.zzs();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isDisconnecting", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isResuming() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return false;
        try {
            return zzak2.zzt();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isResuming", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuspended() {
        zzak zzak2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak2 = ((Session)((Object)zzak2)).zzb;
        if (zzak2 == null) return false;
        try {
            return zzak2.zzu();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"isSuspended", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int zzl() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        zzak zzak2 = this.zzb;
        if (zzak2 == null) return 0;
        try {
            int n = zzak2.zze();
            if (n < 211100000) return 0;
        }
        catch (RemoteException remoteException) {
            zzak2 = zza;
            Object[] objectArray = new Object[]{"getSessionStartType", zzak.class.getSimpleName()};
            zzak2.d(remoteException, "Unable to call %s on %s.", objectArray);
            return 0;
        }
        return this.zzb.zzf();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IObjectWrapper zzm() {
        zzak object;
        object = ((Session)((Object)object)).zzb;
        if (object == null) return null;
        try {
            return object.zzg();
        }
        catch (RemoteException remoteException) {
            Logger logger = zza;
            Object[] objectArray = new Object[]{"getWrappedObject", zzak.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    protected void zzk(@Nullable Bundle bundle) {
    }
}

