/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.mediarouter.media.MediaRouteSelector;
import androidx.mediarouter.media.MediaRouter;
import com.google.android.gms.cast.CredentialsData;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastButtonFactory;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastReasonCodes;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.ModuleUnavailableException;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.SessionTransferCallback;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zzae;
import com.google.android.gms.cast.framework.zzam;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.cast.framework.zzc;
import com.google.android.gms.cast.framework.zzq;
import com.google.android.gms.cast.framework.zzx;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.cast.internal.zzh;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.zzax;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.cast.zzac;
import com.google.android.gms.internal.cast.zzad;
import com.google.android.gms.internal.cast.zzaf;
import com.google.android.gms.internal.cast.zzaj;
import com.google.android.gms.internal.cast.zzaw;
import com.google.android.gms.internal.cast.zzbd;
import com.google.android.gms.internal.cast.zzbh;
import com.google.android.gms.internal.cast.zzf;
import com.google.android.gms.internal.cast.zzz;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class CastContext {
    @NonNull
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static final Logger zzb;
    private static final Object zzc;
    @Nullable
    private static volatile CastContext zzd;
    private final Context zze;
    private final zzx zzf;
    private final SessionManager zzg;
    private final zzq zzh;
    private final PrecacheManager zzi;
    private final MediaNotificationManager zzj;
    private final CastOptions zzk;
    private final zzn zzl;
    @VisibleForTesting
    final zzac zza;
    private final zzbd zzm;
    private final zzaw zzn;
    @Nullable
    private final List zzo;
    @Nullable
    private final zzbh zzp;
    @Nullable
    private zzaf zzq;
    @Nullable
    private CastReasonCodes zzr;

    /*
     * WARNING - void declaration
     */
    public int getCastReasonCodeForCastStatusCode(int castStatusCode) {
        void var1_1;
        CastReasonCodes this_ = ((CastContext)((Object)this_)).zzr;
        if (this_ == null) {
            zzb.w("castReasonCodes hasn't been initialized yet", new Object[0]);
            return 0;
        }
        return this_.zza((int)var1_1);
    }

    public int getCastState() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzg.zza();
    }

    @Nullable
    public MediaRouteSelector getMergedSelector() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            CastContext castContext = MediaRouteSelector.fromBundle((Bundle)castContext.zzf.zze());
            return castContext;
        }
        catch (RemoteException remoteException) {
            Logger logger = zzb;
            Object[] objectArray = new Object[]{"getMergedSelectorAsBundle", zzx.class.getSimpleName()};
            logger.d((Throwable)remoteException, "Unable to call %s on %s.", objectArray);
            return null;
        }
    }

    @Nullable
    public static CastContext getSharedInstance() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @NonNull
    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (zzd != null) return zzd;
        Object object = zzc;
        synchronized (object) {
            Context context2;
            Object object2 = zzd;
            if (object2 != null) return zzd;
            context2 = context2.getApplicationContext();
            object2 = CastContext.zzf(context2);
            CastOptions castOptions = object2.getCastOptions(context2);
            zzn zzn2 = new zzn(context2);
            zzbd zzbd2 = new zzbd(context2, MediaRouter.getInstance((Context)context2), castOptions, zzn2);
            try {
                CastContext castContext;
                zzd = castContext = new CastContext(context2, castOptions, object2.getAdditionalSessionProviders(context2), zzbd2, zzn2);
                return zzd;
            }
            catch (ModuleUnavailableException moduleUnavailableException) {}
            object2 = new RuntimeException(moduleUnavailableException);
            throw object2;
        }
    }

    @NonNull
    public CastOptions getCastOptions() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzk;
    }

    @NonNull
    public MediaNotificationManager getMediaNotificationManager() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzj;
    }

    @NonNull
    public PrecacheManager getPrecacheManager() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzi;
    }

    @NonNull
    public SessionManager getSessionManager() throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Task<CastContext> getSharedInstance(@NonNull Context context, @NonNull Executor executor) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (zzd == null) {
            void var1_1;
            Context context2;
            context2 = context2.getApplicationContext();
            OptionsProvider optionsProvider = CastContext.zzf(context2);
            CastOptions castOptions = optionsProvider.getCastOptions(context2);
            zzn zzn2 = new zzn(context2);
            zzbd zzbd2 = new zzbd(context2, MediaRouter.getInstance((Context)context2), castOptions, zzn2);
            zzc zzc2 = new zzc(context2, castOptions, optionsProvider, zzbd2, zzn2);
            return Tasks.call((Executor)var1_1, (Callable)zzc2);
        }
        return Tasks.forResult((Object)zzd);
    }

    static {
        Object object;
        zzb = object = new Logger("CastContext");
        object = new Object();
        zzc = object;
    }

    @Deprecated
    public void addAppVisibilityListener(@NonNull AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
    }

    /*
     * WARNING - void declaration
     */
    public void addCastStateListener(@NonNull CastStateListener listener) throws IllegalStateException, NullPointerException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        this.zzg.zzc((CastStateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addSessionTransferCallback(@NonNull SessionTransferCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        zzbh zzbh2 = ((CastContext)((Object)zzbh2)).zzm.zzn();
        if (zzbh2 != null) {
            zzbh2.zzg((SessionTransferCallback)var1_1);
            return;
        }
    }

    @Deprecated
    public void removeAppVisibilityListener(@NonNull AppVisibilityListener appVisibilityListener) throws IllegalStateException {
    }

    /*
     * WARNING - void declaration
     */
    public void removeCastStateListener(@NonNull CastStateListener listener) throws IllegalStateException {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (var1_1 == null) {
            return;
        }
        this.zzg.zzd((CastStateListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeSessionTransferCallback(@NonNull SessionTransferCallback callback) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_1);
        zzbh zzbh2 = ((CastContext)((Object)zzbh2)).zzm.zzn();
        if (zzbh2 != null) {
            zzbh2.zzh((SessionTransferCallback)var1_1);
            return;
        }
    }

    public void setLaunchCredentialsData(@NonNull CredentialsData credentialsData) {
        LaunchOptions launchOptions;
        LaunchOptions.Builder builder = new LaunchOptions.Builder(this.zzk.getLaunchOptions());
        builder.setCredentialsData((CredentialsData)launchOptions);
        launchOptions = builder.build();
        this.zzk.zzb(launchOptions);
        this.zzh();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReceiverApplicationId(@NonNull String applicationId) {
        void var1_1;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        if (TextUtils.equals((CharSequence)var1_1, (CharSequence)this.zzk.getReceiverApplicationId())) {
            return;
        }
        this.zzk.zzc((String)var1_1);
        this.zzh();
        Map map = this.zzg();
        try {
            this.zzf.zzi((String)var1_1, map);
        }
        catch (RemoteException remoteException) {
            map = zzb;
            Object[] objectArray = new Object[]{"setReceiverApplicationId", zzx.class.getSimpleName()};
            map.d(remoteException, "Unable to call %s on %s.", objectArray);
        }
        CastButtonFactory.zza(this.zze);
    }

    @Deprecated
    public boolean isAppVisible() throws IllegalStateException {
        return false;
    }

    @Deprecated
    public boolean onDispatchVolumeKeyEventBeforeJellyBean(@NonNull KeyEvent keyEvent) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return false;
    }

    @Nullable
    public static CastContext zza(@NonNull Context object) throws IllegalStateException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        try {
            object = CastContext.getSharedInstance(object);
            return object;
        }
        catch (RuntimeException runtimeException) {
            Logger logger = zzb;
            Object[] objectArray = new Object[]{runtimeException};
            logger.e("Failed to load module from Google Play services. Cast will not work properly. Might due to outdated Google Play services. Ignoring this failure silently.", objectArray);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ CastContext zzb(Context context, CastOptions castOptions, OptionsProvider optionsProvider, zzbd zzbd2, zzn zzn2) throws Exception {
        Object object = zzc;
        synchronized (object) {
            CastContext castContext = zzd;
            if (castContext != null) return zzd;
            zzd = castContext = new CastContext(context, castOptions, optionsProvider.getAdditionalSessionProviders(context), zzbd2, zzn2);
            return zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @ShowFirstParty
    public final zzq zzc() {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OptionsProvider zzf(Context object) throws IllegalStateException {
        try {
            String string2;
            Bundle bundle = Wrappers.packageManager((Context)object).getApplicationInfo((String)object.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzb.e("Bundle is null", new Object[0]);
            }
            if ((string2 = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) != null) return Class.forName(string2).asSubclass(OptionsProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            IllegalStateException illegalStateException = new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            throw illegalStateException;
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to initialize CastContext.", throwable);
            throw illegalStateException;
        }
    }

    private final Map zzg() {
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        SessionProvider sessionProvider = ((CastContext)((Object)iterator)).zzq;
        if (sessionProvider != null) {
            hashMap.put(sessionProvider.getCategory(), sessionProvider.zza());
        }
        if ((iterator = ((CastContext)((Object)iterator)).zzo) != null) {
            Iterator iterator = iterator.iterator();
            while (iterator.hasNext()) {
                sessionProvider = (SessionProvider)iterator.next();
                Preconditions.checkNotNull((Object)sessionProvider, (Object)"Additional SessionProvider must not be null.");
                String string2 = Preconditions.checkNotEmpty((String)sessionProvider.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                boolean bl = hashMap.containsKey(string2);
                Object[] objectArray = new Object[]{string2};
                Preconditions.checkArgument((boolean)(bl ^ true), (Object)String.format("SessionProvider for category %s already added", objectArray));
                hashMap.put(string2, sessionProvider.zza());
            }
        }
        return hashMap;
    }

    public static /* synthetic */ void zzd(@NonNull CastContext castContext, @NonNull Bundle bundle) {
        com.google.android.gms.internal.cast.zzf.zza(castContext.zze, castContext.zzl, castContext.zzg, castContext.zzp, castContext.zza).zzc(bundle);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CastContext(Context object, CastOptions object2, @Nullable List object3, zzbd object4, zzn zzn2) throws ModuleUnavailableException {
        Object object5;
        void var5_13;
        block9: {
            Object object6;
            this.zze = object;
            this.zzk = object2;
            this.zzm = object6;
            this.zzl = var5_13;
            this.zzo = object5;
            object5 = new zzaw((Context)object);
            this.zzn = object5;
            this.zzp = ((zzbd)object6).zzn();
            this.zzh();
            object5 = this.zzg();
            try {
                object5 = zzad.zza((Context)object, (CastOptions)((Object)object2), (zzaj)object6, (Map)object5);
                this.zzf = object5;
            }
            catch (RemoteException remoteException) {
                object = new IllegalStateException("Failed to call newCastContextImpl", remoteException);
                throw object;
            }
            try {
                zzq zzq2;
                object6 = object5.zzf();
                this.zzh = zzq2 = new zzq((zzae)object6);
            }
            catch (RemoteException remoteException) {
                object = new IllegalStateException("Failed to call getDiscoveryManagerImpl", remoteException);
                throw object;
            }
            try {}
            catch (RemoteException remoteException) {
                object = new IllegalStateException("Failed to call getSessionManagerImpl", remoteException);
                throw object;
            }
            object5 = object5.zzg();
            object5 = this.zzg = (object6 = new SessionManager((zzam)object5, (Context)object));
            this.zzj = object = new MediaNotificationManager((SessionManager)object5);
            this.zzi = object = new PrecacheManager(this.zzk, (SessionManager)object5, (zzn)var5_13);
            object = this.zzp;
            if (object != null) {
                ((zzbh)object).zzc(this.zzg);
            }
            object = new String[]{"com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_UPDATE_DEVICES_DELAY_MS", "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_DISCOVERY_TIMEOUT_MS", "com.google.android.gms.cast.FLAG_MEDIA_ROUTE_DIALOG_ZERO_DEVICE_TIMEOUT_MS"};
            var5_13.zza((String[])object).addOnSuccessListener((OnSuccessListener)zzz.zza);
            this.zza = object = new zzac();
            try {
                this.zzf.zzh(this.zza);
                this.zza.zze(this.zzn.zza);
                if (((CastOptions)((Object)object2)).zza().isEmpty()) break block9;
            }
            catch (RemoteException remoteException) {
                object = new IllegalStateException("Failed to call addAppVisibilityListener", remoteException);
                throw object;
            }
            zzb.i("Setting Route Discovery for appIds: ".concat(String.valueOf(String.valueOf(this.zzk.zza()))), new Object[0]);
            this.zzn.zza(this.zzk.zza());
        }
        object = new String[]{"com.google.android.gms.cast.FLAG_CLIENT_SESSION_ANALYTICS_ENABLED", "com.google.android.gms.cast.FLAG_FIRELOG_UPLOAD_MODE", "com.google.android.gms.cast.FLAG_CLIENT_FEATURE_USAGE_ANALYTICS_ENABLED"};
        object = var5_13.zza((String[])object);
        zza zza2 = new zza(this);
        object.addOnSuccessListener((OnSuccessListener)zza2);
        object = new String[]{"com.google.android.gms.cast.MAP_CAST_STATUS_CODES_TO_CAST_REASON_CODES"};
        TaskApiCall.Builder builder = TaskApiCall.builder();
        object5 = new zzh((zzn)var5_13, (String[])object);
        object = builder.run((RemoteCall)object5);
        Feature[] featureArray = new Feature[]{zzax.zzh};
        object = object.setFeatures(featureArray);
        object = object.setAutoResolveMissingFeatures(false);
        object = object.setMethodKey(8427);
        object = object.build();
        object = var5_13.doRead((TaskApiCall)object);
        zzb zzb2 = new zzb(this);
        object.addOnSuccessListener((OnSuccessListener)zzb2);
    }

    final /* synthetic */ void zze(Bundle bundle) {
        CastReasonCodes castReasonCodes;
        this.zzr = castReasonCodes = new CastReasonCodes(bundle);
    }

    @RequiresNonNull(value={"castOptions", "mediaRouter", "appContext"})
    private final void zzh() {
        if (!TextUtils.isEmpty((CharSequence)this.zzk.getReceiverApplicationId())) {
            zzaf zzaf2;
            this.zzq = zzaf2 = new zzaf(this.zze, this.zzk, this.zzm);
            return;
        }
        this.zzq = null;
    }
}

