/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.MenuItemCompat;
import androidx.mediarouter.app.MediaRouteActionProvider;
import androidx.mediarouter.app.MediaRouteButton;
import androidx.mediarouter.app.MediaRouteDialogFactory;
import androidx.mediarouter.media.MediaRouteSelector;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.internal.Logger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.cast.zzkx;
import com.google.android.gms.internal.cast.zzr;
import com.google.android.gms.internal.cast.zzy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class CastButtonFactory {
    private static final Logger zzb;
    private static final List zzc;
    private static final List zzd;
    public static final /* synthetic */ int zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static MenuItem setUpMediaRouteButton(@NonNull Context context, @NonNull Menu menu, int menuResourceId) {
        Object object;
        void var2_6;
        void var1_2;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        Preconditions.checkNotNull((Object)var1_2);
        MenuItem menuItem = var1_2.findItem((int)var2_6);
        if (menuItem == null) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{(int)var2_6};
            object = new IllegalArgumentException(String.format(locale, "menu doesn't contain a menu item whose ID is %d.", objectArray));
            throw object;
        }
        boolean bl = CastButtonFactory.zzg((Context)object);
        try {
            boolean bl2;
            Object object2 = CastButtonFactory.zzb(menuItem);
            if (object2 != null && (bl2 = CastButtonFactory.zzh((Context)object, null))) {
                object2.setAlwaysVisible(true);
            }
            CastButtonFactory.zze((Context)object, menuItem, CastButtonFactory.zzc(null, bl));
            object = zzc;
            object2 = new WeakReference(menuItem);
            object.add(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Locale locale = Locale.ROOT;
            Object[] objectArray = new Object[]{(int)var2_6};
            IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException(String.format(locale, "menu item with ID %d doesn't have a MediaRouteActionProvider.", objectArray), illegalArgumentException);
            throw illegalArgumentException2;
        }
        CastButtonFactory.zzd(null, bl);
        return menuItem;
    }

    static {
        Object object;
        zzb = object = new Logger("CastButtonFactory");
        object = new ArrayList();
        zzc = object;
        object = new ArrayList();
        zzd = object;
    }

    private CastButtonFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static void setUpMediaRouteButton(@NonNull Context context, @NonNull MediaRouteButton button) {
        void var1_1;
        List list;
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        boolean bl = CastButtonFactory.zzg((Context)list);
        if (var1_1 != null) {
            if (CastButtonFactory.zzh((Context)list, null)) {
                var1_1.setAlwaysVisible(true);
            }
            CastButtonFactory.zzf((Context)list, (MediaRouteButton)var1_1, CastButtonFactory.zzc(null, bl));
            list = zzd;
            WeakReference<void> weakReference = new WeakReference<void>(var1_1);
            list.add(weakReference);
        }
        CastButtonFactory.zzd(null, bl);
    }

    @Nullable
    private static MediaRouteActionProvider zzb(MenuItem menuItem) {
        if ((menuItem = (MediaRouteActionProvider)MenuItemCompat.getActionProvider((MenuItem)menuItem)) == null) {
            return null;
        }
        return menuItem;
    }

    @Nullable
    private static MediaRouteDialogFactory zzc(@Nullable MediaRouteDialogFactory mediaRouteDialogFactory, boolean bl) {
        if (bl) {
            mediaRouteDialogFactory = new zzy();
            return mediaRouteDialogFactory;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void zzd(@Nullable MediaRouteDialogFactory mediaRouteDialogFactory, boolean bl) {
        mediaRouteDialogFactory = bl ? zzkx.zzZ : zzkx.zzH;
        zzr.zzd((zzkx)mediaRouteDialogFactory);
    }

    private static void zze(Context object, @NonNull MenuItem menuItem, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) throws IllegalArgumentException {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        menuItem = CastButtonFactory.zzb(menuItem);
        if (menuItem == null) {
            object = new IllegalArgumentException("cannot refreshButtonSelector with null mediaRouteActionProvider");
            throw object;
        }
        if ((object = CastContext.zza((Context)object)) != null && (object = ((CastContext)object).getMergedSelector()) != null) {
            menuItem.setRouteSelector((MediaRouteSelector)object);
        }
        if (mediaRouteDialogFactory != null) {
            menuItem.setDialogFactory(mediaRouteDialogFactory);
            return;
        }
    }

    private static void zzf(Context object, MediaRouteButton mediaRouteButton, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) {
        Preconditions.checkMainThread((String)"Must be called from the main thread.");
        object = CastContext.zza((Context)object);
        if (object != null && (object = ((CastContext)object).getMergedSelector()) != null) {
            mediaRouteButton.setRouteSelector((MediaRouteSelector)object);
        }
        if (mediaRouteDialogFactory != null) {
            mediaRouteButton.setDialogFactory(mediaRouteDialogFactory);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zza(@NonNull Context context) {
        MenuItem menuItem;
        Iterator iterator = zzc.iterator();
        while (iterator.hasNext()) {
            menuItem = (MenuItem)((WeakReference)iterator.next()).get();
            if (menuItem == null) continue;
            try {
                CastButtonFactory.zze(context, menuItem, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logger logger = zzb;
                Object[] objectArray = new Object[]{illegalArgumentException};
                logger.w("Unexpected exception when refreshing MediaRouteSelectors for Cast buttons", objectArray);
            }
        }
        iterator = zzd.iterator();
        while (iterator.hasNext()) {
            menuItem = (MediaRouteButton)((WeakReference)iterator.next()).get();
            if (menuItem == null) continue;
            CastButtonFactory.zzf(context, (MediaRouteButton)menuItem, null);
        }
        return;
    }

    private static boolean zzg(Context object) {
        return (object = CastContext.zza((Context)object)) != null && ((CastContext)object).getCastOptions().zze();
    }

    private static boolean zzh(Context context, @Nullable MediaRouteDialogFactory mediaRouteDialogFactory) {
        return CastButtonFactory.zzg(context);
    }
}

