/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbj;
import com.google.android.gms.internal.zzbbk;
import com.google.android.gms.internal.zzbbl;

@Hide
public final class zzbbi
implements RemoteMediaClient.Listener {
    private final Context zzbky;
    private final CastOptions zzfgz;
    private final zzbaw zzfbo;
    private final ComponentName zzfha;
    private final zzbax zzfhb;
    private final zzbax zzfhc;
    private RemoteMediaClient zzfaq;
    private CastDevice zzetm;
    private MediaSessionCompat zzfhd;
    private MediaSessionCompat.Callback zzfhe;
    private boolean zzfhf;

    public zzbbi(Context context, CastOptions castOptions, zzbaw zzbaw2) {
        this.zzbky = context;
        this.zzfgz = castOptions;
        this.zzfbo = zzbaw2;
        this.zzfha = this.zzfgz.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzfgz.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzbky, this.zzfgz.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzfhb = new zzbax(this.zzbky);
        this.zzfhb.zza(new zzbbj(this));
        this.zzfhc = new zzbax(this.zzbky);
        this.zzfhc.zza(new zzbbk(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.zzfhf || this.zzfgz == null || this.zzfgz.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzfaq = remoteMediaClient;
        this.zzfaq.addListener(this);
        this.zzetm = castDevice;
        if (!zzs.zzanx()) {
            ((AudioManager)this.zzbky.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzbky, this.zzfgz.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzbky, (int)0, (Intent)intent, (int)0);
        this.zzfhd = new MediaSessionCompat(this.zzbky, "CastMediaSession", componentName, pendingIntent);
        this.zzfhd.setFlags(3);
        this.zza(0, null);
        if (this.zzetm != null && !TextUtils.isEmpty((CharSequence)this.zzetm.getFriendlyName())) {
            this.zzfhd.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzbky.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzetm.getFriendlyName()})).build());
        }
        this.zzfhe = new zzbbl(this);
        this.zzfhd.setCallback(this.zzfhe);
        this.zzfhd.setActive(true);
        this.zzfbo.setMediaSessionCompat(this.zzfhd);
        this.zzfhf = true;
        this.zzbc(false);
    }

    public final void zzbh(int n) {
        if (!this.zzfhf) {
            return;
        }
        this.zzfhf = false;
        if (this.zzfaq != null) {
            this.zzfaq.removeListener(this);
        }
        if (!zzs.zzanx()) {
            ((AudioManager)this.zzbky.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzfbo.setMediaSessionCompat(null);
        if (this.zzfhb != null) {
            this.zzfhb.clear();
        }
        if (this.zzfhc != null) {
            this.zzfhc.clear();
        }
        if (this.zzfhd != null) {
            this.zzfhd.setSessionActivity(null);
            this.zzfhd.setCallback(null);
            this.zzfhd.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzfhd.setActive(false);
            this.zzfhd.release();
            this.zzfhd = null;
        }
        this.zzfaq = null;
        this.zzetm = null;
        this.zzfhe = null;
        this.zzafu();
        if (n == 0) {
            this.zzafv();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzbc(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzbc(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzbc(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzbc(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzbc(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzbc(boolean bl) {
        int n;
        if (this.zzfaq == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzfaq.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzfaq.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzfaq.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzafu();
            this.zzafv();
            return;
        }
        boolean bl5 = bl;
        zzbbi zzbbi2 = this;
        if (zzbbi2.zzfgz.getCastMediaOptions().getNotificationOptions() != null && zzbbi2.zzfaq != null) {
            Intent intent = new Intent(zzbbi2.zzbky, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzbbi2.zzbky.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzbbi2.zzfaq.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzbbi2.zzfaq.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzbbi2.zzetm);
            zzbbi zzbbi3 = zzbbi2;
            intent.putExtra("extra_media_session_token", zzbbi3.zzfhd == null ? null : zzbbi3.zzfhd.getSessionToken());
            MediaStatus mediaStatus2 = zzbbi2.zzfaq.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzbbi2.zzbky.startService(intent);
        }
        if (!bl2) {
            zzbbi2 = this;
            if (zzbbi2.zzfgz.getEnableReconnectionService()) {
                Intent intent = new Intent(zzbbi2.zzbky, ReconnectionService.class);
                intent.setPackage(zzbbi2.zzbky.getPackageName());
                zzbbi2.zzbky.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzfhd.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzfhd.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzfhd.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzbbi zzbbi2 = this;
        if (zzbbi2.zzfha == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzbbi2.zzfha);
            pendingIntent = PendingIntent.getActivity((Context)zzbbi2.zzbky, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzfhd.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzbbi2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzbbi2.zzaft().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzbbi2.zzfhd.setMetadata(builder.build());
        Uri uri = zzbbi2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzbbi2.zzfhb.zzl(uri);
        } else {
            zzbbi2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzbbi2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzbbi2.zzfhc.zzl(uri2);
            return;
        }
        zzbbi2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzfhd.setMetadata(this.zzaft().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzfhd.setMetadata(this.zzaft().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzfhd.setMetadata(this.zzaft().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzfgz.getCastMediaOptions().getImagePicker() != null ? this.zzfgz.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzaft() {
        MediaMetadataCompat mediaMetadataCompat = this.zzfhd.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzafu() {
        if (this.zzfgz.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzbky, MediaNotificationService.class);
        intent.setPackage(this.zzbky.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzbky.stopService(intent);
    }

    private final void zzafv() {
        if (!this.zzfgz.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbky, ReconnectionService.class);
        intent.setPackage(this.zzbky.getPackageName());
        this.zzbky.stopService(intent);
    }

    static /* synthetic */ void zza(zzbbi zzbbi2, Bitmap bitmap, int n) {
        zzbbi2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzbbi zzbbi2) {
        return zzbbi2.zzfaq;
    }
}

