/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzban;
import com.google.android.gms.internal.zzbar;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzfax;
        private int zzfay;
        private String zzfaz;
        private OnOverlayDismissedListener zzfba;
        private boolean zzfbb;
        private float zzfbc;
        private String zzfbd;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzfax = ((MenuItem)zzbq.checkNotNull((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzfax = (View)zzbq.checkNotNull((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzfay = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzfaz = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzfaz = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzfba = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzfbb = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzfbc = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzfbc = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzfbd = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzfbd = this.mActivity.getResources().getString(n);
            return this;
        }

        @Hide
        public final Activity getActivity() {
            return this.mActivity;
        }

        @Hide
        public final View zzaem() {
            return this.zzfax;
        }

        @Hide
        public final OnOverlayDismissedListener zzaen() {
            return this.zzfba;
        }

        @Hide
        public final int zzaeo() {
            return this.zzfay;
        }

        @Hide
        public final boolean zzaep() {
            return this.zzfbb;
        }

        @Hide
        public final String zzaeq() {
            return this.zzfaz;
        }

        @Hide
        public final String zzaer() {
            return this.zzfbd;
        }

        @Hide
        public final float zzaes() {
            return this.zzfbc;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzans()) {
                return new zzban(this);
            }
            return new zzbar(this);
        }
    }

    @Hide
    public static final class zza {
        public static void zzbw(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbx(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

