/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbag;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbej;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbei zzeui = new zzbei("CastSession");
    private final Context zzbky;
    private final Set<Cast.Listener> zzfak = new HashSet<Cast.Listener>();
    private final zzl zzfal;
    private final CastOptions zzezz;
    private final Cast.CastApi zzfam;
    private final zzbag zzfan;
    private final zzbbi zzfao;
    private GoogleApiClient zzfap;
    private RemoteMediaClient zzfaq;
    private CastDevice zzfar;
    private Cast.ApplicationConnectionResult zzfas;

    @Hide
    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzbag zzbag2, zzbbi zzbbi2) {
        super(context, string2, string3);
        this.zzbky = context.getApplicationContext();
        this.zzezz = castOptions;
        this.zzfam = castApi;
        this.zzfan = zzbag2;
        this.zzfao = zzbbi2;
        this.zzfal = zzbae.zza(context, castOptions, this.zzaej(), new zzb(this, null));
    }

    @Override
    protected void onStarting(Bundle bundle) {
        this.zzfar = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void onResuming(Bundle bundle) {
        this.zzfar = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzg(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzg(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzfal.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzfaq;
    }

    public CastDevice getCastDevice() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzfar;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            this.zzfam.requestStatus(this.zzfap);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.getActiveInputState(this.zzfap);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.getStandbyState(this.zzfap);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.getApplicationMetadata(this.zzfap);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.getApplicationStatus(this.zzfap);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            this.zzfam.setVolume(this.zzfap, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.getVolume(this.zzfap);
        }
        return 0.0;
    }

    @Hide
    public final zzbbi zzaed() {
        return this.zzfao;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            this.zzfam.setMute(this.zzfap, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.isMute(this.zzfap);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzfas;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            this.zzfam.setMessageReceivedCallbacks(this.zzfap, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            this.zzfam.removeMessageReceivedCallbacks(this.zzfap, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfap != null) {
            return this.zzfam.sendMessage(this.zzfap, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzfak.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzfak.remove(listener);
        }
    }

    private final void zzg(Bundle bundle) {
        zzd zzd2;
        this.zzfar = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzfar == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzfap != null) {
            this.zzfap.disconnect();
            this.zzfap = null;
        }
        zzeui.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzfar});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzezz;
        CastDevice castDevice = this.zzfar;
        Context context = this.zzbky;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzfap = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zzf(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzfap.connect();
    }

    private final void zzbe(int n) {
        this.zzfao.zzbh(n);
        if (this.zzfap != null) {
            this.zzfap.disconnect();
            this.zzfap = null;
        }
        this.zzfar = null;
        if (this.zzfaq != null) {
            this.zzfaq.zzc(null);
            this.zzfaq = null;
        }
        this.zzfas = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (this.zzfaq == null) {
            return 0L;
        }
        return this.zzfaq.getStreamDuration() - this.zzfaq.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzfau;

        private zzb(CastSession castSession) {
            this.zzfau = castSession;
        }

        @Override
        public final int zzadx() {
            return 12211278;
        }

        @Override
        public final void zzq(String string2, String string3) {
            if (this.zzfau.zzfap != null) {
                this.zzfau.zzfam.joinApplication(this.zzfau.zzfap, string2, string3).setResultCallback((ResultCallback)new zza(this.zzfau, "joinApplication"));
            }
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            if (this.zzfau.zzfap != null) {
                this.zzfau.zzfam.launchApplication(this.zzfau.zzfap, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzfau, "launchApplication"));
            }
        }

        @Override
        public final void zzfp(String string2) {
            if (this.zzfau.zzfap != null) {
                this.zzfau.zzfam.stopApplication(this.zzfau.zzfap, string2);
            }
        }

        @Override
        public final void zzbe(int n) {
            this.zzfau.zzbe(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzfat;
        private /* synthetic */ CastSession zzfau;

        zza(CastSession castSession, String string2) {
            this.zzfau = castSession;
            this.zzfat = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzfau.zzfas = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzeui.zzb("%s() -> success result", new Object[]{zza2.zzfat});
                    zza2.zzfau.zzfaq = new RemoteMediaClient(new zzbej(null, com.google.android.gms.common.util.zzi.zzanq()), zza2.zzfau.zzfam);
                    try {
                        zza2.zzfau.zzfaq.zzc(zza2.zzfau.zzfap);
                        zza2.zzfau.zzfaq.zzafl();
                        zza2.zzfau.zzfaq.requestStatus();
                        zza2.zzfau.zzfao.zza(zza2.zzfau.zzfaq, zza2.zzfau.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzeui.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzfau.zzfaq = null;
                    }
                    zza2.zzfau.zzfal.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzeui.zzb("%s() -> failure result", new Object[]{zza2.zzfat});
                zza2.zzfau.zzfal.zzbf(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzfau;

        private zzc(CastSession castSession) {
            this.zzfau = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzfau.zzbe(n);
            this.zzfau.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzfau.zzfak).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzfau;

        private zzd(CastSession castSession) {
            this.zzfau = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzfau.zzfaq != null) {
                    try {
                        this.zzfau.zzfaq.zzafl();
                        this.zzfau.zzfaq.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzeui.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzfau.zzfaq = null;
                    }
                }
                this.zzfau.zzfal.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzfau.zzfal.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzfau.zzfal.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

