/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastButtonFactory;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbaf;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbdj;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbih;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CastContext {
    private static final zzbei zzeui = new zzbei("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzezt;
    private final Context zzbky;
    private final zzj zzezu;
    private final SessionManager zzezv;
    private final zze zzezw;
    private final PrecacheManager zzezx;
    private final MediaNotificationManager zzezy;
    private final CastOptions zzezz;
    private zzbaw zzfaa;
    private zzbaf zzfab;
    private final List<SessionProvider> zzfac;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (zzezt == null) {
            OptionsProvider optionsProvider = CastContext.zzbv(context.getApplicationContext());
            zzezt = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzezt;
    }

    @Hide
    @Nullable
    public static CastContext zzbu(@NonNull Context context) throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        try {
            return CastContext.getSharedInstance(context);
        }
        catch (RuntimeException runtimeException) {
            zzeui.zzc("Failed to load module from Google Play services. Cast will not work properly. Might due to outdated Google Play services. Ignoring this failure silently.", new Object[]{runtimeException});
            return null;
        }
    }

    private static OptionsProvider zzbv(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbih.zzdd((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzeui.zzc("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        PrecacheManager precacheManager;
        this.zzbky = context.getApplicationContext();
        this.zzezz = castOptions;
        this.zzfaa = new zzbaw(MediaRouter.getInstance((Context)this.zzbky));
        this.zzfac = list;
        this.zzaea();
        Map<String, IBinder> map = this.zzadz();
        this.zzezu = zzbae.zza(this.zzbky, castOptions, this.zzfaa, map);
        zzp zzp2 = null;
        try {
            zzp2 = this.zzezu.zzaeh();
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzezw = zzp2 == null ? null : new zze(zzp2);
        zzv zzv2 = null;
        try {
            zzv2 = this.zzezu.zzaeg();
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzezv = zzv2 == null ? null : new SessionManager(zzv2, this.zzbky);
        this.zzezy = new MediaNotificationManager(this.zzezv);
        if (this.zzezv == null) {
            precacheManager = null;
        } else {
            Context context2 = this.zzbky;
            PrecacheManager precacheManager2 = new PrecacheManager(this.zzezz, this.zzezv, new zzbdj(context2));
            precacheManager = precacheManager2;
        }
        this.zzezx = precacheManager;
    }

    private final Map<String, IBinder> zzadz() {
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        if (this.zzfab != null) {
            hashMap.put(this.zzfab.getCategory(), this.zzfab.zzaet());
        }
        if (this.zzfac != null) {
            for (SessionProvider sessionProvider : this.zzfac) {
                zzbq.checkNotNull((Object)sessionProvider, (Object)"Additional SessionProvider must not be null.");
                String string2 = zzbq.zzh((String)sessionProvider.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbq.checkArgument((!hashMap.containsKey(string2) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string2));
                hashMap.put(string2, sessionProvider.zzaet());
            }
        }
        return hashMap;
    }

    private final void zzaea() {
        if (!TextUtils.isEmpty((CharSequence)this.zzezz.getReceiverApplicationId())) {
            this.zzfab = new zzbaf(this.zzbky, this.zzezz, this.zzfaa);
            return;
        }
        this.zzfab = null;
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezz;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezv;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzezu.zzaef());
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezv.getCastState();
    }

    public final PrecacheManager getPrecacheManager() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezx;
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        try {
            return this.zzezu.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezy;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)appVisibilityListener);
        try {
            this.zzezu.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzezu.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)castStateListener);
        this.zzezv.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzezv.removeCastStateListener(castStateListener);
    }

    public final void setReceiverApplicationId(String string2) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (TextUtils.equals((CharSequence)string2, (CharSequence)this.zzezz.getReceiverApplicationId())) {
            return;
        }
        this.zzezz.setReceiverApplicationId(string2);
        this.zzaea();
        Map<String, IBinder> map = this.zzadz();
        try {
            this.zzezu.zzd(string2, map);
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"setReceiverApplicationId", zzj.class.getSimpleName()});
        }
        CastButtonFactory.zzbt(this.zzbky);
    }

    @Hide
    public final zze zzaeb() {
        zzbq.zzgn((String)"Must be called from the main thread.");
        return this.zzezw;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (zzs.zzans()) {
            return false;
        }
        CastSession castSession = this.zzezv.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzeui.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    @Hide
    public final IObjectWrapper zzaec() {
        try {
            return this.zzezu.zzaei();
        }
        catch (RemoteException remoteException) {
            zzeui.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

