/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.MediaRouteActionProvider;
import android.support.v7.app.MediaRouteButton;
import android.support.v7.app.MediaRouteDialogFactory;
import android.view.Menu;
import android.view.MenuItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbei;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CastButtonFactory {
    private static final zzbei zzeus = new zzbei("CastButtonFactory");
    private static final List<WeakReference<MenuItem>> zzezr = new ArrayList<WeakReference<MenuItem>>();
    private static final List<WeakReference<MediaRouteButton>> zzezs = new ArrayList<WeakReference<MediaRouteButton>>();

    private CastButtonFactory() {
    }

    public static MenuItem setUpMediaRouteButton(Context context, Menu menu, int n) {
        return CastButtonFactory.zza(context, menu, n, null);
    }

    @Hide
    private static MenuItem zza(Context context, Menu menu, int n, MediaRouteDialogFactory mediaRouteDialogFactory) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        zzbq.checkNotNull((Object)menu);
        MenuItem menuItem = menu.findItem(n);
        if (menuItem == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "menu doesn't contain a menu item whose ID is %d.", n));
        }
        try {
            CastButtonFactory.zza(context, menuItem, null);
            zzezr.add(new WeakReference<MenuItem>(menuItem));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "menu item with ID %d doesn't have a MediaRouteActionProvider.", n));
        }
        return menuItem;
    }

    public static void setUpMediaRouteButton(Context context, MediaRouteButton mediaRouteButton) {
        MediaRouteButton mediaRouteButton2 = mediaRouteButton;
        Context context2 = context;
        zzbq.zzgn((String)"Must be called from the main thread.");
        if (mediaRouteButton2 != null) {
            CastButtonFactory.zza(context2, mediaRouteButton2, null);
            zzezs.add(new WeakReference<MediaRouteButton>(mediaRouteButton2));
        }
    }

    @Hide
    public static void zzbt(Context context) {
        for (WeakReference<MenuItem> weakReference : zzezr) {
            try {
                if (weakReference.get() == null) continue;
                CastButtonFactory.zza(context, (MenuItem)weakReference.get(), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzeus.zzf("Unexpected exception when refreshing MediaRouteSelectors for Cast buttons", new Object[]{illegalArgumentException});
            }
        }
        for (WeakReference<MenuItem> weakReference : zzezs) {
            if (weakReference.get() == null) continue;
            CastButtonFactory.zza(context, (MediaRouteButton)weakReference.get(), null);
        }
    }

    private static void zza(Context context, @NonNull MenuItem menuItem, MediaRouteDialogFactory mediaRouteDialogFactory) throws IllegalArgumentException {
        zzbq.zzgn((String)"Must be called from the main thread.");
        MediaRouteActionProvider mediaRouteActionProvider = (MediaRouteActionProvider)MenuItemCompat.getActionProvider((MenuItem)menuItem);
        if (mediaRouteActionProvider == null) {
            throw new IllegalArgumentException();
        }
        CastContext castContext = CastContext.zzbu(context);
        if (castContext != null) {
            mediaRouteActionProvider.setRouteSelector(castContext.getMergedSelector());
        }
    }

    private static void zza(Context context, @NonNull MediaRouteButton mediaRouteButton, MediaRouteDialogFactory mediaRouteDialogFactory) {
        zzbq.zzgn((String)"Must be called from the main thread.");
        CastContext castContext = CastContext.zzbu(context);
        if (castContext != null) {
            mediaRouteButton.setRouteSelector(castContext.getMergedSelector());
        }
    }
}

