/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaow;
import com.google.android.gms.internal.zzaox;
import com.google.android.gms.internal.zzaoy;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzape;
import com.google.android.gms.internal.zzapf;
import com.google.android.gms.internal.zzapg;
import com.google.android.gms.internal.zzaph;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzaon
implements zzaox<Date>,
zzapg<Date> {
    private final DateFormat bnQ;
    private final DateFormat bnR;
    private final DateFormat bnS;

    zzaon() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzaon(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    public zzaon(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzaon(DateFormat dateFormat, DateFormat dateFormat2) {
        this.bnQ = dateFormat;
        this.bnR = dateFormat2;
        this.bnS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.bnS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzaoy zza(Date date, Type type, zzapf zzapf2) {
        DateFormat dateFormat = this.bnR;
        synchronized (dateFormat) {
            String string2 = this.bnQ.format(date);
            return new zzape(string2);
        }
    }

    public Date zza(zzaoy zzaoy2, Type type, zzaow zzaow2) throws zzapc {
        if (!(zzaoy2 instanceof zzape)) {
            throw new zzapc("The date should be a string value");
        }
        Date date = this.zza(zzaoy2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string2 = String.valueOf(this.getClass());
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" cannot deserialize to ").append(string3).toString());
    }

    private Date zza(zzaoy zzaoy2) {
        DateFormat dateFormat = this.bnR;
        synchronized (dateFormat) {
            try {
                return this.bnR.parse(zzaoy2.aU());
            }
            catch (ParseException parseException) {
                try {
                    return this.bnQ.parse(zzaoy2.aU());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.bnS.parse(zzaoy2.aU());
                    }
                    catch (ParseException parseException3) {
                        throw new zzaph(zzaoy2.aU(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzaon.class.getSimpleName());
        stringBuilder.append('(').append(this.bnR.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzaoy zzaoy2, Type type, zzaow zzaow2) throws zzapc {
        return this.zza(zzaoy2, type, zzaow2);
    }
}

