/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzd<T extends IInterface> {
    private int xb;
    private long xc;
    private long xd;
    private int xe;
    private long xf;
    private final Context mContext;
    private final Looper zzahv;
    private final zzm xg;
    private final com.google.android.gms.common.zzc tp;
    final Handler mHandler;
    private final Object zzail = new Object();
    private final Object xh = new Object();
    private zzu xi;
    private zzf xj;
    private T xk;
    private final ArrayList<zze<?>> xl = new ArrayList();
    private zzh xm;
    private int xn = 1;
    private final zzb xo;
    private final zzc xp;
    private final int xq;
    private final String xr;
    protected AtomicInteger xs = new AtomicInteger(0);
    public static final String[] xt = new String[]{"service_esmobile", "service_googleme"};

    protected zzd(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzm.zzce(context), com.google.android.gms.common.zzc.zzand(), n, zzab.zzaa(zzb2), zzab.zzaa(zzc2), string2);
    }

    protected zzd(Context context, Looper looper, zzm zzm2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzab.zzb(context, (Object)"Context must not be null");
        this.zzahv = zzab.zzb(looper, (Object)"Looper must not be null");
        this.xg = zzab.zzb(zzm2, (Object)"Supervisor must not be null");
        this.tp = zzab.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.xq = n;
        this.xo = zzb2;
        this.xp = zzc3;
        this.xr = string2;
    }

    @NonNull
    protected abstract String zzra();

    protected String zzarp() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzrb();

    @Nullable
    protected final String zzarq() {
        return this.xr == null ? this.mContext.getClass().getName() : this.xr;
    }

    @Nullable
    protected abstract T zzbb(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.xd = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.xb = n;
        this.xc = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.xe = connectionResult.getErrorCode();
        this.xf = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzab.zzbn(n == 3 == (t != null));
        Object object = this.zzail;
        synchronized (object) {
            this.xn = n;
            this.xk = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzarr();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzars();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzarr() {
        String string2;
        if (this.xm != null) {
            String string3 = String.valueOf(this.zzra());
            string2 = String.valueOf(this.zzarp());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.xg.zzb(this.zzra(), this.zzarp(), this.xm, this.zzarq());
            this.xs.incrementAndGet();
        }
        this.xm = new zzh(this.xs.get());
        boolean bl = this.xg.zza(this.zzra(), this.zzarp(), this.xm, this.zzarq());
        if (!bl) {
            string2 = String.valueOf(this.zzra());
            String string4 = String.valueOf(this.zzarp());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.xs.get());
        }
    }

    private void zzars() {
        if (this.xm != null) {
            this.xg.zzb(this.zzra(), this.zzarp(), this.xm, this.zzarq());
            this.xm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.xn != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzart() {
        int n = this.tp.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.xj = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.xs.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.xj = zzab.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzail;
        synchronized (object) {
            return this.xn == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzail;
        synchronized (object) {
            return this.xn == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.xs.incrementAndGet();
        Object object = this.xl;
        synchronized (object) {
            int n = this.xl.size();
            for (int i = 0; i < n; ++i) {
                this.xl.get(i).zzasc();
            }
            this.xl.clear();
        }
        object = this.xh;
        synchronized (object) {
            this.xi = null;
        }
        this.zzb(1, null);
    }

    public void zzfy(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.xs.get(), n));
    }

    public void zza(zzf zzf2, ConnectionResult connectionResult) {
        this.xj = zzab.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.xs.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzahv;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zzaru() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzaeu() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzarv() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzamc() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzarw() throws DeadObjectException {
        Object object = this.zzail;
        synchronized (object) {
            if (this.xn == 4) {
                throw new DeadObjectException();
            }
            this.zzarv();
            zzab.zza(this.xk != null, (Object)"Client is connected but service is null");
            return this.xk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzq zzq2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzaeu();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.xq).zzhm(this.mContext.getPackageName()).zzn(bundle);
            if (set != null) {
                getServiceRequest.zzf(set);
            }
            if (this.zzafk()) {
                getServiceRequest.zzd(this.zzaru()).zzb(zzq2);
            } else if (this.zzarx()) {
                getServiceRequest.zzd(this.getAccount());
            }
            Object object = this.xh;
            synchronized (object) {
                if (this.xi != null) {
                    this.xi.zza((zzt)new zzg(this, this.xs.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzfy(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    public boolean zzafk() {
        return false;
    }

    public boolean zzarx() {
        return false;
    }

    public boolean zzanr() {
        return true;
    }

    public boolean zzafz() {
        return false;
    }

    public Intent zzaga() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzary() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzail;
        synchronized (object) {
            n = this.xn;
            t = this.xk;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zzrb()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.xd > 0L) {
            l = this.xd;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xd)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.xc > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.xb) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.xb));
                }
            }
            l = this.xc;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xc)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.xf > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.xe));
            l = this.xf;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.xf)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzans() {
        Object object = this.xh;
        synchronized (object) {
            if (this.xi == null) {
                return null;
            }
            return this.xi.asBinder();
        }
    }

    public static final class zzg
    extends zzt.zza {
        private zzd xx;
        private final int xy;

        public zzg(@NonNull zzd zzd2, int n) {
            this.xx = zzd2;
            this.xy = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzab.zzb(this.xx, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.xx.zza(n, iBinder, bundle, this.xy);
            this.zzasd();
        }

        private void zzasd() {
            this.xx = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle xu;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.xu = bundle;
        }

        protected abstract boolean zzarz();

        protected abstract void zzl(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzd.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzarz()) break;
                    zzd.this.zzb(1, null);
                    this.zzl(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzd.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzd.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.xu != null) {
                        pendingIntent = (PendingIntent)this.xu.getParcelable("pendingIntent");
                    }
                    this.zzl(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzasa() {
        }

        @Override
        protected /* synthetic */ void zzx(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder xz;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.xz = iBinder;
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            if (zzd.this.xp != null) {
                zzd.this.xp.onConnectionFailed(connectionResult);
            }
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzarz() {
            String string2;
            try {
                string2 = this.xz.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzd.this.zzrb().equals(string2)) {
                String string3 = String.valueOf(zzd.this.zzrb());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zzd.this.zzbb(this.xz);
            if (t != null && zzd.this.zza(2, 3, t)) {
                Bundle bundle = zzd.this.zzamc();
                if (zzd.this.xo != null) {
                    zzd.this.xo.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzl(ConnectionResult connectionResult) {
            zzd.this.xj.zzh(connectionResult);
            zzd.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzarz() {
            zzd.this.xj.zzh(ConnectionResult.qR);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzh(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzd.this.zza(null, zzd.this.zzary());
            } else if (zzd.this.xp != null) {
                zzd.this.xp.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean xw;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.xw = false;
        }

        protected abstract void zzx(TListener var1);

        protected abstract void zzasa();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzasb() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.xw) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zzx(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzasa();
                    throw runtimeException;
                }
            } else {
                this.zzasa();
            }
            zze2 = this;
            synchronized (zze2) {
                this.xw = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzasc();
            ArrayList arrayList = zzd.this.xl;
            synchronized (arrayList) {
                zzd.this.xl.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzasc() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zzd.this.xs.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zzd.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zzd.this.xj.zzh(connectionResult);
                zzd.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zzd.this.zzb(4, null);
                if (zzd.this.xo != null) {
                    zzd.this.xo.onConnectionSuspended(message.arg2);
                }
                zzd.this.onConnectionSuspended(message.arg2);
                zzd.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zzd.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzasb();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.zzasa();
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzh(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int xy;

        public zzh(int n) {
            this.xy = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzab.zzb(iBinder, (Object)"Expecting a valid IBinder");
            Object object = zzd.this.xh;
            synchronized (object) {
                zzd.this.xi = zzu.zza.zzdt(iBinder);
            }
            zzd.this.zza(0, null, this.xy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zzd.this.xh;
            synchronized (object) {
                zzd.this.xi = null;
            }
            zzd.this.mHandler.sendMessage(zzd.this.mHandler.obtainMessage(4, this.xy, 1));
        }
    }
}

