/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.common.util.zzt;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class zzb {
    private static final Object zzarP = new Object();
    private static zzb zzatn;
    private final List<String> zzato;
    private final List<String> zzatp;
    private final List<String> zzatq;
    private final List<String> zzatr;
    private zze zzats;
    private static Integer zzatt;
    private zze zzatu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzuH() {
        Object object = zzarP;
        synchronized (object) {
            if (zzatn == null) {
                zzatn = new zzb();
            }
        }
        return zzatn;
    }

    private zzb() {
        if (zzb.getLogLevel() == zzd.LOG_LEVEL_OFF) {
            this.zzato = Collections.EMPTY_LIST;
            this.zzatp = Collections.EMPTY_LIST;
            this.zzatq = Collections.EMPTY_LIST;
            this.zzatr = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzaty.get();
        this.zzato = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzatz.get();
        this.zzatp = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzatA.get();
        this.zzatq = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzatB.get();
        this.zzatr = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzats = new zze(1024, zzc.zza.zzatC.get());
        this.zzatu = new zze(1024, zzc.zza.zzatC.get());
    }

    private boolean zzc(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            return false;
        }
        return com.google.android.gms.common.util.zzd.zzm(context, componentName.getPackageName());
    }

    @SuppressLint(value={"UntrackedBindService"})
    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zzc(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        boolean bl = context.bindService(intent, serviceConnection, n);
        if (bl) {
            this.zza(context, this.zzb(serviceConnection), string2, intent, 2);
        }
        return bl;
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    @SuppressLint(value={"UntrackedBindService"})
    public void zza(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 1);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, this.zzb(serviceConnection), string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 4);
    }

    private void zza(Context context, String string2, String string3, Intent intent, int n) {
        String string4;
        String string5;
        String string6;
        if (!this.zzuI() || this.zzats == null) {
            return;
        }
        if (n == 4 || n == 1) {
            if (!this.zzats.zzds(string2)) {
                return;
            }
            string6 = null;
            string5 = null;
            string4 = null;
        } else {
            ServiceInfo serviceInfo = zzb.zzd(context, intent);
            if (serviceInfo == null) {
                Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string3, intent.toUri(0)));
                return;
            }
            string6 = serviceInfo.processName;
            string5 = serviceInfo.name;
            string4 = zzt.zzvi();
            if (!this.zzb(string4, string3, string6, string5)) {
                return;
            }
            this.zzats.zzdr(string2);
        }
        this.zza(context, string2, n, string4, string3, string6, string5);
    }

    private void zza(Context context, String string2, int n, String string3, String string4, String string5, String string6) {
        long l = System.currentTimeMillis();
        String string7 = null;
        if ((zzb.getLogLevel() & zzd.zzatH) != 0 && n != 13) {
            string7 = zzb.zzn(3, 5);
        }
        long l2 = 0L;
        if ((zzb.getLogLevel() & zzd.zzatJ) != 0) {
            l2 = Debug.getNativeHeapAllocatedSize();
        }
        ConnectionEvent connectionEvent = n == 1 || n == 4 || n == 14 ? new ConnectionEvent(l, n, null, null, null, null, string7, string2, SystemClock.elapsedRealtime(), l2) : new ConnectionEvent(l, n, string3, string4, string5, string6, string7, string2, SystemClock.elapsedRealtime(), l2);
        context.startService(new Intent().setComponent(zzd.zzatD).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zzuI() {
        if (!false) {
            return false;
        }
        int n = zzb.getLogLevel();
        return n != zzd.LOG_LEVEL_OFF;
    }

    private boolean zzb(String string2, String string3, String string4, String string5) {
        int n = zzb.getLogLevel();
        return !this.zzato.contains(string2) && !this.zzatp.contains(string3) && !this.zzatq.contains(string4) && !this.zzatr.contains(string5) && (!string4.equals(string2) || (n & zzd.zzatI) == 0);
    }

    private static ServiceInfo zzd(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzb.zzn(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzb.zzn(3, 20)));
            for (ResolveInfo resolveInfo : list) {
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
            }
            return null;
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection));
    }

    private static int getLogLevel() {
        if (zzatt == null) {
            try {
                zzatt = com.google.android.gms.common.util.zzd.zzmW() ? zzc.zza.zzatx.get() : zzd.LOG_LEVEL_OFF;
            }
            catch (SecurityException securityException) {
                zzatt = zzd.LOG_LEVEL_OFF;
            }
        }
        return zzatt;
    }

    private static String zzn(int n, int n2) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        n2 += n;
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(zzb.zza(stackTraceElementArray, i)).append(" ");
        }
        return stringBuffer.toString();
    }

    private static String zza(StackTraceElement[] stackTraceElementArray, int n) {
        if (4 + n >= stackTraceElementArray.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement stackTraceElement = stackTraceElementArray[4 + n];
        String string2 = String.valueOf(stackTraceElement.getClassName());
        String string3 = String.valueOf(stackTraceElement.getMethodName());
        int n2 = stackTraceElement.getLineNumber();
        return new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(".").append(string3).append(":").append(n2).toString();
    }
}

