/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzad;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzmp;
import com.google.android.gms.internal.zzmr;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzaez = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        Set<GoogleApiClient> set = zzaez;
        synchronized (set) {
            int n = 0;
            String string2 = prefix + "  ";
            for (GoogleApiClient googleApiClient : zzaez) {
                writer.append(prefix).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string2, fd, writer, args);
            }
        }
    }

    public static Set<GoogleApiClient> zzoE() {
        return zzaez;
    }

    public <A extends Api.zzb, R extends Result, T extends zzlx.zza<R, A>> T zza(T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzlx.zza<? extends Result, A>> T zzb(T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzmn<L> zzq(L l) {
        throw new UnsupportedOperationException();
    }

    public <C extends Api.zzb> C zza(Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(Api<?> var1);

    public abstract ConnectionResult getConnectionResult(Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzmp zzmp2) {
        throw new UnsupportedOperationException();
    }

    public void zzoF() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int signInMode) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public static final class Builder {
        private Account zzSo;
        private final Set<Scope> zzaeA = new HashSet<Scope>();
        private final Set<Scope> zzaeB = new HashSet<Scope>();
        private int zzaeC;
        private View zzaeD;
        private String zzTz;
        private String zzaeE;
        private final Map<Api<?>, zzf.zza> zzaeF = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzaeG = new ArrayMap();
        private FragmentActivity zzaeH;
        private int zzaeI = -1;
        private OnConnectionFailedListener zzaeJ;
        private Looper zzaeK;
        private GoogleApiAvailability zzaeL = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzsc, zzsd> zzaeM = zzsa.zzTp;
        private final ArrayList<ConnectionCallbacks> zzaeN = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzaeO = new ArrayList();
        private zzsd zzaeP;

        public Builder(Context context) {
            this.mContext = context;
            this.zzaeK = context.getMainLooper();
            this.zzTz = context.getPackageName();
            this.zzaeE = context.getClass().getName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzx.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzaeN.add(connectedListener);
            zzx.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzaeO.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzx.zzb(handler, (Object)"Handler must not be null");
            this.zzaeK = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzaeN.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzaeO.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            zzx.zzb(viewForPopups, (Object)"View must not be null");
            this.zzaeD = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            zzx.zzb(scope, (Object)"Scope must not be null");
            this.zzaeA.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzx.zzb(api, (Object)"Api must not be null");
            this.zzaeG.put(api, null);
            List<Scope> list = api.zzoy().zzn(null);
            this.zzaeB.addAll(list);
            this.zzaeA.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            zzx.zzb(api, (Object)"Api must not be null");
            this.zzaeG.put(api, null);
            this.zza(api, null, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzx.zzb(api, (Object)"Api must not be null");
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzaeG.put(api, options);
            List<Scope> list = api.zzoy().zzn(options);
            this.zzaeB.addAll(list);
            this.zzaeA.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(Api<O> api, O options, Scope ... scopes) {
            zzx.zzb(api, (Object)"Api must not be null");
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzaeG.put(api, options);
            this.zza(api, options, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzSo = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzaeC = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzx.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzaeI = clientId;
            this.zzaeH = zzx.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzaeJ = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, unresolvedConnectionFailedListener);
        }

        @Deprecated
        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzaeP = new zzsd.zza().zza(serverClientId, callbacks).zzDQ();
            return this;
        }

        public zzf zzoH() {
            if (this.zzaeG.containsKey(zzsa.API)) {
                zzx.zza(this.zzaeP == null, (Object)"SignIn.API can't be used in conjunction with requestServerAuthCode.");
                this.zzaeP = (zzsd)this.zzaeG.get(zzsa.API);
            }
            return new zzf(this.zzSo, this.zzaeA, this.zzaeF, this.zzaeC, this.zzaeD, this.zzTz, this.zzaeE, this.zzaeP != null ? this.zzaeP : zzsd.zzbbH);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            zzx.zzb(!this.zzaeG.isEmpty(), (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzoI();
            Set set = zzaez;
            synchronized (set) {
                zzaez.add(googleApiClient);
            }
            if (this.zzaeI >= 0) {
                this.zzd(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzoI() {
            zzf zzf2 = this.zzoH();
            Api<?> api = null;
            Api<?> api2 = null;
            Map<Api<?>, zzf.zza> map = zzf2.zzqc();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzlz> arrayList = new ArrayList<zzlz>();
            for (Api<?> api3 : this.zzaeG.keySet()) {
                zzad<Object> zzad2;
                Object object;
                Api.ApiOptions apiOptions = this.zzaeG.get(api3);
                int n = 0;
                if (map.get(api3) != null) {
                    n = map.get(api3).zzaju ? 1 : 2;
                }
                arrayMap.put(api3, n);
                zzlz zzlz2 = new zzlz(api3, n);
                arrayList.add(zzlz2);
                if (api3.zzoB()) {
                    object = api3.zzoz();
                    if (object.getPriority() == 1) {
                        api2 = api3;
                    }
                    zzad2 = Builder.zza(object, (Object)apiOptions, this.mContext, this.zzaeK, zzf2, (ConnectionCallbacks)zzlz2, (OnConnectionFailedListener)zzlz2);
                } else {
                    object = api3.zzoy();
                    if (((Api.zza)object).getPriority() == 1) {
                        api2 = api3;
                    }
                    zzad2 = Builder.zza(object, (Object)apiOptions, this.mContext, this.zzaeK, zzf2, (ConnectionCallbacks)zzlz2, (OnConnectionFailedListener)zzlz2);
                }
                arrayMap2.put(api3.zzoA(), zzad2);
                if (!zzad2.zzmJ()) continue;
                if (api != null) {
                    throw new IllegalStateException(api3.getName() + " cannot be used with " + api.getName());
                }
                api = api3;
            }
            if (api != null) {
                if (api2 != null) {
                    throw new IllegalStateException(api.getName() + " cannot be used with " + api2.getName());
                }
                zzx.zza(this.zzSo == null, "Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", api.getName());
                zzx.zza(this.zzaeA.equals(this.zzaeB), "Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", api.getName());
                zzx.zza(this.zzaeP == null, "Must not call requestServerAuthCode in GoogleApiClient.Builder when using %s. Call requestServerAuthCode in GoogleSignInOptions.Builder instead.", api.getName());
            }
            int n = zzmg.zza(arrayMap2.values(), true);
            return new zzmg(this.mContext, new ReentrantLock(), this.zzaeK, zzf2, this.zzaeL, this.zzaeM, (Map<Api<?>, Integer>)arrayMap, (List<ConnectionCallbacks>)this.zzaeN, (List<OnConnectionFailedListener>)this.zzaeO, (Map<Api.zzc<?>, Api.zzb>)arrayMap2, this.zzaeI, n, arrayList);
        }

        private void zzd(final GoogleApiClient googleApiClient) {
            zzmr zzmr2 = zzmr.zza(this.zzaeH);
            if (zzmr2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Builder.this.zzaeH.isFinishing() || Builder.this.zzaeH.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        Builder.this.zza(zzmr.zzb(Builder.this.zzaeH), googleApiClient);
                    }
                });
            } else {
                this.zza(zzmr2, googleApiClient);
            }
        }

        private void zza(zzmr zzmr2, GoogleApiClient googleApiClient) {
            zzmr2.zza(this.zzaeI, googleApiClient, this.zzaeJ);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzoy().zzn(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzaeF.put(api, new zzf.zza(hashSet, bl));
        }

        private static <C extends Api.zzb, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
        }

        private static <C extends Api.zzd, O> zzad zza(Api.zze<C, O> zze2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return new zzad(context, looper, zze2.zzoD(), connectionCallbacks, onConnectionFailedListener, zzf2, (Api.zzd)zze2.zzp(object));
        }
    }

    public static interface zza {
        public void zza(ConnectionResult var1);

        public void zzb(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzaeR;
            private Set<Scope> zzVH;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzx.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzaeR = requiresNewAuthCode;
                this.zzVH = requiredScopes;
            }

            public boolean zzoJ() {
                return this.zzaeR;
            }

            public Set<Scope> zzoK() {
                return this.zzVH;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

