/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zzno;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
implements SafeParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzc();
    public static zznl zzVs = zzno.zzrM();
    final int versionCode;
    private String zzxX;
    private String zzUN;
    private String zzVt;
    private String zzVu;
    private Uri zzVv;
    private String zzVw;
    private long zzVx;
    private String zzVy;
    List<Scope> zzTV;
    private static Comparator<Scope> zzVz = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzoM().compareTo(scope2.zzoM());
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.zza((Scope)x0, (Scope)x1);
        }
    };

    public static GoogleSignInAccount zzbE(String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzbF(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(String string2, String string3, String string4, String string5, Uri uri, Long l, String string6, Set<Scope> set) {
        if (l == null) {
            l = zzVs.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(2, string2, string3, string4, string5, uri, null, l, zzx.zzcG(string6), new ArrayList<Scope>((Collection)zzx.zzy(set)));
    }

    GoogleSignInAccount(int versionCode, String id, String idToken, String email, String displayName, Uri photoUrl, String serverAuthCode, long expirationTimeSecs, String obfuscatedIdentifier, List<Scope> grantedScopes) {
        this.versionCode = versionCode;
        this.zzxX = id;
        this.zzUN = idToken;
        this.zzVt = email;
        this.zzVu = displayName;
        this.zzVv = photoUrl;
        this.zzVw = serverAuthCode;
        this.zzVx = expirationTimeSecs;
        this.zzVy = obfuscatedIdentifier;
        this.zzTV = grantedScopes;
    }

    public String getId() {
        return this.zzxX;
    }

    public String getIdToken() {
        return this.zzUN;
    }

    public String getEmail() {
        return this.zzVt;
    }

    public String getDisplayName() {
        return this.zzVu;
    }

    public Uri getPhotoUrl() {
        return this.zzVv;
    }

    public GoogleSignInAccount zzbF(String string2) {
        this.zzVw = string2;
        return this;
    }

    public String getServerAuthCode() {
        return this.zzVw;
    }

    public long zzmv() {
        return this.zzVx;
    }

    public boolean zzb() {
        return zzVs.currentTimeMillis() / 1000L >= this.zzVx - 300L;
    }

    public String zzmw() {
        return this.zzVy;
    }

    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzTV);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)obj;
        return googleSignInAccount.zzmr().equals(this.zzmr());
    }

    public String zzmr() {
        return this.zzms().toString();
    }

    public String zzmx() {
        JSONObject jSONObject = this.zzms();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzms() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzVx);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzmw());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzTV, zzVz);
            for (Scope scope : this.zzTV) {
                jSONArray.put((Object)scope.zzoM());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

