/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.firstparty.shared.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzau;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzTH = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName zzTI = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");

    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope);
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope, extras);
    }

    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, account, scope, new Bundle());
    }

    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zza(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zza(Context context, final Account account, final String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzac(context);
        final Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string3 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string3);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string3);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza<TokenData> zza2 = new zza<TokenData>(){

            public TokenData zzam(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzau zzau2 = zzau.zza.zza(iBinder);
                Bundle bundle = (Bundle)GoogleAuthUtil.zzl(zzau2.zza(account, string2, bundle2));
                TokenData tokenData = TokenData.zza(bundle, "tokenDetails");
                if (tokenData != null) {
                    return tokenData;
                }
                String string22 = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                zzd zzd2 = zzd.zzbT(string22);
                if (zzd.zza(zzd2)) {
                    throw new UserRecoverableAuthException(string22, intent);
                }
                if (zzd.zzc(zzd2)) {
                    throw new IOException(string22);
                }
                throw new GoogleAuthException(string22);
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzam(iBinder);
            }
        };
        return GoogleAuthUtil.zza(context, zzTH, zza2);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, callback);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, authority, syncBundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zzb(Context context, Account account, String string2, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzc(context, account, string2, bundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.zzi(callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzc(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        zzx.zzh(authority, "Authority cannot be empty or null.");
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzc(context, account, scope, extras);
        return tokenData.getToken();
    }

    @Deprecated
    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    public static void clearToken(Context context, final String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzac(context);
        final Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zza<Void> zza2 = new zza<Void>(){

            public Void zzao(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzau zzau2 = zzau.zza.zza(iBinder);
                Bundle bundle2 = (Bundle)GoogleAuthUtil.zzl(zzau2.zza(token, bundle));
                String string2 = bundle2.getString("Error");
                if (!bundle2.getBoolean("booleanResult")) {
                    throw new GoogleAuthException(string2);
                }
                return null;
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzao(iBinder);
            }
        };
        GoogleAuthUtil.zza(context, zzTH, zza2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, final int eventIndex, final String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzac(context);
        zza<List<AccountChangeEvent>> zza2 = new zza<List<AccountChangeEvent>>(){

            public List<AccountChangeEvent> zzap(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzau zzau2 = zzau.zza.zza(iBinder);
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(accountName).setEventIndex(eventIndex);
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)GoogleAuthUtil.zzl(zzau2.zza(accountChangeEventsRequest));
                return accountChangeEventsResponse.getEvents();
            }

            @Override
            public /* synthetic */ Object zzan(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzap(iBinder);
            }
        };
        return GoogleAuthUtil.zza(context, zzTH, zza2);
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcy("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzac(ctx);
        return GoogleAuthUtil.getToken(ctx, accountName, "^^_account_id_^^", new Bundle());
    }

    private static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string2 = intent.toUri(1);
        try {
            Intent.parseUri((String)string2, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static TokenData zzc(Context context, Account account, String string2, Bundle bundle) throws IOException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            TokenData tokenData = GoogleAuthUtil.zza(context, account, string2, bundle);
            GooglePlayServicesUtil.zzaj(context);
            return tokenData;
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            GooglePlayServicesUtil.showErrorNotification(n, context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.zzaj(context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static void zzac(Context context) throws GoogleAuthException {
        try {
            GooglePlayServicesUtil.zzac(context.getApplicationContext());
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzl(T t) throws IOException {
        if (t == null) {
            Log.w((String)"GoogleAuthUtil", (String)"Binder call returned null.");
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zza<T> zza2) throws IOException, GoogleAuthException {
        com.google.android.gms.common.zza zza3 = new com.google.android.gms.common.zza();
        zzl zzl2 = zzl.zzat(context);
        if (zzl2.zza(componentName, (ServiceConnection)zza3, "GoogleAuthUtil")) {
            try {
                T t = zza2.zzan(zza3.zzor());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)throwable);
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzl2.zzb(componentName, (ServiceConnection)zza3, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    private GoogleAuthUtil() {
    }

    private static interface zza<T> {
        public T zzan(IBinder var1) throws RemoteException, IOException, GoogleAuthException;
    }
}

