/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@KeepForSdk
public class BlockingServiceConnection
implements ServiceConnection {
    boolean zza = false;
    private final BlockingQueue zzb = new LinkedBlockingQueue();

    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public IBinder getService() throws InterruptedException {
        Preconditions.checkNotMainThread("BlockingServiceConnection.getService() called on main thread");
        if (this.zza) {
            throw new IllegalStateException("Cannot call get on this connection more than once");
        }
        this.zza = true;
        return (IBinder)this.zzb.take();
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public IBinder getServiceWithTimeout(long timeout, @NonNull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        void var3_2;
        void var1_1;
        Preconditions.checkNotMainThread("BlockingServiceConnection.getServiceWithTimeout() called on main thread");
        if (blockingServiceConnection.zza) {
            throw new IllegalStateException("Cannot call get on this connection more than once");
        }
        blockingServiceConnection.zza = true;
        BlockingServiceConnection blockingServiceConnection = (IBinder)blockingServiceConnection.zzb.poll((long)var1_1, (TimeUnit)var3_2);
        if (blockingServiceConnection == null) {
            throw new TimeoutException("Timed out waiting for the service connection");
        }
        return blockingServiceConnection;
    }

    public final void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
        this.zzb.add(iBinder);
    }

    public final void onServiceDisconnected(@NonNull ComponentName componentName) {
    }
}

