/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.wrappers;

import android.annotation.TargetApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.core.util.Pair;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;

@KeepForSdk
public class PackageManagerWrapper {
    @NonNull
    protected final Context zza;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int checkCallingOrSelfPermission(@NonNull String permission2) {
        void var1_1;
        return this.zza.checkCallingOrSelfPermission((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    public int checkPermission(@NonNull String permission2, @NonNull String packageName) {
        void var2_2;
        void var1_1;
        return this.zza.getPackageManager().checkPermission((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public ApplicationInfo getApplicationInfo(@NonNull String packageName, int flags) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        return this.zza.getPackageManager().getApplicationInfo((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public PackageInfo getPackageInfo(@NonNull String packageName, int flags) throws PackageManager.NameNotFoundException {
        void var2_2;
        void var1_1;
        return this.zza.getPackageManager().getPackageInfo((String)var1_1, (int)var2_2);
    }

    @ResultIgnorabilityUnspecified
    @KeepForSdk
    @NonNull
    public Pair<CharSequence, Drawable> getApplicationLabelAndIcon(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        ApplicationInfo applicationInfo;
        applicationInfo = this.zza.getPackageManager().getApplicationInfo((String)applicationInfo, 0);
        return Pair.create((Object)this.zza.getPackageManager().getApplicationLabel(applicationInfo), (Object)this.zza.getPackageManager().getApplicationIcon(applicationInfo));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public CharSequence getApplicationLabel(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        void var1_1;
        return this.zza.getPackageManager().getApplicationLabel(this.zza.getPackageManager().getApplicationInfo((String)var1_1, 0));
    }

    public PackageManagerWrapper(@NonNull Context context) {
        this.zza = context;
    }

    @KeepForSdk
    public boolean isCallerInstantApp() {
        String string2;
        if (Binder.getCallingUid() == Process.myUid()) {
            return InstantApps.isInstantApp(this.zza);
        }
        if (PlatformVersion.isAtLeastO() && (string2 = this.zza.getPackageManager().getNameForUid(Binder.getCallingUid())) != null) {
            return this.zza.getPackageManager().isInstantApp(string2);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=19)
    public final boolean zza(int n, @NonNull String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            try {
                PackageManagerWrapper packageManagerWrapper = (AppOpsManager)packageManagerWrapper.zza.getSystemService("appops");
                if (packageManagerWrapper == null) {
                    throw new NullPointerException("context.getSystemService(Context.APP_OPS_SERVICE) is null");
                }
                packageManagerWrapper.checkPackage(n, string2);
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        String[] stringArray = packageManagerWrapper.zza.getPackageManager().getPackagesForUid(n);
        if (string2 != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }
}

