/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.zzb;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

@KeepForSdk
public final class Preconditions {
    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static double checkArgumentInRange(double value, double lower, double upper, @NonNull String valueName) {
        double d;
        void var4_2;
        void var6_3;
        void var2_1;
        if (value < var2_1) {
            Object[] objectArray = new Object[]{var6_3, (double)var2_1, (double)var4_2};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%f, %f] (too low)", objectArray));
        }
        if (d > var4_2) {
            Object[] objectArray = new Object[]{var6_3, (double)var2_1, (double)var4_2};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%f, %f] (too high)", objectArray));
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static float checkArgumentInRange(float value, float lower, float upper, @NonNull String valueName) {
        float f;
        void var2_4;
        void var3_5;
        void var1_3;
        if (value < var1_3) {
            Object[] objectArray = new Object[]{var3_5, Float.valueOf((float)var1_3), Float.valueOf((float)var2_4)};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%f, %f] (too low)", objectArray));
        }
        if (f > var2_4) {
            Object[] objectArray = new Object[]{var3_5, Float.valueOf((float)var1_3), Float.valueOf((float)var2_4)};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%f, %f] (too high)", objectArray));
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    @KeepForSdk
    public static int checkArgumentInRange(int value, int lower, int upper, @NonNull String valueName) {
        int n;
        void var2_4;
        void var3_5;
        void var1_3;
        if (value < var1_3) {
            Object[] objectArray = new Object[]{var3_5, (int)var1_3, (int)var2_4};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%d, %d] (too low)", objectArray));
        }
        if (n > var2_4) {
            Object[] objectArray = new Object[]{var3_5, (int)var1_3, (int)var2_4};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%d, %d] (too high)", objectArray));
        }
        return n;
    }

    @CanIgnoreReturnValue
    @KeepForSdk
    public static int checkNotZero(int value) {
        int n;
        if (value == 0) {
            throw new IllegalArgumentException("Given Integer is zero");
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    @KeepForSdk
    public static int checkNotZero(int value, @NonNull Object errorMessage) {
        int n;
        if (value == 0) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static long checkArgumentInRange(long value, long lower, long upper, @NonNull String valueName) {
        long l;
        void var4_2;
        void var6_3;
        void var2_1;
        if (value < var2_1) {
            Object[] objectArray = new Object[]{var6_3, (long)var2_1, (long)var4_2};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%d, %d] (too low)", objectArray));
        }
        if (l > var4_2) {
            Object[] objectArray = new Object[]{var6_3, (long)var2_1, (long)var4_2};
            throw new IllegalArgumentException(Preconditions.zza("%s is out of range of [%d, %d] (too high)", objectArray));
        }
        return l;
    }

    @CanIgnoreReturnValue
    @KeepForSdk
    public static long checkNotZero(long value) {
        long l;
        if (value == 0L) {
            throw new IllegalArgumentException("Given Long is zero");
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @CanIgnoreReturnValue
    @KeepForSdk
    public static long checkNotZero(long value, @NonNull Object errorMessage) {
        long l;
        if (value == 0L) {
            void var2_1;
            throw new IllegalArgumentException(String.valueOf(var2_1));
        }
        return l;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@Nullable T reference) {
        T t;
        if (reference == null) {
            throw new NullPointerException("null reference");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@NonNull T reference, @NonNull Object errorMessage) {
        T t;
        if (reference == null) {
            void var1_1;
            throw new NullPointerException(String.valueOf(var1_1));
        }
        return t;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    @KeepForSdk
    @NonNull
    public static String checkNotEmpty(@Nullable String string2) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Given String is empty or null");
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    @KeepForSdk
    @NonNull
    public static String checkNotEmpty(@Nullable String string2, @NonNull Object errorMessage) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
        return string3;
    }

    private Preconditions() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    @KeepForSdk
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkArgument(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkArgument(boolean expression, @NonNull String errorMessage, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException(String.format((String)var1_1, (Object[])var2_2));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static void checkHandlerThread(@NonNull Handler handler) {
        void var1_3;
        Handler handler2;
        Looper looper = Looper.myLooper();
        if (looper == handler2.getLooper()) {
            return;
        }
        if (looper != null) {
            String string2 = looper.getThread().getName();
        } else {
            String string3 = "null current looper";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Must be called on ");
        stringBuilder.append(handler2.getLooper().getThread().getName());
        stringBuilder.append(" thread, but got ");
        stringBuilder.append((String)var1_3);
        stringBuilder.append(".");
        throw new IllegalStateException(stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkHandlerThread(@NonNull Handler handler, @NonNull String errorMessage) {
        Handler handler2;
        if (Looper.myLooper() != handler2.getLooper()) {
            void var1_1;
            throw new IllegalStateException((String)var1_1);
        }
    }

    @KeepForSdk
    public static void checkMainThread() {
        Preconditions.checkMainThread("Must be called on the main application thread");
    }

    @KeepForSdk
    public static void checkMainThread(@NonNull String errorMessage) {
        if (!zzb.zza()) {
            String string2;
            throw new IllegalStateException(string2);
        }
    }

    @KeepForSdk
    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    @KeepForSdk
    public static void checkNotMainThread(@NonNull String errorMessage) {
        if (zzb.zza()) {
            String string2;
            throw new IllegalStateException(string2);
        }
    }

    @KeepForSdk
    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalStateException(String.valueOf(var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull String errorMessage, Object ... errorMessageArgs) {
        if (!expression) {
            void var2_2;
            void var1_1;
            throw new IllegalStateException(String.format((String)var1_1, (Object[])var2_2));
        }
    }

    static String zza(String string2, Object ... objectArray) {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 48);
        n = 0;
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= 3 || (n3 = string2.indexOf("%s", n)) == -1) {
                stringBuilder.append(string2.substring(n));
                if (n2 < 3) {
                    stringBuilder.append(" [");
                    stringBuilder.append(objectArray[n2]);
                    for (int i = n2 + 1; i < 3; ++i) {
                        stringBuilder.append(", ");
                        stringBuilder.append(objectArray[i]);
                    }
                    stringBuilder.append("]");
                }
                return stringBuilder.toString();
            }
            stringBuilder.append(string2.substring(n, n3));
            stringBuilder.append(objectArray[n2]);
            n = n3 + 2;
            ++n2;
        }
    }
}

