/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.common.zzd;

@ShowFirstParty
@KeepForSdk
public class GoogleApiAvailabilityLight {
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final String TRACKING_SOURCE_DIALOG = "d";
    @KeepForSdk
    static final String TRACKING_SOURCE_NOTIFICATION = "n";
    private static final GoogleApiAvailabilityLight zza;

    @ShowFirstParty
    @KeepForSdk
    public int getApkVersion(@NonNull Context context) {
        return GooglePlayServicesUtilLight.getApkVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@NonNull Context context) {
        return GooglePlayServicesUtilLight.getClientVersion(context);
    }

    /*
     * WARNING - void declaration
     */
    @HideFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context) {
        void var1_1;
        return this.isGooglePlayServicesAvailable((Context)var1_1, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        void var1_2;
        void var2_3;
        int n = GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, (int)var2_3);
        if (GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating((Context)var1_2, n)) {
            return 18;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode, @Nullable String trackingSource) {
        void var3_3;
        void var4_4;
        void var2_2;
        void var1_1;
        if ((this = this.getErrorResolutionIntent((Context)var1_1, (int)var2_2, (String)var4_4)) == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)var1_1, (int)var3_3, (Intent)this, (int)(zzd.zza | 0x8000000));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(int errorCode) {
        void var1_1;
        return this.getErrorResolutionIntent(null, (int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int errorCode, @Nullable String trackingSource) {
        switch (errorCode) {
            case 3: {
                return zzt.zzc(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 1: 
            case 2: {
                void var3_3;
                void var1_1;
                if (var1_1 != null) {
                    if (DeviceProperties.isWearableWithoutPlayStore((Context)var1_1)) return zzt.zza();
                }
                Object object = new StringBuilder();
                ((StringBuilder)object).append("gcore_");
                ((StringBuilder)object).append(GOOGLE_PLAY_SERVICES_VERSION_CODE);
                ((StringBuilder)object).append("-");
                if (!TextUtils.isEmpty((CharSequence)var3_3)) {
                    ((StringBuilder)object).append((String)var3_3);
                }
                ((StringBuilder)object).append("-");
                if (var1_1 != null) {
                    ((StringBuilder)object).append(var1_1.getPackageName());
                }
                ((StringBuilder)object).append("-");
                if (var1_1 == null) return zzt.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                try {
                    ((StringBuilder)object).append(Wrappers.packageManager((Context)var1_1).getPackageInfo((String)var1_1.getPackageName(), (int)0).versionCode);
                    return zzt.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return zzt.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                }
            }
        }
        return null;
    }

    @KeepForSdk
    @NonNull
    public static GoogleApiAvailabilityLight getInstance() {
        return zza;
    }

    @KeepForSdk
    @NonNull
    public String getErrorString(int errorCode) {
        return GooglePlayServicesUtilLight.getErrorString(errorCode);
    }

    static {
        GoogleApiAvailabilityLight googleApiAvailabilityLight;
        GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtilLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        zza = googleApiAvailabilityLight = new GoogleApiAvailabilityLight();
    }

    @KeepForSdk
    GoogleApiAvailabilityLight() {
    }

    @KeepForSdk
    public void cancelAvailabilityErrorNotifications(@NonNull Context context) {
        GooglePlayServicesUtilLight.cancelAvailabilityErrorNotifications(context);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void verifyGooglePlayServicesIsAvailable(@NonNull Context context, int minApkVersion) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        void var2_2;
        GooglePlayServicesUtilLight.ensurePlayServicesAvailable(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayServicesPossiblyUpdating(@NonNull Context context, int errorCode) {
        void var2_2;
        return GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayStorePossiblyUpdating(@NonNull Context context, int errorCode) {
        void var2_2;
        return GooglePlayServicesUtilLight.isPlayStorePossiblyUpdating(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isUninstalledAppPossiblyUpdating(@NonNull Context context, @NonNull String packageName) {
        void var2_2;
        return GooglePlayServicesUtilLight.zza(context, (String)var2_2);
    }

    @KeepForSdk
    public boolean isUserResolvableError(int errorCode) {
        return GooglePlayServicesUtilLight.isUserRecoverableError(errorCode);
    }
}

