/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ProviderInstaller {
    private static final GoogleApiAvailabilityLight zza = GoogleApiAvailabilityLight.getInstance();
    private static final Object zzb = new Object();
    @GuardedBy(value="ProviderInstaller.lock")
    private static @MonotonicNonNull Method zzc = null;
    @GuardedBy(value="ProviderInstaller.lock")
    private static @MonotonicNonNull Method zzd = null;
    @RecentlyNonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    public static void installIfNeeded(@RecentlyNonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Preconditions.checkNotNull(context, "Context must not be null");
        zza.verifyGooglePlayServicesIsAvailable(context, 11925000);
        Object object = zzb;
        synchronized (object) {
            Context context2 = ProviderInstaller.zza(context);
            if (context2 != null) {
                ProviderInstaller.zza(context2, context, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                return;
            }
            context2 = ProviderInstaller.zza(context, true);
            if (context2 != null) {
                ProviderInstaller.zza(context2, context, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    public static void installIfNeededAsync(@RecentlyNonNull Context context, @RecentlyNonNull ProviderInstallListener providerInstallListener) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(providerInstallListener, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context, providerInstallListener).execute(new Void[0]);
    }

    @Nullable
    private static Context zza(Context context) {
        try {
            return DynamiteModule.load(context, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite").getModuleContext();
        }
        catch (DynamiteModule.LoadingException loadingException) {
            String string2 = String.valueOf(loadingException.getMessage());
            Log.w((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to load providerinstaller module: ".concat(string2) : new String("Failed to load providerinstaller module: ")));
            return null;
        }
    }

    @GuardedBy(value="ProviderInstaller.lock")
    private static void zza(Context context, Context context2, String string2) throws GooglePlayServicesNotAvailableException {
        try {
            if (zzc == null) {
                zzc = ProviderInstaller.zza(context, string2, "insertProvider", new Class[]{Context.class});
            }
            zzc.invoke(null, context);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            Throwable throwable = exception.getCause();
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                String string3 = throwable == null ? exception2.getMessage() : throwable.getMessage();
                String string4 = String.valueOf(string3);
                Log.e((String)"ProviderInstaller", (String)(string4.length() != 0 ? "Failed to install provider: ".concat(string4) : new String("Failed to install provider: ")));
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    private static Method zza(Context context, String string2, String string3, Class[] classArray) throws ClassNotFoundException, NoSuchMethodException {
        return context.getClassLoader().loadClass(string2).getMethod(string3, classArray);
    }

    @GuardedBy(value="ProviderInstaller.lock")
    @Nullable
    private static Context zza(Context context, boolean bl) throws GooglePlayServicesNotAvailableException {
        long l = SystemClock.elapsedRealtime();
        Context context2 = GooglePlayServicesUtilLight.getRemoteContext(context);
        try {
            if (context2 != null) {
                if (zzd == null) {
                    zzd = ProviderInstaller.zza(context2, "com.google.android.gms.common.security.ProviderInstallerImpl", "reportRequestStats", new Class[]{Context.class, Long.TYPE});
                }
                zzd.invoke(null, context, l);
            }
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception.getMessage());
            Log.w((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to report request stats: ".concat(string2) : new String("Failed to report request stats: ")));
        }
        return context2;
    }

    static /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, @Nullable Intent var2);
    }
}

