/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util.concurrent;

import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.concurrent.zza;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@KeepForSdk
public class NumberedThreadFactory
implements ThreadFactory {
    private final String zza;
    private final int zzb;
    private final AtomicInteger zzc = new AtomicInteger();
    private final ThreadFactory zzd = Executors.defaultThreadFactory();

    @KeepForSdk
    public NumberedThreadFactory(@RecentlyNonNull String string2) {
        this(string2, 0);
    }

    private NumberedThreadFactory(String string2, int n) {
        this.zza = Preconditions.checkNotNull(string2, "Name must not be null");
        this.zzb = 0;
    }

    @Override
    @RecentlyNonNull
    public Thread newThread(@RecentlyNonNull Runnable runnable) {
        Thread thread = this.zzd.newThread(new zza(runnable, 0));
        String string2 = this.zza;
        int n = this.zzc.getAndIncrement();
        thread.setName(new StringBuilder(13 + String.valueOf(string2).length()).append(string2).append("[").append(n).append("]").toString());
        return thread;
    }
}

